/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.utilities.StringPair;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.DirectoryVisitor;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;

public class POGenerator {
    private List<String> prefixes = new ArrayList<String>();

    public static void main(String[] args) throws IOException {
        new POGenerator().execute(args[0], args[1], args[2]);
    }

    private void execute(String core, String igpub, String pascal) throws IOException {
        String source = Utilities.path(core, "/org.hl7.fhir.utilities/src/main/resources");
        if (this.checkState(source, core, igpub, pascal)) {
            this.generate(source, "rendering-phrases.properties", "rendering-phrases-en.po", null, 2);
            this.generate(source, "rendering-phrases.properties", "rendering-phrases-de.po", "rendering-phrases_de.properties", 2);
            this.generate(source, "rendering-phrases.properties", "rendering-phrases-es.po", "rendering-phrases_es.properties", 3);
            this.generate(source, "rendering-phrases.properties", "rendering-phrases-ja.po", "rendering-phrases_ja.properties", 2);
            this.generate(source, "rendering-phrases.properties", "rendering-phrases-nl.po", "rendering-phrases_nl.properties", 2);
            this.generate(source, "rendering-phrases.properties", "rendering-phrases-pt_BR.po", "rendering-phrases_pt-BR.properties", 2);
            this.generate(source, "Messages.properties", "validator-messages-en.po", null, 2);
            this.generate(source, "Messages.properties", "validator-messages-de.po", "Messages_de.properties", 2);
            this.generate(source, "Messages.properties", "validator-messages-es.po", "Messages_es.properties", 3);
            this.generate(source, "Messages.properties", "validator-messages-ja.po", "Messages_ja.properties", 2);
            this.generate(source, "Messages.properties", "validator-messages-nl.po", "Messages_nl.properties", 2);
            this.generate(source, "Messages.properties", "validator-messages-pt_BR.po", "Messages_pt-BR.properties", 2);
            System.out.println("Finished");
        }
    }

    private boolean checkState(String source, String core, String igpub, String pascal) throws IOException {
        System.out.println("Checking...");
        List<PropertyValue> props = this.loadProperties(Utilities.path(source, "rendering-phrases.properties"), true);
        List<ConstantDefinition> consts = this.loadConstants(Utilities.path(core, "/org.hl7.fhir.utilities/src/main/java/org/hl7/fhir/utilities/i18n/RenderingI18nContext.java"));
        boolean ok = true;
        for (ConstantDefinition cd : consts) {
            boolean found = false;
            for (PropertyValue p : props) {
                String pn = p.getBaseName();
                if (!pn.equals(cd.sname) && !p.getName().equals(cd.sname)) continue;
                found = true;
                p.used = true;
            }
            cd.defined = found;
        }
        this.scanJavaSource(core, consts, "RenderingI18nContext", "RenderingContext");
        this.scanJavaSource(igpub, consts, "RenderingI18nContext", "RenderingContext");
        this.scanPascalSource(pascal, props);
        HashSet<String> pns = new HashSet<String>();
        for (PropertyValue p : props) {
            if (!p.used) {
                ok = false;
                System.out.println("Error: PV " + p.getName() + " provided but not used");
            }
            if (!pns.contains(p.getName())) {
                pns.add(p.getName());
            } else {
                System.out.println("Error: PV " + p.getName() + " duplicated");
            }
            if (!p.getValue().contains("\\n")) continue;
            System.out.println("Error: PV " + p.getName() + " has a \\n");
        }
        for (ConstantDefinition cd : consts) {
            if (!cd.defined && !cd.used) {
                System.out.println("Error: " + cd.name + " not defined or used");
                ok = false;
                continue;
            }
            if (!cd.defined) {
                ok = false;
                System.out.println("Error: msg for " + cd.name + " not found at " + cd.sname);
                continue;
            }
            if (cd.used) continue;
            System.out.println("Warning: const " + cd.name + " not used");
            ok = false;
        }
        props = this.loadProperties(Utilities.path(source, "Messages.properties"), true);
        consts = this.loadConstants(Utilities.path(core, "/org.hl7.fhir.utilities/src/main/java/org/hl7/fhir/utilities/i18n/I18nConstants.java"));
        for (ConstantDefinition cd : consts) {
            boolean found = false;
            for (PropertyValue p : props) {
                String pn = p.getBaseName();
                if (!pn.equals(cd.sname) && !p.getName().equals(cd.sname)) continue;
                found = true;
                p.used = true;
            }
            cd.defined = found;
        }
        this.scanJavaSource(core, consts, "I18nConstants");
        this.scanJavaSource(igpub, consts, "I18nConstants");
        this.scanPascalSource(pascal, props);
        pns = new HashSet();
        for (PropertyValue p : props) {
            if (!p.used) {
                ok = false;
                System.out.println("Error: PV " + p.getName() + " provided but not used");
            }
            if (!pns.contains(p.getName())) {
                pns.add(p.getName());
            } else {
                System.out.println("Error: PV " + p.getName() + " duplicated");
            }
            if (!p.getValue().contains("\\n")) continue;
            System.out.println("Error: PV " + p.getName() + " has a \\n");
        }
        for (ConstantDefinition cd : consts) {
            if (!cd.defined && !cd.used) {
                System.out.println("Error: " + cd.name + " not defined or used");
                ok = false;
                continue;
            }
            if (!cd.defined) {
                ok = false;
                System.out.println("Error: msg for " + cd.name + " not found @ " + cd.sname);
                continue;
            }
            if (cd.used) continue;
            System.out.println("Warning: const " + cd.name + " not used");
            ok = false;
        }
        if (ok) {
            System.out.println("No Errors Found");
        } else {
            System.out.println("Errors Found, so not continuing");
        }
        return ok;
    }

    private void scanJavaSource(String path, List<ConstantDefinition> consts, String ... names) throws FileNotFoundException, IOException {
        JavaScanner scanner = new JavaScanner();
        scanner.consts = consts;
        scanner.names = new ArrayList<String>();
        for (String s : names) {
            scanner.names.add(s);
        }
        DirectoryVisitor.visitDirectory((DirectoryVisitor.IDirectoryVisitorImplementation)scanner, path, "java");
    }

    private void scanPascalSource(String path, List<PropertyValue> defs) throws FileNotFoundException, IOException {
        PascalScanner scanner = new PascalScanner();
        scanner.defs = defs;
        DirectoryVisitor.visitDirectory((DirectoryVisitor.IDirectoryVisitorImplementation)scanner, path, "pas");
    }

    private List<ConstantDefinition> loadConstants(String path) throws FileNotFoundException, IOException {
        ArrayList<ConstantDefinition> res = new ArrayList<ConstantDefinition>();
        for (String line : TextFile.fileToLines(path)) {
            int i;
            String[] p;
            if (!line.contains("public static final String") || line.trim().startsWith("//") || (p = line.substring(i = line.indexOf("public static final String") + "public static final String".length()).split("\\=")).length != 2) continue;
            String n = p[0].trim();
            String v = p[1].trim().replace("\"", "").replace(";", "");
            ConstantDefinition cd = new ConstantDefinition();
            cd.name = n;
            cd.sname = v;
            res.add(cd);
        }
        return res;
    }

    private void generate(String source, String src, String dest, String tgt, int count) throws IOException {
        Integer c;
        List<POObject> objects = this.loadPOFile(Utilities.path(source, "source", dest));
        List<PropertyValue> props = this.loadProperties(Utilities.path(source, src), false);
        for (PropertyValue e : props) {
            String name = e.getName();
            int mode = 0;
            if (name.endsWith("_one")) {
                mode = 1;
                name = name.substring(0, name.length() - 4);
            } else if (name.endsWith("_other")) {
                mode = 2;
                name = name.substring(0, name.length() - 6);
            }
            POObject o2 = this.findObject(objects, name);
            if (o2 == null) {
                if (mode > 1) {
                    throw new Error("Not right");
                }
                o2 = new POObject();
                o2.id = name;
                o2.comment = name;
                objects.add(o2);
                o2.msgid = e.getValue();
                o2.orphan = false;
                continue;
            }
            this.update(o2, mode, e.getValue());
        }
        objects.removeIf(o -> o.orphan);
        Collections.sort(objects, new POObjectSorter());
        HashMap<String, Integer> sources = new HashMap<String, Integer>();
        HashSet<String> dups = new HashSet<String>();
        for (POObject o3 : objects) {
            if (sources.containsKey(o3.msgid)) {
                c = (Integer)sources.get(o3.msgid) + 1;
                sources.put(o3.msgid, c);
                dups.add(o3.msgid);
                continue;
            }
            sources.put(o3.msgid, 1);
        }
        for (POObject o4 : objects) {
            c = (Integer)sources.get(o4.msgid);
            if (c <= 1) continue;
            o4.duplicate = true;
        }
        this.savePOFile(Utilities.path(source, "source", dest), objects, count, false);
        if (tgt == null) {
            this.savePOFile(Utilities.path(source, "source", "transifex", dest), objects, count, true);
        } else {
            this.savePOFile(Utilities.path(source, "source", "transifex", "translations", dest), objects, count, true);
        }
        if (tgt != null) {
            this.savePropFile(Utilities.path(source, tgt), objects);
        }
    }

    private Set<String> listIds(List<POObject> objects, String msgid) {
        HashSet<String> res = new HashSet<String>();
        for (POObject o : objects) {
            if (!o.msgid.equals(msgid)) continue;
            res.add(o.id);
        }
        return res;
    }

    private void savePOFile(String dest, List<POObject> objects, int count, boolean tfxMode) throws IOException {
        this.prefixes.clear();
        StringBuilder b = new StringBuilder();
        for (String p : this.prefixes) {
            b.append(p);
            b.append("\r\n");
        }
        b.append("\r\n");
        for (POObject o : objects) {
            if (o.oldMsgId != null) {
                b.append("# " + o.comment + " (!!when last translated was: " + o.oldMsgId + ")\r\n");
            } else {
                b.append("# " + o.comment + "\r\n");
            }
            b.append("#: " + o.id + "\r\n");
            if (o.duplicate) {
                b.append("msgctxt \"" + o.id + "\"\r\n");
            }
            String m = tfxMode && Utilities.noString(o.msgid) ? "-- no content: do not translate --" : o.msgid;
            b.append("msgid \"" + this.wrapQuotes(m) + "\"\r\n");
            if (o.msgidPlural != null) {
                b.append("msgid_plural \"" + this.wrapQuotes(o.msgidPlural) + "\"\r\n");
                while (o.msgstr.size() < count) {
                    o.msgstr.add("");
                }
                for (int i = 0; i < o.msgstr.size(); ++i) {
                    b.append("msgstr[" + i + "] \"" + this.wrapQuotes(o.msgstr.get(i)) + "\"\r\n");
                }
            } else if (o.msgstr.size() == 0) {
                b.append("msgstr \"\"\r\n");
            } else {
                b.append("msgstr \"" + this.wrapQuotes(o.msgstr.get(0)) + "\"\r\n");
            }
            b.append("\r\n");
        }
        TextFile.stringToFile(b.toString(), dest);
    }

    private String wrapQuotes(String s) {
        return s.replace("\"", "\\\"");
    }

    private void update(POObject o, int mode, String value) {
        o.orphan = false;
        if (o.comment == null) {
            o.comment = o.id;
        }
        if (mode == 0) {
            if (!value.equals(o.msgid)) {
                if (o.oldMsgId != null && !o.msgstr.isEmpty()) {
                    o.oldMsgId = o.msgid;
                }
                o.msgid = value;
                for (int i = 0; i < o.msgstr.size(); ++i) {
                    if (Utilities.noString(o.msgstr.get(i))) continue;
                    o.msgstr.set(i, "!!" + o.msgstr.get(i));
                }
            } else {
                o.oldMsgId = null;
            }
        } else if (mode == 1) {
            if (!value.equals(o.msgid)) {
                if (o.oldMsgId != null && !o.msgstr.isEmpty()) {
                    o.oldMsgId = o.msgid;
                }
                o.msgid = value;
                if (o.msgstr.size() > 0 && !Utilities.noString(o.msgstr.get(0))) {
                    o.msgstr.set(0, "!!" + o.msgstr.get(0));
                }
            } else {
                o.oldMsgId = null;
            }
        } else if (mode == 2) {
            if (!value.equals(o.msgidPlural)) {
                o.msgidPlural = value;
                if (o.msgstr.size() > 1 && !Utilities.noString(o.msgstr.get(1))) {
                    o.msgstr.set(1, "!!" + o.msgstr.get(1));
                }
            } else {
                o.oldMsgId = null;
            }
        }
    }

    private POObject findObject(List<POObject> objects, String name) {
        for (POObject t : objects) {
            if (!t.id.equals(name)) continue;
            return t;
        }
        return null;
    }

    private List<POObject> loadPOFile(String dest) throws FileNotFoundException, IOException {
        ArrayList<POObject> list = new ArrayList<POObject>();
        POObject obj = null;
        for (String line : TextFile.fileToLines(dest)) {
            if (Utilities.noString(line)) continue;
            if (line.startsWith("#:")) {
                if (obj == null || obj.id != null) {
                    obj = new POObject();
                    list.add(obj);
                }
                obj.id = line.substring(2).trim();
                continue;
            }
            if (line.startsWith("# ")) {
                if (obj == null || obj.comment != null) {
                    obj = new POObject();
                    list.add(obj);
                }
                obj.comment = line.substring(1).trim();
                if (!obj.comment.contains("!!when")) continue;
                obj.oldMsgId = obj.comment.substring(obj.comment.indexOf("!!when"));
                obj.comment = obj.comment.substring(0, obj.comment.indexOf("!!when") - 1);
                obj.oldMsgId = obj.oldMsgId.substring(obj.oldMsgId.indexOf(": ") + 2).trim();
                obj.oldMsgId = obj.oldMsgId.substring(0, obj.oldMsgId.length() - 1);
                continue;
            }
            if (obj == null) {
                this.prefixes.add(line);
                continue;
            }
            if (line.startsWith("#|")) {
                obj.oldMsgId = line.substring(2).trim();
                if (!obj.oldMsgId.startsWith("msgid ")) continue;
                obj.oldMsgId = this.trimQuotes(obj.oldMsgId.substring(6));
                continue;
            }
            if (line.startsWith("msgid ")) {
                obj.msgid = this.trimQuotes(line.substring(5).trim());
                if (!obj.msgid.endsWith("(" + obj.id + ")")) continue;
                obj.msgid = obj.msgid.substring(0, obj.msgid.length() - (obj.id.length() + 3));
                continue;
            }
            if (line.startsWith("msgid_plural ")) {
                obj.msgidPlural = this.trimQuotes(line.substring(12).trim());
                continue;
            }
            if (line.startsWith("msgstr ")) {
                obj.msgstr.add(this.trimQuotes(line.substring(6).trim()));
                continue;
            }
            if (line.startsWith("msgctxt ")) continue;
            if (line.startsWith("msgstr[")) {
                String s = line.substring(7);
                int i = s.indexOf("]");
                int c = Integer.valueOf(s.substring(0, i));
                s = this.trimQuotes(s.substring(i + 1).trim());
                while (s.startsWith("!!")) {
                    s = s.substring(2);
                }
                if (c != obj.msgstr.size()) {
                    System.out.println("index issue");
                    continue;
                }
                obj.msgstr.add(s);
                continue;
            }
            System.out.println("unknown line: " + line);
        }
        return list;
    }

    private String trimQuotes(String s) {
        if ((s = s.trim()).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s.trim().replace("\\\"", "\"");
    }

    private List<PropertyValue> loadProperties(String source, boolean checking) throws IOException {
        ArrayList<PropertyValue> res = new ArrayList<PropertyValue>();
        File src = ManagedFileAccess.file(source);
        List<String> lines = Files.readAllLines(src.toPath());
        for (String line : lines) {
            if (line.startsWith("#") || !line.contains("=")) continue;
            String n = line.substring(0, line.indexOf("=")).trim();
            String v = line.substring(line.indexOf("=") + 1).trim();
            if (!checking && v.length() == 3 && v.startsWith("{") && v.endsWith("}")) continue;
            res.add(new PropertyValue(n, v));
        }
        return res;
    }

    private void savePropFile(String tgt, List<POObject> objects) throws IOException {
        String nameLine = TextFile.fileToLines(tgt)[0];
        String[] parts = nameLine.substring(1).trim().split("\\=");
        String[] names = parts[1].split("\\,");
        StringBuilder b = new StringBuilder();
        b.append(nameLine + "\r\n");
        for (POObject o : objects) {
            if (o.msgidPlural == null) {
                String v = o.msgstr.size() > 0 ? o.msgstr.get(0) : "";
                if (Utilities.noString(v)) continue;
                b.append(o.id + " = " + v + "\r\n");
                continue;
            }
            for (int i = 0; i < names.length; ++i) {
                String v;
                String string = v = o.msgstr.size() > i ? o.msgstr.get(i) : "";
                if (Utilities.noString(v)) continue;
                b.append(o.id + "_" + names[i].trim() + " = " + v + "\r\n");
            }
        }
        TextFile.stringToFile(b.toString(), tgt);
    }

    private class PascalScanner
    implements DirectoryVisitor.IDirectoryVisitorImplementation {
        private List<PropertyValue> defs;

        private PascalScanner() {
        }

        @Override
        public boolean enterDirectory(File directory) throws IOException {
            return true;
        }

        @Override
        public boolean visitFile(File file) throws IOException {
            String source = TextFile.fileToString(file);
            for (PropertyValue pv : this.defs) {
                if (pv.used) continue;
                boolean found = false;
                String pn = pv.getBaseName();
                if (source.contains("'" + pn + "'")) {
                    found = true;
                }
                if (!found) continue;
                pv.used = true;
            }
            return true;
        }
    }

    private class JavaScanner
    implements DirectoryVisitor.IDirectoryVisitorImplementation {
        List<ConstantDefinition> consts;
        List<String> names;

        private JavaScanner() {
        }

        @Override
        public boolean enterDirectory(File f) throws IOException {
            return !Utilities.existsInList(f.getName(), "model", "formats");
        }

        @Override
        public boolean visitFile(File file) throws IOException {
            String source = TextFile.fileToString(file);
            for (ConstantDefinition cd : this.consts) {
                if (cd.used) continue;
                boolean found = false;
                for (String n : this.names) {
                    if (source.contains(n + "." + cd.name + ",")) {
                        found = true;
                    }
                    if (source.contains(n + "." + cd.name + ")")) {
                        found = true;
                    }
                    if (source.contains(n + "." + cd.name + " :")) {
                        found = true;
                    }
                    if (!source.contains(n + "." + cd.name + ";")) continue;
                    found = true;
                }
                if (!found) continue;
                cd.used = true;
            }
            return true;
        }
    }

    private class POObject {
        private boolean orphan = true;
        private boolean duplicate;
        private String id;
        private String msgid;
        private String oldMsgId;
        private String msgidPlural;
        private String comment;
        private List<String> msgstr = new ArrayList<String>();

        private POObject() {
        }
    }

    public class POObjectSorter
    implements Comparator<POObject> {
        @Override
        public int compare(POObject o1, POObject o2) {
            return o1.id.compareTo(o2.id);
        }
    }

    public class ConstantDefinition {
        private String name;
        private String sname;
        private boolean defined;
        private boolean used;
    }

    public class PropertyValue
    extends StringPair {
        private boolean used;

        public PropertyValue(String name, String value) {
            super(name, value);
        }

        public String getBaseName() {
            String res = this.getName();
            if (res.endsWith("_one")) {
                res = res.substring(0, res.length() - 4);
            } else if (res.endsWith("_other")) {
                res = res.substring(0, res.length() - 6);
            }
            return res;
        }
    }
}

