/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.json.model;

public class JsonLocationData {
    private int line;
    private int col;
    private int lastCol;

    public JsonLocationData(int line, int col) {
        this.line = line;
        this.col = col;
        this.lastCol = col;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public void newLine() {
        ++this.line;
        this.lastCol = this.col;
        this.col = 1;
    }

    public JsonLocationData copy() {
        return new JsonLocationData(this.line, this.col);
    }

    public void incCol() {
        ++this.col;
    }

    public String toString() {
        return "(" + this.line + ", " + this.col + ")";
    }

    public JsonLocationData prev() {
        if (this.col == 1) {
            return new JsonLocationData(this.line - 1, this.lastCol);
        }
        return new JsonLocationData(this.line, this.col - 1);
    }

    public void back() {
        if (this.col == 1) {
            --this.line;
            this.col = this.lastCol;
        } else {
            --this.col;
        }
    }
}

