/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.json.model;

import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonElementType;
import org.hl7.fhir.utilities.json.model.JsonPrimitive;

public class JsonString
extends JsonPrimitive {
    private String value;

    public JsonString(String value) {
        this.value = value;
    }

    private JsonString() {
    }

    @Override
    public JsonElementType type() {
        return JsonElementType.STRING;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "\"" + Utilities.escapeJson(this.value) + "\"";
    }

    @Override
    public String toJson() {
        return "\"" + Utilities.escapeJson(this.value) + "\"";
    }

    @Override
    protected JsonElement copy(JsonElement other) {
        this.value = ((JsonString)other).value;
        return this;
    }

    @Override
    protected JsonElement make() {
        return new JsonString();
    }
}

