/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.json.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.model.JsonComment;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonLocationData;

public class JsonLexer {
    private String source;
    private int cursor;
    private String peek;
    private String value;
    private TokenType type;
    private Stack<State> states = new Stack();
    private JsonLocationData lastLocationBWS;
    private JsonLocationData lastLocationAWS;
    private JsonLocationData location;
    private StringBuilder b = new StringBuilder();
    private boolean allowComments;
    private boolean allowUnquotedStrings;
    private List<JsonComment> comments = new ArrayList<JsonComment>();
    private boolean isUnquoted;
    private String sourceName;

    public JsonLexer(String source, boolean allowComments, boolean allowUnquotedStrings) throws IOException {
        this.source = source;
        this.allowComments = allowComments;
        this.allowUnquotedStrings = allowUnquotedStrings;
        this.cursor = -1;
        this.location = new JsonLocationData(1, 1);
        this.start();
    }

    private boolean more() {
        return this.peek != null || this.cursor < this.source.length();
    }

    private String getNext(int length) throws IOException {
        Object result = "";
        if (this.peek != null) {
            if (this.peek.length() > length) {
                result = this.peek.substring(0, length);
                this.peek = this.peek.substring(length);
            } else {
                result = this.peek;
                this.peek = null;
            }
        }
        if (((String)result).length() < length) {
            int len = length - ((String)result).length();
            if (this.cursor > this.source.length() - len) {
                throw this.error("Attempt to read past end of source");
            }
            result = (String)result + this.source.substring(this.cursor + 1, this.cursor + len + 1);
            this.cursor += len;
        }
        for (char ch : ((String)result).toCharArray()) {
            if (ch == '\n') {
                this.location.newLine();
                continue;
            }
            this.location.incCol();
        }
        return result;
    }

    private char getNextChar() throws IOException {
        char ch;
        if (this.peek != null) {
            ch = this.peek.charAt(0);
            this.peek = this.peek.length() == 1 ? null : this.peek.substring(1);
        } else {
            ++this.cursor;
            ch = this.cursor >= this.source.length() ? (char)'\u0000' : this.source.charAt(this.cursor);
        }
        if (ch == '\n') {
            this.location.newLine();
        } else {
            this.location.incCol();
        }
        return ch;
    }

    private void push(char ch) {
        this.peek = this.peek == null ? String.valueOf(ch) : String.valueOf(ch) + this.peek;
        this.location.back();
    }

    public IOException error(String msg) {
        return new IOException("Error parsing JSON source: " + msg + " at Line " + Integer.toString(this.location.getLine()) + " (path=[" + this.path() + "])" + (String)(this.sourceName == null ? "" : " from '" + this.sourceName + "'"));
    }

    private String path() {
        if (this.states.empty()) {
            return this.value;
        }
        Object result = "";
        for (State s : this.states) {
            result = (String)result + "/" + s.getName();
        }
        result = (String)result + this.value;
        return result;
    }

    public void start() throws IOException {
        this.next();
    }

    public TokenType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public JsonLocationData getLastLocationBWS() {
        return this.lastLocationBWS;
    }

    public JsonLocationData getLastLocationAWS() {
        return this.lastLocationAWS;
    }

    public void next() throws IOException {
        char ch;
        this.lastLocationBWS = this.location.copy();
        do {
            ch = this.getNextChar();
            if (!this.allowComments || ch != '/') continue;
            JsonLocationData start = this.location.prev();
            char ch1 = this.getNextChar();
            if (ch1 == '/') {
                StringBuilder b = new StringBuilder();
                boolean first = true;
                while (this.more() && !Utilities.charInSet(ch, '\r', '\n')) {
                    if (first) {
                        first = false;
                    } else {
                        b.append(ch);
                    }
                    ch = this.getNextChar();
                }
                this.comments.add(new JsonComment(b.toString().trim(), start, this.location.prev()));
                continue;
            }
            this.push(ch1);
        } while (this.more() && Utilities.charInSet(ch, ' ', '\r', '\n', '\t'));
        this.lastLocationAWS = this.location.copy().prev();
        this.isUnquoted = false;
        if (!this.more()) {
            this.type = TokenType.Eof;
        } else {
            switch (ch) {
                case '{': {
                    this.type = TokenType.Open;
                    break;
                }
                case '}': {
                    this.type = TokenType.Close;
                    break;
                }
                case '\"': {
                    this.type = TokenType.String;
                    this.b.setLength(0);
                    do {
                        if ((ch = this.getNextChar()) == '\\') {
                            ch = this.getNextChar();
                            switch (ch) {
                                case '\"': {
                                    this.b.append('\"');
                                    break;
                                }
                                case '\'': {
                                    this.b.append('\'');
                                    break;
                                }
                                case '\\': {
                                    this.b.append('\\');
                                    break;
                                }
                                case '/': {
                                    this.b.append('/');
                                    break;
                                }
                                case 'n': {
                                    this.b.append('\n');
                                    break;
                                }
                                case 'r': {
                                    this.b.append('\r');
                                    break;
                                }
                                case 't': {
                                    this.b.append('\t');
                                    break;
                                }
                                case 'u': {
                                    this.b.append((char)Integer.parseInt(this.getNext(4), 16));
                                    break;
                                }
                                default: {
                                    throw this.error("unknown escape sequence: \\" + ch);
                                }
                            }
                            ch = ' ';
                            continue;
                        }
                        if (ch == '\"') continue;
                        this.b.append(ch);
                    } while (this.more() && ch != '\"');
                    if (!this.more()) {
                        throw this.error("premature termination of json stream during a string");
                    }
                    this.value = this.b.toString();
                    break;
                }
                case ':': {
                    this.type = TokenType.Colon;
                    break;
                }
                case ',': {
                    this.type = TokenType.Comma;
                    break;
                }
                case '[': {
                    this.type = TokenType.OpenArray;
                    break;
                }
                case ']': {
                    this.type = TokenType.CloseArray;
                    break;
                }
                default: {
                    if (ch >= '0' && ch <= '9' || ch == '-') {
                        this.type = TokenType.Number;
                        this.b.setLength(0);
                        while (this.more() && (ch >= '0' && ch <= '9' || ch == '-' || ch == '.') || ch == '+' || ch == 'e' || ch == 'E') {
                            this.b.append(ch);
                            ch = this.getNextChar();
                        }
                        this.value = this.b.toString();
                        this.push(ch);
                        break;
                    }
                    if (!Utilities.isAlphabetic(ch) && ch != '_') break;
                    this.type = TokenType.String;
                    this.isUnquoted = true;
                    this.b.setLength(0);
                    while (this.more() && (Utilities.isAlphabetic(ch) || Utilities.isDigit(ch) || Utilities.existsInList(ch, 95, 46, 45))) {
                        this.b.append(ch);
                        ch = this.getNextChar();
                    }
                    this.value = this.b.toString();
                    this.push(ch);
                    if ("true".equals(this.value) || "false".equals(this.value)) {
                        this.type = TokenType.Boolean;
                        this.isUnquoted = false;
                        break;
                    }
                    if ("null".equals(this.value)) {
                        this.type = TokenType.Null;
                        this.isUnquoted = false;
                        break;
                    }
                    if (this.allowUnquotedStrings) break;
                    throw this.error("Unexpected token '" + this.value + "' in json stream");
                }
            }
        }
    }

    public String consume(TokenType type) throws IOException {
        if (this.type != type) {
            throw this.error("JSON syntax error - found " + this.type.toString() + " expecting " + type.toString());
        }
        String result = this.value;
        this.next();
        return result;
    }

    public JsonLocationData getLocation() {
        return this.location;
    }

    public Stack<State> getStates() {
        return this.states;
    }

    public void takeComments(JsonElement child) {
        if (!this.comments.isEmpty()) {
            child.getComments().addAll(this.comments);
            this.comments.clear();
        }
    }

    public boolean isUnquoted() {
        return this.isUnquoted;
    }

    public String toString() {
        return "JsonLexer [cursor=" + this.cursor + ", peek=" + this.peek + ", type=" + this.type + ", location=" + this.location.toString() + "]";
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public static enum TokenType {
        Open,
        Close,
        String,
        Number,
        Colon,
        Comma,
        OpenArray,
        CloseArray,
        Eof,
        Null,
        Boolean;


        boolean isValueType() {
            return this == Open || this == String || this == Number || this == OpenArray || this == Boolean || this == Null;
        }
    }

    public static class State {
        private String name;
        private boolean isProp;

        public State(String name, boolean isProp) {
            this.name = name;
            this.isProp = isProp;
        }

        public String getName() {
            return this.name;
        }

        public boolean isProp() {
            return this.isProp;
        }
    }
}

