/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.core.impl.DSILogger;
import com.amazon.dsi.core.interfaces.IEnvironment;
import com.amazon.dsi.core.utilities.Variant;
import com.amazon.jdbc.common.ProductInfoHandlerContext;
import com.amazon.jdbc.communications.exceptions.MessagesFrameworkMessageKey;
import com.amazon.redshift.core.PGJDBCEnvironment;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.channels.SocketChannelMessageKey;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionBuilder;
import com.amazon.support.exceptions.ExceptionUtilities;
import java.text.MessageFormat;

public class PGJDBCDriver
extends DSIDriver {
    public static final int DRIVER_MAJOR_VERSION = Integer.valueOf("1");
    public static final int DRIVER_MINOR_VERSION = Integer.valueOf("2");
    public static final int DRIVER_HOT_FIX_VERSION = Integer.valueOf("32");
    public static final int DRIVER_BUILD_NUMBER = Integer.valueOf("1056");
    public static final String RESOURCE_NAME = "messages";
    public static ExceptionBuilder s_PostgreSQLMessages = new ExceptionBuilder(101);
    private final String POSTGRESSQL_LOG_NAME = "RedshiftJDBC_driver";
    private DSILogger m_log;
    private String m_componentName;

    public PGJDBCDriver() throws ErrorException {
        this.setDefaultProperties();
        StringBuilder stringBuilder = new StringBuilder(ExceptionUtilities.getPackageName(this.getClass()));
        stringBuilder.append(".");
        stringBuilder.append(RESOURCE_NAME);
        this.m_msgSrc.registerMessages(stringBuilder.toString(), 101, this.m_componentName);
        this.m_msgSrc.setVendorName("Amazon");
        stringBuilder = new StringBuilder(ExceptionUtilities.getPackageName(MessagesFrameworkMessageKey.class));
        stringBuilder.append(".");
        stringBuilder.append(RESOURCE_NAME);
        this.m_msgSrc.registerMessages(stringBuilder.toString(), 1001, this.m_componentName);
        stringBuilder = new StringBuilder(ExceptionUtilities.getPackageName(SocketChannelMessageKey.class));
        stringBuilder.append(".");
        stringBuilder.append(RESOURCE_NAME);
        this.m_msgSrc.registerMessages(stringBuilder.toString(), 8, this.m_componentName);
        ProductInfoHandlerContext.setDefaultMsgSource(this.m_msgSrc, this.m_componentName);
    }

    @Override
    public IEnvironment createEnvironment() throws ErrorException {
        return new PGJDBCEnvironment(this);
    }

    @Override
    public ILogger getDriverLog() {
        if (null == this.m_log) {
            this.m_log = new DSILogger("RedshiftJDBC_driver");
        }
        return this.m_log;
    }

    private void setDefaultProperties() throws ErrorException {
        try {
            this.setProperty(3, new Variant(0, "RedshiftJDBC"));
            String string = MessageFormat.format("{0,number,00}.{1,number,00}.{2,number,00}.{3,number,0000}", DRIVER_MAJOR_VERSION, DRIVER_MINOR_VERSION, DRIVER_HOT_FIX_VERSION, DRIVER_BUILD_NUMBER);
            this.setProperty(5, new Variant(0, string));
            this.setProperty(1000, new Variant(5, (short)1));
            this.setProperty(10, new Variant(6, 1));
            this.setProperty(22, new Variant(7, 0L));
        }
        catch (Throwable throwable) {
            ErrorException errorException = s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.DRIVER_DEFAULT_PROP_ERR.name(), "Driver property set error");
            errorException.initCause(throwable);
            throw errorException;
        }
    }
}

