/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aebuilder.statement;

import com.amazon.dsi.dataengine.utilities.ParameterType;
import com.amazon.sqlengine.aeprocessor.AEUtils;
import com.amazon.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.amazon.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.amazon.sqlengine.aeprocessor.aebuilder.value.AEValueExprBuilder;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEProcedure;
import com.amazon.sqlengine.aeprocessor.aetree.statement.AEProcedureCall;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEDefaultParameter;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.amazon.sqlengine.dsiext.dataengine.ProcedureParameterMetadata;
import com.amazon.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.amazon.sqlengine.dsiext.dataengine.StoredProcedure;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.parser.parsetree.IPTNode;
import com.amazon.sqlengine.parser.parsetree.PTListNode;
import com.amazon.sqlengine.parser.parsetree.PTNonterminalNode;
import com.amazon.sqlengine.parser.type.PTListType;
import com.amazon.sqlengine.parser.type.PTNonterminalType;
import com.amazon.sqlengine.parser.type.PTPositionalType;
import com.amazon.support.exceptions.ErrorException;
import java.util.List;

public class AEProcedureCallBuilder
extends AEBuilderBase<AEProcedureCall> {
    private final SqlDataEngine m_dataEngine;

    public AEProcedureCallBuilder(AEQueryScope aEQueryScope) {
        super(aEQueryScope);
        this.m_dataEngine = aEQueryScope.getDataEngine();
    }

    @Override
    public AEProcedureCall visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        assert (PTNonterminalType.PROCEDURE_CALL == pTNonterminalNode.getNonterminalType());
        return this.buildProcedureCall(pTNonterminalNode);
    }

    private AEProcedureCall buildProcedureCall(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        if (2 != pTNonterminalNode.numChildren()) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        AEProcCallInfo aEProcCallInfo = this.buildProcCallInfo(pTNonterminalNode);
        AEProcedure aEProcedure = new AEProcedure(aEProcCallInfo.m_procedure, aEProcCallInfo.m_params, aEProcCallInfo.m_callHasReturnValue);
        return new AEProcedureCall(aEProcedure);
    }

    private AEProcCallInfo buildProcCallInfo(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        String string;
        PTNonterminalNode pTNonterminalNode2 = (PTNonterminalNode)pTNonterminalNode.getChild(PTPositionalType.PROCEDURE);
        assert (null != pTNonterminalNode2 && !pTNonterminalNode2.isEmptyNode());
        PTNonterminalNode pTNonterminalNode3 = (PTNonterminalNode)pTNonterminalNode2.getChild(PTPositionalType.PROCEDURE_NAME);
        assert (null != pTNonterminalNode3 && !pTNonterminalNode3.isEmptyNode());
        assert (!pTNonterminalNode3.getChild(PTPositionalType.PROCEDURE_IDENT).isEmptyNode());
        String string2 = AEUtils.getIdentifierString(pTNonterminalNode3.getChild(PTPositionalType.PROCEDURE_IDENT));
        String string3 = AEUtils.getIdentifierString(pTNonterminalNode3.getChild(PTPositionalType.CATALOG_IDENT));
        StoredProcedure storedProcedure = this.m_dataEngine.openProcedure(string3, string = AEUtils.getIdentifierString(pTNonterminalNode3.getChild(PTPositionalType.SCHEMA_IDENT)), string2);
        if (null == storedProcedure) {
            if (null != string) {
                String string4 = string3 + "." + string + "." + string2;
            } else {
                String string5 = string2;
            }
            throw SQLEngineExceptionFactory.invalidScalarFnNameException(String.format("Procedure %s:%s:%s not found", string3, string, string2));
        }
        return this.buildParamsList(pTNonterminalNode, storedProcedure);
    }

    private AEProcCallInfo buildParamsList(PTNonterminalNode pTNonterminalNode, StoredProcedure storedProcedure) throws ErrorException {
        AEValueExpr aEValueExpr;
        Object object;
        boolean bl = false;
        AEValueExprList aEValueExprList = new AEValueExprList();
        AEQueryScope aEQueryScope = new AEQueryScope(this.m_dataEngine);
        AEValueExprBuilder aEValueExprBuilder = new AEValueExprBuilder(aEQueryScope);
        assert (null != pTNonterminalNode.getChild(PTPositionalType.RETURN_VALUE));
        if (!pTNonterminalNode.getChild(PTPositionalType.RETURN_VALUE).isEmptyNode()) {
            bl = true;
            object = (AEValueExpr)aEValueExprBuilder.build(pTNonterminalNode.getChild(PTPositionalType.RETURN_VALUE));
            aEValueExprList.addNode(object);
        }
        assert (null != pTNonterminalNode.getChild(PTPositionalType.PROCEDURE));
        object = ((PTNonterminalNode)pTNonterminalNode.getChild(PTPositionalType.PROCEDURE)).getChild(PTPositionalType.PARAM_LIST);
        PTListNode pTListNode = object.isEmptyNode() ? new PTListNode(PTListType.PARAMETER_LIST) : (PTListNode)object;
        for (int i = 0; i < pTListNode.numChildren(); ++i) {
            IPTNode iPTNode = pTListNode.getChild(i);
            assert (null != iPTNode);
            aEValueExpr = (AEValueExpr)aEValueExprBuilder.build(iPTNode);
            aEValueExprList.addNode(aEValueExpr);
        }
        List<ProcedureParameterMetadata> list = storedProcedure.getParameters();
        if (pTListNode.numChildren() == 0 && list.size() == (storedProcedure.hasReturnValue() ? 2 : 1)) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getParameterType() != ParameterType.INPUT || !list.get(i).hasDefaultValue()) continue;
                aEValueExpr = new AEDefaultParameter();
                aEValueExprList.addNode(aEValueExpr);
            }
        }
        return new AEProcCallInfo(storedProcedure, aEValueExprList, bl);
    }

    private static class AEProcCallInfo {
        private final StoredProcedure m_procedure;
        private final AEValueExprList m_params;
        private final boolean m_callHasReturnValue;

        public AEProcCallInfo(StoredProcedure storedProcedure, AEValueExprList aEValueExprList, boolean bl) {
            this.m_procedure = storedProcedure;
            this.m_params = aEValueExprList;
            this.m_callHasReturnValue = bl;
        }
    }
}

