/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aetree.statement;

import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AETable;
import com.amazon.sqlengine.aeprocessor.aetree.statement.AEParameterContainer;
import com.amazon.sqlengine.aeprocessor.aetree.statement.AERowCountStatement;
import com.amazon.sqlengine.aeprocessor.aetree.statement.AETreeCopyUtil;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.amazon.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;

public class AEDelete
extends AERowCountStatement {
    private static final int NUM_CHILDREN = 2;
    private AETable m_table;
    private AEBooleanExpr m_cond;
    private AEParameterContainer m_params = null;

    public AEDelete(AETable aETable, AEBooleanExpr aEBooleanExpr) {
        if (null == aETable) {
            throw new NullPointerException("table may not be null.");
        }
        if (null == aEBooleanExpr) {
            throw new NullPointerException("cond may not be null");
        }
        this.m_table = aETable;
        aETable.setParent(this);
        this.m_cond = aEBooleanExpr;
        aEBooleanExpr.setParent(this);
    }

    private AEDelete(AEDelete aEDelete) {
        this.m_table = aEDelete.m_table.copy();
        this.m_cond = aEDelete.m_cond.copy();
        this.m_table.setParent(this);
        this.m_cond.setParent(this);
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public AEDelete copy() {
        AEDelete aEDelete = new AEDelete(this);
        AETreeCopyUtil.updateColumns(aEDelete);
        return aEDelete;
    }

    @Override
    public Iterator<? extends IAENode> getChildItr() {
        return new AbstractList<IAENode>(){

            @Override
            public IAENode get(int n) {
                if (0 == n) {
                    return AEDelete.this.m_table;
                }
                if (1 == n) {
                    return AEDelete.this.m_cond;
                }
                throw new IndexOutOfBoundsException("" + n);
            }

            @Override
            public int size() {
                return 2;
            }
        }.iterator();
    }

    public AEBooleanExpr getCondition() {
        return this.m_cond;
    }

    @Override
    public String getLogString() {
        return "AEDelete";
    }

    @Override
    public int getNumChildren() {
        return 2;
    }

    public AETable getTable() {
        return this.m_table;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AEDelete)) {
            return false;
        }
        AEDelete aEDelete = (AEDelete)iAENode;
        return this.m_table.isEquivalent(aEDelete.m_table) && this.m_cond.isEquivalent(aEDelete.m_cond);
    }

    @Override
    public void reprocessMetadata() throws ErrorException {
        this.m_cond.acceptVisitor(AEDelete.getMetadataProcessor());
    }

    @Override
    protected void NotifyDataNeededForColumnReference(AEColumnReference aEColumnReference) throws ErrorException {
        this.m_table.setDataNeeded(this.m_table, aEColumnReference.getColumnNum());
    }

    @Override
    public void notifyDataNeeded() throws ErrorException {
        this.m_cond.acceptVisitor(super.getNotifyDataNeededVisitor());
        this.m_table.setDataNeededOnChild();
    }

    public void setTable(AETable aETable) {
        if (aETable == null) {
            throw new NullPointerException("Table to update can not be null.");
        }
        this.m_table = aETable;
        this.m_table.setParent(this);
    }

    public void setCondition(AEBooleanExpr aEBooleanExpr) {
        if (aEBooleanExpr == null) {
            throw new NullPointerException("Update condition can not be null.");
        }
        this.m_cond = aEBooleanExpr;
        this.m_cond.setParent(this);
    }

    @Override
    public List<AEParameter> getDynamicParameters() {
        if (this.m_params == null) {
            this.m_params = new AEParameterContainer();
            this.m_params.initialize(this);
        }
        return this.m_params.getParameters();
    }
}

