/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cloudformation.model.OnFailure;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateStackRequest
extends AmazonWebServiceRequest {
    private String stackName;
    private String templateBody;
    private String templateURL;
    private List<Parameter> parameters;
    private Boolean disableRollback;
    private Integer timeoutInMinutes;
    private List<String> notificationARNs;
    private List<String> capabilities;
    private String onFailure;
    private List<Tag> tags;

    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public CreateStackRequest withStackName(String stackName) {
        this.stackName = stackName;
        return this;
    }

    public String getTemplateBody() {
        return this.templateBody;
    }

    public void setTemplateBody(String templateBody) {
        this.templateBody = templateBody;
    }

    public CreateStackRequest withTemplateBody(String templateBody) {
        this.templateBody = templateBody;
        return this;
    }

    public String getTemplateURL() {
        return this.templateURL;
    }

    public void setTemplateURL(String templateURL) {
        this.templateURL = templateURL;
    }

    public CreateStackRequest withTemplateURL(String templateURL) {
        this.templateURL = templateURL;
        return this;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        return this.parameters;
    }

    public void setParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        ArrayList<Parameter> parametersCopy = new ArrayList<Parameter>(parameters.size());
        parametersCopy.addAll(parameters);
        this.parameters = parametersCopy;
    }

    public CreateStackRequest withParameters(Parameter ... parameters) {
        if (this.getParameters() == null) {
            this.setParameters(new ArrayList<Parameter>(parameters.length));
        }
        for (Parameter value : parameters) {
            this.getParameters().add(value);
        }
        return this;
    }

    public CreateStackRequest withParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
        } else {
            ArrayList<Parameter> parametersCopy = new ArrayList<Parameter>(parameters.size());
            parametersCopy.addAll(parameters);
            this.parameters = parametersCopy;
        }
        return this;
    }

    public Boolean isDisableRollback() {
        return this.disableRollback;
    }

    public void setDisableRollback(Boolean disableRollback) {
        this.disableRollback = disableRollback;
    }

    public CreateStackRequest withDisableRollback(Boolean disableRollback) {
        this.disableRollback = disableRollback;
        return this;
    }

    public Boolean getDisableRollback() {
        return this.disableRollback;
    }

    public Integer getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public void setTimeoutInMinutes(Integer timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
    }

    public CreateStackRequest withTimeoutInMinutes(Integer timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
        return this;
    }

    public List<String> getNotificationARNs() {
        if (this.notificationARNs == null) {
            this.notificationARNs = new ArrayList<String>();
        }
        return this.notificationARNs;
    }

    public void setNotificationARNs(Collection<String> notificationARNs) {
        if (notificationARNs == null) {
            this.notificationARNs = null;
            return;
        }
        ArrayList<String> notificationARNsCopy = new ArrayList<String>(notificationARNs.size());
        notificationARNsCopy.addAll(notificationARNs);
        this.notificationARNs = notificationARNsCopy;
    }

    public CreateStackRequest withNotificationARNs(String ... notificationARNs) {
        if (this.getNotificationARNs() == null) {
            this.setNotificationARNs(new ArrayList<String>(notificationARNs.length));
        }
        for (String value : notificationARNs) {
            this.getNotificationARNs().add(value);
        }
        return this;
    }

    public CreateStackRequest withNotificationARNs(Collection<String> notificationARNs) {
        if (notificationARNs == null) {
            this.notificationARNs = null;
        } else {
            ArrayList<String> notificationARNsCopy = new ArrayList<String>(notificationARNs.size());
            notificationARNsCopy.addAll(notificationARNs);
            this.notificationARNs = notificationARNsCopy;
        }
        return this;
    }

    public List<String> getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<String>();
        }
        return this.capabilities;
    }

    public void setCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
            return;
        }
        ArrayList<String> capabilitiesCopy = new ArrayList<String>(capabilities.size());
        capabilitiesCopy.addAll(capabilities);
        this.capabilities = capabilitiesCopy;
    }

    public CreateStackRequest withCapabilities(String ... capabilities) {
        if (this.getCapabilities() == null) {
            this.setCapabilities(new ArrayList<String>(capabilities.length));
        }
        for (String value : capabilities) {
            this.getCapabilities().add(value);
        }
        return this;
    }

    public CreateStackRequest withCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
        } else {
            ArrayList<String> capabilitiesCopy = new ArrayList<String>(capabilities.size());
            capabilitiesCopy.addAll(capabilities);
            this.capabilities = capabilitiesCopy;
        }
        return this;
    }

    public String getOnFailure() {
        return this.onFailure;
    }

    public void setOnFailure(String onFailure) {
        this.onFailure = onFailure;
    }

    public CreateStackRequest withOnFailure(String onFailure) {
        this.onFailure = onFailure;
        return this;
    }

    public void setOnFailure(OnFailure onFailure) {
        this.onFailure = onFailure.toString();
    }

    public CreateStackRequest withOnFailure(OnFailure onFailure) {
        this.onFailure = onFailure.toString();
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public CreateStackRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public CreateStackRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackName != null) {
            sb.append("StackName: " + this.stackName + ", ");
        }
        if (this.templateBody != null) {
            sb.append("TemplateBody: " + this.templateBody + ", ");
        }
        if (this.templateURL != null) {
            sb.append("TemplateURL: " + this.templateURL + ", ");
        }
        if (this.parameters != null) {
            sb.append("Parameters: " + this.parameters + ", ");
        }
        if (this.disableRollback != null) {
            sb.append("DisableRollback: " + this.disableRollback + ", ");
        }
        if (this.timeoutInMinutes != null) {
            sb.append("TimeoutInMinutes: " + this.timeoutInMinutes + ", ");
        }
        if (this.notificationARNs != null) {
            sb.append("NotificationARNs: " + this.notificationARNs + ", ");
        }
        if (this.capabilities != null) {
            sb.append("Capabilities: " + this.capabilities + ", ");
        }
        if (this.onFailure != null) {
            sb.append("OnFailure: " + this.onFailure + ", ");
        }
        if (this.tags != null) {
            sb.append("Tags: " + this.tags + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackName() == null ? 0 : this.getStackName().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateBody() == null ? 0 : this.getTemplateBody().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateURL() == null ? 0 : this.getTemplateURL().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : ((Object)this.getParameters()).hashCode());
        hashCode = 31 * hashCode + (this.isDisableRollback() == null ? 0 : this.isDisableRollback().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutInMinutes() == null ? 0 : this.getTimeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationARNs() == null ? 0 : ((Object)this.getNotificationARNs()).hashCode());
        hashCode = 31 * hashCode + (this.getCapabilities() == null ? 0 : ((Object)this.getCapabilities()).hashCode());
        hashCode = 31 * hashCode + (this.getOnFailure() == null ? 0 : this.getOnFailure().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRequest)) {
            return false;
        }
        CreateStackRequest other = (CreateStackRequest)obj;
        if (other.getStackName() == null ^ this.getStackName() == null) {
            return false;
        }
        if (other.getStackName() != null && !other.getStackName().equals(this.getStackName())) {
            return false;
        }
        if (other.getTemplateBody() == null ^ this.getTemplateBody() == null) {
            return false;
        }
        if (other.getTemplateBody() != null && !other.getTemplateBody().equals(this.getTemplateBody())) {
            return false;
        }
        if (other.getTemplateURL() == null ^ this.getTemplateURL() == null) {
            return false;
        }
        if (other.getTemplateURL() != null && !other.getTemplateURL().equals(this.getTemplateURL())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !((Object)other.getParameters()).equals(this.getParameters())) {
            return false;
        }
        if (other.isDisableRollback() == null ^ this.isDisableRollback() == null) {
            return false;
        }
        if (other.isDisableRollback() != null && !other.isDisableRollback().equals(this.isDisableRollback())) {
            return false;
        }
        if (other.getTimeoutInMinutes() == null ^ this.getTimeoutInMinutes() == null) {
            return false;
        }
        if (other.getTimeoutInMinutes() != null && !other.getTimeoutInMinutes().equals(this.getTimeoutInMinutes())) {
            return false;
        }
        if (other.getNotificationARNs() == null ^ this.getNotificationARNs() == null) {
            return false;
        }
        if (other.getNotificationARNs() != null && !((Object)other.getNotificationARNs()).equals(this.getNotificationARNs())) {
            return false;
        }
        if (other.getCapabilities() == null ^ this.getCapabilities() == null) {
            return false;
        }
        if (other.getCapabilities() != null && !((Object)other.getCapabilities()).equals(this.getCapabilities())) {
            return false;
        }
        if (other.getOnFailure() == null ^ this.getOnFailure() == null) {
            return false;
        }
        if (other.getOnFailure() != null && !other.getOnFailure().equals(this.getOnFailure())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || ((Object)other.getTags()).equals(this.getTags());
    }
}

