/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyCacheClusterRequestMarshaller
implements Marshaller<Request<ModifyCacheClusterRequest>, ModifyCacheClusterRequest> {
    @Override
    public Request<ModifyCacheClusterRequest> marshall(ModifyCacheClusterRequest modifyCacheClusterRequest) {
        if (modifyCacheClusterRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyCacheClusterRequest> request = new DefaultRequest<ModifyCacheClusterRequest>(modifyCacheClusterRequest, "AmazonElastiCache");
        request.addParameter("Action", "ModifyCacheCluster");
        request.addParameter("Version", "2012-03-09");
        if (modifyCacheClusterRequest.getCacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString(modifyCacheClusterRequest.getCacheClusterId()));
        }
        if (modifyCacheClusterRequest.getNumCacheNodes() != null) {
            request.addParameter("NumCacheNodes", StringUtils.fromInteger(modifyCacheClusterRequest.getNumCacheNodes()));
        }
        List<String> cacheNodeIdsToRemoveList = modifyCacheClusterRequest.getCacheNodeIdsToRemove();
        int cacheNodeIdsToRemoveListIndex = 1;
        for (String cacheNodeIdsToRemoveListValue : cacheNodeIdsToRemoveList) {
            if (cacheNodeIdsToRemoveListValue != null) {
                request.addParameter("CacheNodeIdsToRemove.CacheNodeId." + cacheNodeIdsToRemoveListIndex, StringUtils.fromString(cacheNodeIdsToRemoveListValue));
            }
            ++cacheNodeIdsToRemoveListIndex;
        }
        List<String> cacheSecurityGroupNamesList = modifyCacheClusterRequest.getCacheSecurityGroupNames();
        int cacheSecurityGroupNamesListIndex = 1;
        for (String cacheSecurityGroupNamesListValue : cacheSecurityGroupNamesList) {
            if (cacheSecurityGroupNamesListValue != null) {
                request.addParameter("CacheSecurityGroupNames.CacheSecurityGroupName." + cacheSecurityGroupNamesListIndex, StringUtils.fromString(cacheSecurityGroupNamesListValue));
            }
            ++cacheSecurityGroupNamesListIndex;
        }
        if (modifyCacheClusterRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString(modifyCacheClusterRequest.getPreferredMaintenanceWindow()));
        }
        if (modifyCacheClusterRequest.getNotificationTopicArn() != null) {
            request.addParameter("NotificationTopicArn", StringUtils.fromString(modifyCacheClusterRequest.getNotificationTopicArn()));
        }
        if (modifyCacheClusterRequest.getCacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString(modifyCacheClusterRequest.getCacheParameterGroupName()));
        }
        if (modifyCacheClusterRequest.getNotificationTopicStatus() != null) {
            request.addParameter("NotificationTopicStatus", StringUtils.fromString(modifyCacheClusterRequest.getNotificationTopicStatus()));
        }
        if (modifyCacheClusterRequest.isApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean(modifyCacheClusterRequest.isApplyImmediately()));
        }
        if (modifyCacheClusterRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString(modifyCacheClusterRequest.getEngineVersion()));
        }
        if (modifyCacheClusterRequest.isAutoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean(modifyCacheClusterRequest.isAutoMinorVersionUpgrade()));
        }
        return request;
    }
}

