/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceAsync;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient;
import com.amazonaws.services.simpleemail.model.DeleteIdentityRequest;
import com.amazonaws.services.simpleemail.model.DeleteIdentityResult;
import com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest;
import com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest;
import com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesResult;
import com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest;
import com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesResult;
import com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest;
import com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesResult;
import com.amazonaws.services.simpleemail.model.GetSendQuotaRequest;
import com.amazonaws.services.simpleemail.model.GetSendQuotaResult;
import com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest;
import com.amazonaws.services.simpleemail.model.GetSendStatisticsResult;
import com.amazonaws.services.simpleemail.model.ListIdentitiesRequest;
import com.amazonaws.services.simpleemail.model.ListIdentitiesResult;
import com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest;
import com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesResult;
import com.amazonaws.services.simpleemail.model.SendEmailRequest;
import com.amazonaws.services.simpleemail.model.SendEmailResult;
import com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.amazonaws.services.simpleemail.model.SendRawEmailResult;
import com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest;
import com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledResult;
import com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest;
import com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledResult;
import com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest;
import com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicResult;
import com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest;
import com.amazonaws.services.simpleemail.model.VerifyDomainDkimResult;
import com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest;
import com.amazonaws.services.simpleemail.model.VerifyDomainIdentityResult;
import com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest;
import com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest;
import com.amazonaws.services.simpleemail.model.VerifyEmailIdentityResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSimpleEmailServiceAsyncClient
extends AmazonSimpleEmailServiceClient
implements AmazonSimpleEmailServiceAsync {
    private ExecutorService executorService;

    public AmazonSimpleEmailServiceAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonSimpleEmailServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public AmazonSimpleEmailServiceAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonSimpleEmailServiceAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonSimpleEmailServiceAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonSimpleEmailServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AmazonSimpleEmailServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonSimpleEmailServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<DeleteIdentityResult> deleteIdentityAsync(final DeleteIdentityRequest deleteIdentityRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteIdentityResult>(){

            @Override
            public DeleteIdentityResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.deleteIdentity(deleteIdentityRequest);
            }
        });
    }

    @Override
    public Future<DeleteIdentityResult> deleteIdentityAsync(final DeleteIdentityRequest deleteIdentityRequest, final AsyncHandler<DeleteIdentityRequest, DeleteIdentityResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteIdentityResult>(){

            @Override
            public DeleteIdentityResult call() throws Exception {
                DeleteIdentityResult result;
                try {
                    result = AmazonSimpleEmailServiceAsyncClient.this.deleteIdentity(deleteIdentityRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteIdentityRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListVerifiedEmailAddressesResult> listVerifiedEmailAddressesAsync(final ListVerifiedEmailAddressesRequest listVerifiedEmailAddressesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListVerifiedEmailAddressesResult>(){

            @Override
            public ListVerifiedEmailAddressesResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.listVerifiedEmailAddresses(listVerifiedEmailAddressesRequest);
            }
        });
    }

    @Override
    public Future<ListVerifiedEmailAddressesResult> listVerifiedEmailAddressesAsync(final ListVerifiedEmailAddressesRequest listVerifiedEmailAddressesRequest, final AsyncHandler<ListVerifiedEmailAddressesRequest, ListVerifiedEmailAddressesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListVerifiedEmailAddressesResult>(){

            @Override
            public ListVerifiedEmailAddressesResult call() throws Exception {
                ListVerifiedEmailAddressesResult result;
                try {
                    result = AmazonSimpleEmailServiceAsyncClient.this.listVerifiedEmailAddresses(listVerifiedEmailAddressesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listVerifiedEmailAddressesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetSendStatisticsResult> getSendStatisticsAsync(final GetSendStatisticsRequest getSendStatisticsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetSendStatisticsResult>(){

            @Override
            public GetSendStatisticsResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.getSendStatistics(getSendStatisticsRequest);
            }
        });
    }

    @Override
    public Future<GetSendStatisticsResult> getSendStatisticsAsync(final GetSendStatisticsRequest getSendStatisticsRequest, final AsyncHandler<GetSendStatisticsRequest, GetSendStatisticsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetSendStatisticsResult>(){

            @Override
            public GetSendStatisticsResult call() throws Exception {
                GetSendStatisticsResult result;
                try {
                    result = AmazonSimpleEmailServiceAsyncClient.this.getSendStatistics(getSendStatisticsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getSendStatisticsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<VerifyEmailIdentityResult> verifyEmailIdentityAsync(final VerifyEmailIdentityRequest verifyEmailIdentityRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<VerifyEmailIdentityResult>(){

            @Override
            public VerifyEmailIdentityResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.verifyEmailIdentity(verifyEmailIdentityRequest);
            }
        });
    }

    @Override
    public Future<VerifyEmailIdentityResult> verifyEmailIdentityAsync(final VerifyEmailIdentityRequest verifyEmailIdentityRequest, final AsyncHandler<VerifyEmailIdentityRequest, VerifyEmailIdentityResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<VerifyEmailIdentityResult>(){

            @Override
            public VerifyEmailIdentityResult call() throws Exception {
                VerifyEmailIdentityResult result;
                try {
                    result = AmazonSimpleEmailServiceAsyncClient.this.verifyEmailIdentity(verifyEmailIdentityRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(verifyEmailIdentityRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetIdentityNotificationAttributesResult> getIdentityNotificationAttributesAsync(final GetIdentityNotificationAttributesRequest getIdentityNotificationAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetIdentityNotificationAttributesResult>(){

            @Override
            public GetIdentityNotificationAttributesResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.getIdentityNotificationAttributes(getIdentityNotificationAttributesRequest);
            }
        });
    }

    @Override
    public Future<GetIdentityNotificationAttributesResult> getIdentityNotificationAttributesAsync(final GetIdentityNotificationAttributesRequest getIdentityNotificationAttributesRequest, final AsyncHandler<GetIdentityNotificationAttributesRequest, GetIdentityNotificationAttributesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetIdentityNotificationAttributesResult>(){

            @Override
            public GetIdentityNotificationAttributesResult call() throws Exception {
                GetIdentityNotificationAttributesResult result;
                try {
                    result = AmazonSimpleEmailServiceAsyncClient.this.getIdentityNotificationAttributes(getIdentityNotificationAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getIdentityNotificationAttributesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<VerifyDomainDkimResult> verifyDomainDkimAsync(final VerifyDomainDkimRequest verifyDomainDkimRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<VerifyDomainDkimResult>(){

            @Override
            public VerifyDomainDkimResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.verifyDomainDkim(verifyDomainDkimRequest);
            }
        });
    }

    @Override
    public Future<VerifyDomainDkimResult> verifyDomainDkimAsync(final VerifyDomainDkimRequest verifyDomainDkimRequest, final AsyncHandler<VerifyDomainDkimRequest, VerifyDomainDkimResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<VerifyDomainDkimResult>(){

            @Override
            public VerifyDomainDkimResult call() throws Exception {
                VerifyDomainDkimResult result;
                try {
                    result = AmazonSimpleEmailServiceAsyncClient.this.verifyDomainDkim(verifyDomainDkimRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(verifyDomainDkimRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetIdentityDkimAttributesResult> getIdentityDkimAttributesAsync(final GetIdentityDkimAttributesRequest getIdentityDkimAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetIdentityDkimAttributesResult>(){

            @Override
            public GetIdentityDkimAttributesResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.getIdentityDkimAttributes(getIdentityDkimAttributesRequest);
            }
        });
    }

    @Override
    public Future<GetIdentityDkimAttributesResult> getIdentityDkimAttributesAsync(final GetIdentityDkimAttributesRequest getIdentityDkimAttributesRequest, final AsyncHandler<GetIdentityDkimAttributesRequest, GetIdentityDkimAttributesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetIdentityDkimAttributesResult>(){

            @Override
            public GetIdentityDkimAttributesResult call() throws Exception {
                GetIdentityDkimAttributesResult result;
                try {
                    result = AmazonSimpleEmailServiceAsyncClient.this.getIdentityDkimAttributes(getIdentityDkimAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getIdentityDkimAttributesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> verifyEmailAddressAsync(final VerifyEmailAddressRequest verifyEmailAddressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleEmailServiceAsyncClient.this.verifyEmailAddress(verifyEmailAddressRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> verifyEmailAddressAsync(final VerifyEmailAddressRequest verifyEmailAddressRequest, final AsyncHandler<VerifyEmailAddressRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSimpleEmailServiceAsyncClient.this.verifyEmailAddress(verifyEmailAddressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(verifyEmailAddressRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<SendRawEmailResult> sendRawEmailAsync(final SendRawEmailRequest sendRawEmailRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SendRawEmailResult>(){

            @Override
            public SendRawEmailResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.sendRawEmail(sendRawEmailRequest);
            }
        });
    }

    @Override
    public Future<SendRawEmailResult> sendRawEmailAsync(final SendRawEmailRequest sendRawEmailRequest, final AsyncHandler<SendRawEmailRequest, SendRawEmailResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SendRawEmailResult>(){

            @Override
            public SendRawEmailResult call() throws Exception {
                SendRawEmailResult result;
                try {
                    result = AmazonSimpleEmailServiceAsyncClient.this.sendRawEmail(sendRawEmailRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(sendRawEmailRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListIdentitiesResult> listIdentitiesAsync(final ListIdentitiesRequest listIdentitiesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListIdentitiesResult>(){

            @Override
            public ListIdentitiesResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.listIdentities(listIdentitiesRequest);
            }
        });
    }

    @Override
    public Future<ListIdentitiesResult> listIdentitiesAsync(final ListIdentitiesRequest listIdentitiesRequest, final AsyncHandler<ListIdentitiesRequest, ListIdentitiesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListIdentitiesResult>(){

            @Override
            public ListIdentitiesResult call() throws Exception {
                ListIdentitiesResult result;
                try {
                    result = AmazonSimpleEmailServiceAsyncClient.this.listIdentities(listIdentitiesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listIdentitiesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetIdentityVerificationAttributesResult> getIdentityVerificationAttributesAsync(final GetIdentityVerificationAttributesRequest getIdentityVerificationAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetIdentityVerificationAttributesResult>(){

            @Override
            public GetIdentityVerificationAttributesResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.getIdentityVerificationAttributes(getIdentityVerificationAttributesRequest);
            }
        });
    }

    @Override
    public Future<GetIdentityVerificationAttributesResult> getIdentityVerificationAttributesAsync(final GetIdentityVerificationAttributesRequest getIdentityVerificationAttributesRequest, final AsyncHandler<GetIdentityVerificationAttributesRequest, GetIdentityVerificationAttributesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetIdentityVerificationAttributesResult>(){

            @Override
            public GetIdentityVerificationAttributesResult call() throws Exception {
                GetIdentityVerificationAttributesResult result;
                try {
                    result = AmazonSimpleEmailServiceAsyncClient.this.getIdentityVerificationAttributes(getIdentityVerificationAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getIdentityVerificationAttributesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<SetIdentityDkimEnabledResult> setIdentityDkimEnabledAsync(final SetIdentityDkimEnabledRequest setIdentityDkimEnabledRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SetIdentityDkimEnabledResult>(){

            @Override
            public SetIdentityDkimEnabledResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.setIdentityDkimEnabled(setIdentityDkimEnabledRequest);
            }
        });
    }

    @Override
    public Future<SetIdentityDkimEnabledResult> setIdentityDkimEnabledAsync(final SetIdentityDkimEnabledRequest setIdentityDkimEnabledRequest, final AsyncHandler<SetIdentityDkimEnabledRequest, SetIdentityDkimEnabledResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SetIdentityDkimEnabledResult>(){

            @Override
            public SetIdentityDkimEnabledResult call() throws Exception {
                SetIdentityDkimEnabledResult result;
                try {
                    result = AmazonSimpleEmailServiceAsyncClient.this.setIdentityDkimEnabled(setIdentityDkimEnabledRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(setIdentityDkimEnabledRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetSendQuotaResult> getSendQuotaAsync(final GetSendQuotaRequest getSendQuotaRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetSendQuotaResult>(){

            @Override
            public GetSendQuotaResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.getSendQuota(getSendQuotaRequest);
            }
        });
    }

    @Override
    public Future<GetSendQuotaResult> getSendQuotaAsync(final GetSendQuotaRequest getSendQuotaRequest, final AsyncHandler<GetSendQuotaRequest, GetSendQuotaResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetSendQuotaResult>(){

            @Override
            public GetSendQuotaResult call() throws Exception {
                GetSendQuotaResult result;
                try {
                    result = AmazonSimpleEmailServiceAsyncClient.this.getSendQuota(getSendQuotaRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getSendQuotaRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<SetIdentityFeedbackForwardingEnabledResult> setIdentityFeedbackForwardingEnabledAsync(final SetIdentityFeedbackForwardingEnabledRequest setIdentityFeedbackForwardingEnabledRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SetIdentityFeedbackForwardingEnabledResult>(){

            @Override
            public SetIdentityFeedbackForwardingEnabledResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.setIdentityFeedbackForwardingEnabled(setIdentityFeedbackForwardingEnabledRequest);
            }
        });
    }

    @Override
    public Future<SetIdentityFeedbackForwardingEnabledResult> setIdentityFeedbackForwardingEnabledAsync(final SetIdentityFeedbackForwardingEnabledRequest setIdentityFeedbackForwardingEnabledRequest, final AsyncHandler<SetIdentityFeedbackForwardingEnabledRequest, SetIdentityFeedbackForwardingEnabledResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SetIdentityFeedbackForwardingEnabledResult>(){

            @Override
            public SetIdentityFeedbackForwardingEnabledResult call() throws Exception {
                SetIdentityFeedbackForwardingEnabledResult result;
                try {
                    result = AmazonSimpleEmailServiceAsyncClient.this.setIdentityFeedbackForwardingEnabled(setIdentityFeedbackForwardingEnabledRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(setIdentityFeedbackForwardingEnabledRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<VerifyDomainIdentityResult> verifyDomainIdentityAsync(final VerifyDomainIdentityRequest verifyDomainIdentityRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<VerifyDomainIdentityResult>(){

            @Override
            public VerifyDomainIdentityResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.verifyDomainIdentity(verifyDomainIdentityRequest);
            }
        });
    }

    @Override
    public Future<VerifyDomainIdentityResult> verifyDomainIdentityAsync(final VerifyDomainIdentityRequest verifyDomainIdentityRequest, final AsyncHandler<VerifyDomainIdentityRequest, VerifyDomainIdentityResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<VerifyDomainIdentityResult>(){

            @Override
            public VerifyDomainIdentityResult call() throws Exception {
                VerifyDomainIdentityResult result;
                try {
                    result = AmazonSimpleEmailServiceAsyncClient.this.verifyDomainIdentity(verifyDomainIdentityRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(verifyDomainIdentityRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<SendEmailResult> sendEmailAsync(final SendEmailRequest sendEmailRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SendEmailResult>(){

            @Override
            public SendEmailResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.sendEmail(sendEmailRequest);
            }
        });
    }

    @Override
    public Future<SendEmailResult> sendEmailAsync(final SendEmailRequest sendEmailRequest, final AsyncHandler<SendEmailRequest, SendEmailResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SendEmailResult>(){

            @Override
            public SendEmailResult call() throws Exception {
                SendEmailResult result;
                try {
                    result = AmazonSimpleEmailServiceAsyncClient.this.sendEmail(sendEmailRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(sendEmailRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteVerifiedEmailAddressAsync(final DeleteVerifiedEmailAddressRequest deleteVerifiedEmailAddressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleEmailServiceAsyncClient.this.deleteVerifiedEmailAddress(deleteVerifiedEmailAddressRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteVerifiedEmailAddressAsync(final DeleteVerifiedEmailAddressRequest deleteVerifiedEmailAddressRequest, final AsyncHandler<DeleteVerifiedEmailAddressRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSimpleEmailServiceAsyncClient.this.deleteVerifiedEmailAddress(deleteVerifiedEmailAddressRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteVerifiedEmailAddressRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<SetIdentityNotificationTopicResult> setIdentityNotificationTopicAsync(final SetIdentityNotificationTopicRequest setIdentityNotificationTopicRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SetIdentityNotificationTopicResult>(){

            @Override
            public SetIdentityNotificationTopicResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.setIdentityNotificationTopic(setIdentityNotificationTopicRequest);
            }
        });
    }

    @Override
    public Future<SetIdentityNotificationTopicResult> setIdentityNotificationTopicAsync(final SetIdentityNotificationTopicRequest setIdentityNotificationTopicRequest, final AsyncHandler<SetIdentityNotificationTopicRequest, SetIdentityNotificationTopicResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SetIdentityNotificationTopicResult>(){

            @Override
            public SetIdentityNotificationTopicResult call() throws Exception {
                SetIdentityNotificationTopicResult result;
                try {
                    result = AmazonSimpleEmailServiceAsyncClient.this.setIdentityNotificationTopic(setIdentityNotificationTopicRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(setIdentityNotificationTopicRequest, result);
                return result;
            }
        });
    }
}

