/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow;

import com.amazonaws.services.simpleworkflow.flow.ActivitySchedulingOptions;
import com.amazonaws.services.simpleworkflow.flow.ActivityTaskFailedException;
import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.DataConverterException;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProvider;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProviderImpl;
import com.amazonaws.services.simpleworkflow.flow.DynamicActivitiesClient;
import com.amazonaws.services.simpleworkflow.flow.JsonDataConverter;
import com.amazonaws.services.simpleworkflow.flow.core.Functor;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.TryCatchFinally;
import com.amazonaws.services.simpleworkflow.flow.generic.ExecuteActivityParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericActivityClient;
import com.amazonaws.services.simpleworkflow.model.ActivityType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicActivitiesClientImpl
implements DynamicActivitiesClient {
    protected DataConverter dataConverter;
    protected ActivitySchedulingOptions schedulingOptions;
    protected GenericActivityClient genericClient;
    protected DecisionContextProvider decisionContextProvider = new DecisionContextProviderImpl();

    public DynamicActivitiesClientImpl() {
        this(null, null, null);
    }

    public DynamicActivitiesClientImpl(ActivitySchedulingOptions schedulingOptions) {
        this(schedulingOptions, null, null);
    }

    public DynamicActivitiesClientImpl(ActivitySchedulingOptions schedulingOptions, DataConverter dataConverter) {
        this(schedulingOptions, dataConverter, null);
    }

    public DynamicActivitiesClientImpl(ActivitySchedulingOptions schedulingOptions, DataConverter dataConverter, GenericActivityClient genericClient) {
        this.genericClient = genericClient;
        this.schedulingOptions = schedulingOptions == null ? new ActivitySchedulingOptions() : schedulingOptions;
        this.dataConverter = dataConverter == null ? new JsonDataConverter() : dataConverter;
    }

    @Override
    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    public void setDataConverter(DataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }

    @Override
    public ActivitySchedulingOptions getSchedulingOptions() {
        return this.schedulingOptions;
    }

    public void setSchedulingOptions(ActivitySchedulingOptions schedulingOptions) {
        this.schedulingOptions = schedulingOptions;
    }

    @Override
    public GenericActivityClient getGenericClient() {
        return this.genericClient;
    }

    public void setGenericClient(GenericActivityClient genericClient) {
        this.genericClient = genericClient;
    }

    @Override
    public <T> Promise<T> scheduleActivity(final ActivityType activityType, final Promise<?>[] arguments, final ActivitySchedulingOptions optionsOverride, final Class<T> returnType, final Promise<?> ... waitFor) {
        return new Functor<T>((Promise[])arguments){

            @Override
            protected Promise<T> doExecute() throws Throwable {
                Object[] input = new Object[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    Promise argument = arguments[i];
                    input[i] = argument.get();
                }
                return DynamicActivitiesClientImpl.this.scheduleActivity(activityType, input, optionsOverride, returnType, waitFor);
            }
        };
    }

    @Override
    public <T> Promise<T> scheduleActivity(final ActivityType activityType, final Object[] arguments, final ActivitySchedulingOptions optionsOverride, final Class<T> returnType, Promise<?> ... waitFor) {
        final Settable result = new Settable();
        new TryCatchFinally((Promise[])waitFor){
            Promise<String> stringOutput;

            protected void doTry() throws Throwable {
                ExecuteActivityParameters parameters = new ExecuteActivityParameters();
                parameters.setActivityType(activityType);
                String stringInput = DynamicActivitiesClientImpl.this.dataConverter.toData(arguments);
                parameters.setInput(stringInput);
                ExecuteActivityParameters _scheduleParameters_ = parameters.createExecuteActivityParametersFromOptions(DynamicActivitiesClientImpl.this.schedulingOptions, optionsOverride);
                GenericActivityClient client = DynamicActivitiesClientImpl.this.genericClient == null ? DynamicActivitiesClientImpl.this.decisionContextProvider.getDecisionContext().getActivityClient() : DynamicActivitiesClientImpl.this.genericClient;
                this.stringOutput = client.scheduleActivityTask(_scheduleParameters_);
                result.setDescription(this.stringOutput.getDescription());
            }

            protected void doCatch(Throwable e) throws Throwable {
                if (e instanceof ActivityTaskFailedException) {
                    ActivityTaskFailedException taskFailedException = (ActivityTaskFailedException)e;
                    try {
                        Throwable cause;
                        String details = taskFailedException.getDetails();
                        if (details != null && (cause = DynamicActivitiesClientImpl.this.dataConverter.fromData(details, Throwable.class)) != null && taskFailedException.getCause() == null) {
                            taskFailedException.initCause(cause);
                        }
                    }
                    catch (DataConverterException dataConverterException) {
                        if (dataConverterException.getCause() == null) {
                            dataConverterException.initCause(taskFailedException);
                        }
                        throw dataConverterException;
                    }
                }
                throw e;
            }

            protected void doFinally() throws Throwable {
                if (this.stringOutput != null && this.stringOutput.isReady()) {
                    if (returnType.equals(Void.class)) {
                        result.set(null);
                    } else {
                        Object output = DynamicActivitiesClientImpl.this.dataConverter.fromData(this.stringOutput.get(), returnType);
                        result.set(output);
                    }
                }
            }
        };
        return result;
    }
}

