/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan.artifact;

import com.atlassian.bamboo.specs.api.builders.plan.artifact.Artifact;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Immutable
public final class ArtifactProperties
implements EntityProperties {
    public static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of("Artifact");
    private final String name;
    private final List<String> copyPatterns;
    private final List<String> exclusionPatterns;
    private final String location;
    private final boolean shared;
    private final boolean required;
    private final boolean httpCompressionOn;

    private ArtifactProperties() {
        this.shared = Artifact.SHARED_BY_DEFAULT;
        this.required = Artifact.REQUIRED_BY_DEFAULT;
        this.httpCompressionOn = Artifact.HTTP_COMPRESSION_ON_BY_DEFAULT;
        this.name = null;
        this.location = "";
        this.copyPatterns = Collections.emptyList();
        this.exclusionPatterns = Collections.emptyList();
    }

    public ArtifactProperties(String name, List<String> copyPatterns, List<String> exclusionPatterns, String location, boolean shared, boolean required, boolean httpCompressionOn) throws PropertiesValidationException {
        this.name = name;
        this.copyPatterns = new ArrayList<String>(copyPatterns);
        this.exclusionPatterns = new ArrayList<String>(exclusionPatterns);
        this.location = location;
        this.shared = shared;
        this.required = required;
        this.httpCompressionOn = httpCompressionOn;
        this.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactProperties that = (ArtifactProperties)o;
        return this.isShared() == that.isShared() && this.isRequired() == that.isRequired() && this.isHttpCompressionOn() == that.isHttpCompressionOn() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getCopyPatterns(), that.getCopyPatterns()) && Objects.equals(this.getExclusionPatterns(), that.getExclusionPatterns()) && Objects.equals(this.getLocation(), that.getLocation());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getCopyPatterns(), this.getExclusionPatterns(), this.getLocation(), this.isShared(), this.isRequired(), this.isHttpCompressionOn());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("name", (Object)this.name).append("copyPatterns", this.copyPatterns).append("exclusionPatterns", this.exclusionPatterns).append("location", (Object)this.location).append("shared", this.shared).append("required", this.required).append("httpCompressionOn", this.httpCompressionOn).build();
    }

    public String getName() {
        return this.name;
    }

    public List<String> getCopyPatterns() {
        return this.copyPatterns;
    }

    public List<String> getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isShared() {
        return this.shared;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isHttpCompressionOn() {
        return this.httpCompressionOn;
    }

    @Override
    public void validate() {
        ImporterUtils.checkArgument(VALIDATION_CONTEXT, !StringUtils.contains((CharSequence)this.name, (CharSequence)"/"), "Name can not contain '/' character");
    }
}

