/*
 * Decompiled with CFR 0.152.
 */
package com.attunity.avro.decoder;

import com.attunity.avro.decoder.AttunityAvroValueType;
import com.attunity.avro.decoder.AttunityDataColumn;
import com.attunity.avro.decoder.AttunityDataHeaders;
import com.attunity.avro.decoder.AttunityDataMessage;
import com.attunity.avro.decoder.AttunityDataOperation;
import com.attunity.avro.decoder.AttunityDataType;
import com.attunity.avro.decoder.AttunityDataValueType;
import com.attunity.avro.decoder.AttunityDecoderException;
import com.attunity.avro.decoder.AttunityDecoderExceptionCode;
import com.attunity.avro.decoder.AttunityMessage;
import com.attunity.avro.decoder.AttunityMessageType;
import com.attunity.avro.decoder.AttunityMetadataMessage;
import com.attunity.avro.decoder.AttunityTableColumn;
import com.attunity.avro.decoder.AttunityTableLineage;
import com.attunity.avro.decoder.MetadataStore;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ArrayUtils;

public class AttunityMessageDecoder {
    private static Schema _envelopeSchema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"MessageEnvelope\",\"fields\":[{\"name\":\"magic\",\"type\":{\"type\":\"fixed\",\"name\":\"Magic\",\"size\":5}},{\"name\":\"type\",\"type\":\"string\"},{\"name\":\"headers\",\"type\":[{\"type\":\"null\"},{\"type\":\"map\",\"values\":\"string\" , \"avro.java.string\": \"String\"}]},{\"name\":\"messageSchemaId\",\"type\":[\"null\",\"string\"]},{\"name\":\"messageSchema\",\"type\":[\"null\",\"string\"]},{\"name\":\"message\",\"type\":\"bytes\"}]}");
    private static byte[] attunityMessageMagic = new byte[]{97, 116, 77, 83, 71};
    private static final String _majorVersion = "2023";
    private static final String _minorVersion = "11";
    private static final String _spVersion = "0";
    private static final String _buildId = "282";
    private static final String _version = "2023.11.0.282";
    private MetadataStore metadataStore;
    private Map<String, DatumReader<GenericRecord>> schemaMessageReaders;
    private Map<String, CachedAttunityMetadataMessage> cachedMetadataMessages;
    private Conversion<BigDecimal> decimalConversion = new Conversions.DecimalConversion();
    private TimeConversions.DateConversion dateConversion = new TimeConversions.DateConversion();
    private TimeConversions.TimeConversion timeConversion = new TimeConversions.TimeConversion();
    private TimeConversions.TimestampMicrosConversion timestampConversion = new TimeConversions.TimestampMicrosConversion();

    public AttunityMessageDecoder(MetadataStore metadataStoreImplementor) throws AttunityDecoderException {
        if (metadataStoreImplementor == null) {
            throw new AttunityDecoderException(AttunityDecoderExceptionCode.NO_METADATA_STORE_DEFINED);
        }
        this.metadataStore = metadataStoreImplementor;
        this.schemaMessageReaders = new HashMap<String, DatumReader<GenericRecord>>();
        this.cachedMetadataMessages = new Hashtable<String, CachedAttunityMetadataMessage>();
    }

    public static String getVersion() {
        return _version;
    }

    private GenericRecord decodeAvroMessage(byte[] messageBytes, Schema messageSchema) throws IOException {
        return this.decodeAvroMessage(messageBytes, messageSchema, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericRecord decodeAvroMessage(byte[] messageBytes, Schema messageSchema, String schemaId) throws IOException {
        GenericRecord message;
        String readerKey;
        BinaryDecoder messageDecoder = DecoderFactory.get().binaryDecoder(messageBytes, null);
        if (schemaId != null) {
            readerKey = schemaId;
        } else {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(messageSchema.toString().getBytes());
                readerKey = Base64.encodeBase64String((byte[])md.digest());
            }
            catch (NoSuchAlgorithmException e) {
                readerKey = messageSchema.toString();
            }
        }
        DatumReader<GenericRecord> messageReader = this.schemaMessageReaders.get(readerKey);
        if (messageReader == null) {
            String e = readerKey;
            synchronized (e) {
                if (!this.schemaMessageReaders.containsKey(readerKey)) {
                    messageReader = new DatumReader<GenericRecord>(messageSchema);
                    this.schemaMessageReaders.put(readerKey, messageReader);
                } else {
                    messageReader = this.schemaMessageReaders.get(readerKey);
                }
            }
        }
        DatumReader<GenericRecord> datumReader = messageReader;
        synchronized (datumReader) {
            message = (GenericRecord)messageReader.read(null, (Decoder)messageDecoder);
        }
        return message;
    }

    private GenericRecord decodeMessageFromEnvelope(GenericRecord envelopedMessage, Schema messageSchema, String schemaId) throws IOException {
        ByteBuffer messageByteBuffer = (ByteBuffer)envelopedMessage.get("message");
        byte[] messageBytes = messageByteBuffer.array();
        return this.decodeAvroMessage(messageBytes, messageSchema, schemaId);
    }

    private GenericRecord getMetadataMessage(GenericRecord envelopedMessage) throws AttunityDecoderException {
        try {
            String messageSchemaFromEnvelope = envelopedMessage.get("messageSchema").toString();
            Schema metadataSchema = new Schema.Parser().parse(messageSchemaFromEnvelope);
            return this.decodeMessageFromEnvelope(envelopedMessage, metadataSchema, null);
        }
        catch (IOException e) {
            throw new AttunityDecoderException(AttunityDecoderExceptionCode.BAD_INPUT_MESSAGE);
        }
    }

    private GenericRecord getDataMessage(GenericRecord envelopedMessage, String schemaId) throws AttunityDecoderException {
        CachedAttunityMetadataMessage cachedMetadataMessage;
        if (this.cachedMetadataMessages.containsKey(schemaId)) {
            cachedMetadataMessage = this.cachedMetadataMessages.get(schemaId);
        } else {
            byte[] metadataData;
            try {
                metadataData = this.metadataStore.loadMetadata(schemaId);
            }
            catch (Exception e) {
                throw new AttunityDecoderException(AttunityDecoderExceptionCode.FAILED_TO_LOAD_FROM_METADATA_STORE);
            }
            if (metadataData == null) {
                throw new AttunityDecoderException(AttunityDecoderExceptionCode.NO_METADATA_FOUND_IN_METADATA_STORE, schemaId);
            }
            AttunityMetadataMessage metadataMessage = (AttunityMetadataMessage)this.decode(metadataData);
            Schema dataSchema = new Schema.Parser().parse(metadataMessage.getDataSchema());
            cachedMetadataMessage = new CachedAttunityMetadataMessage(metadataMessage, dataSchema);
            this.cachedMetadataMessages.put(schemaId, cachedMetadataMessage);
        }
        try {
            return this.decodeMessageFromEnvelope(envelopedMessage, cachedMetadataMessage.getDataSchema(), schemaId);
        }
        catch (IOException e) {
            throw new AttunityDecoderException(AttunityDecoderExceptionCode.BAD_DATA_MESSAGE);
        }
    }

    private byte[] readMask(Object mask) {
        byte[] result = null;
        if (mask != null) {
            result = ((ByteBuffer)mask).array();
            ArrayUtils.reverse((byte[])result);
        }
        return result;
    }

    private AttunityDataHeaders readDataHeaders(GenericRecord dataHeadersRecord) {
        AttunityDataHeaders dataHeaders = new AttunityDataHeaders();
        switch (dataHeadersRecord.get("operation").toString()) {
            case "INSERT": {
                dataHeaders.setOperation(AttunityDataOperation.INSERT);
                break;
            }
            case "UPDATE": {
                dataHeaders.setOperation(AttunityDataOperation.UPDATE);
                break;
            }
            case "DELETE": {
                dataHeaders.setOperation(AttunityDataOperation.DELETE);
                break;
            }
            case "REFRESH": {
                dataHeaders.setOperation(AttunityDataOperation.REFRESH);
                break;
            }
            default: {
                dataHeaders.setOperation(AttunityDataOperation.UNKNOWN);
            }
        }
        dataHeaders.setChangeSequence(dataHeadersRecord.get("changeSequence").toString());
        dataHeaders.setTimestamp(dataHeadersRecord.get("timestamp").toString());
        dataHeaders.setStreamPosition(dataHeadersRecord.get("streamPosition").toString());
        dataHeaders.setTransactionId(dataHeadersRecord.get("transactionId").toString());
        dataHeaders.setChangeMask(this.readMask(dataHeadersRecord.get("changeMask")));
        dataHeaders.setColumnMask(this.readMask(dataHeadersRecord.get("columnMask")));
        dataHeaders.setTransactionEventCounter((Long)dataHeadersRecord.get("transactionEventCounter"));
        dataHeaders.setTransactionLastEvent((Boolean)dataHeadersRecord.get("transactionLastEvent"));
        return dataHeaders;
    }

    private AttunityTableLineage readTableLineage(GenericRecord lineageRecord) {
        AttunityTableLineage tableLineage = new AttunityTableLineage();
        tableLineage.setServer(lineageRecord.get("server").toString());
        tableLineage.setTaskName(lineageRecord.get("task").toString());
        tableLineage.setSchemaName(lineageRecord.get("schema").toString());
        tableLineage.setTableName(lineageRecord.get("table").toString());
        tableLineage.setTableVersion((Long)lineageRecord.get("tableVersion"));
        tableLineage.setTimestamp(lineageRecord.get("timestamp").toString());
        return tableLineage;
    }

    private AttunityDataType readDataType(GenericRecord columnRecord) {
        AttunityDataType dataType = new AttunityDataType();
        dataType.setValueType(AttunityDataValueType.valueOf(columnRecord.get("type").toString()));
        dataType.setLength(Integer.parseInt(columnRecord.get("length").toString()));
        dataType.setPrecision(Integer.parseInt(columnRecord.get("precision").toString()));
        dataType.setScale(Integer.parseInt(columnRecord.get("scale").toString()));
        dataType.setNullable(Boolean.parseBoolean(columnRecord.get("nullable").toString()));
        return dataType;
    }

    private AttunityTableColumn[] getDataFieldsFromSchema(Schema dataSchema, GenericRecord tableStructureRecord) {
        List fields = dataSchema.getField("data").schema().getFields();
        AttunityTableColumn[] columns = new AttunityTableColumn[fields.size()];
        GenericRecord tableColumnsRecord = (GenericRecord)tableStructureRecord.get("tableColumns");
        int columnIndex = 0;
        for (Schema.Field f : fields) {
            Schema.Type fieldType;
            List unionFields;
            Schema fieldSchema = f.schema();
            columns[columnIndex] = new AttunityTableColumn();
            columns[columnIndex].setName(f.name());
            GenericRecord columnRecord = (GenericRecord)tableColumnsRecord.get(f.name());
            columns[columnIndex].setDataType(this.readDataType(columnRecord));
            columns[columnIndex].setOrdinal(Integer.parseInt(columnRecord.get("ordinal").toString()));
            columns[columnIndex].setPrimaryKeyPosition(Integer.parseInt(columnRecord.get("primaryKeyPosition").toString()));
            LogicalType schemaLogicalType = f.schema().getLogicalType();
            if (f.schema().getType() == Schema.Type.UNION && (unionFields = f.schema().getTypes()).size() > 1) {
                Schema valueBranch = (Schema)unionFields.get(1);
                schemaLogicalType = valueBranch.getLogicalType();
            }
            columns[columnIndex].setLogicalType(schemaLogicalType);
            Schema.Type checkedType = fieldType = fieldSchema.getType();
            if (fieldType == Schema.Type.UNION) {
                List fieldUnionSchemas = fieldSchema.getTypes();
                for (Schema schema : fieldUnionSchemas) {
                    if (schema.getType() == Schema.Type.NULL) continue;
                    checkedType = schema.getType();
                }
            }
            switch (checkedType) {
                case BOOLEAN: {
                    columns[columnIndex].setValueType(AttunityAvroValueType.BOOLEAN);
                    break;
                }
                case INT: {
                    columns[columnIndex].setValueType(AttunityAvroValueType.INT32);
                    break;
                }
                case LONG: {
                    columns[columnIndex].setValueType(AttunityAvroValueType.INT64);
                    break;
                }
                case FLOAT: {
                    columns[columnIndex].setValueType(AttunityAvroValueType.FLOAT);
                    break;
                }
                case DOUBLE: {
                    columns[columnIndex].setValueType(AttunityAvroValueType.DOUBLE);
                    break;
                }
                case BYTES: {
                    columns[columnIndex].setValueType(AttunityAvroValueType.BYTES);
                    break;
                }
                case STRING: {
                    columns[columnIndex].setValueType(AttunityAvroValueType.STRING);
                    break;
                }
                default: {
                    columns[columnIndex].setValueType(AttunityAvroValueType.UNKNOWN);
                }
            }
            ++columnIndex;
        }
        Arrays.sort(columns, (c1, c2) -> {
            int result = 0;
            if (c1.getOrdinal() < c2.getOrdinal()) {
                result = -1;
            } else if (c1.getOrdinal() > c2.getOrdinal()) {
                result = 1;
            }
            return result;
        });
        return columns;
    }

    private Object extractData(Object origData, AttunityTableColumn tableColumn) {
        if (origData == null || tableColumn.getLogicalType() == null) {
            return origData;
        }
        AttunityDataType type = tableColumn.getDataType();
        switch (type.getValueType()) {
            case NUMERIC: 
            case UINT8: {
                return this.decimalConversion.fromBytes((ByteBuffer)origData, null, tableColumn.getLogicalType());
            }
            case DATE: {
                return this.dateConversion.fromInt((Integer)origData, null, tableColumn.getLogicalType()).toDate();
            }
            case TIME: {
                return this.timeConversion.fromInt((Integer)origData, null, tableColumn.getLogicalType());
            }
            case DATETIME: {
                return this.timestampConversion.fromLong((Long)origData, null, tableColumn.getLogicalType());
            }
        }
        System.out.println("to handle..");
        return origData;
    }

    private AttunityDataColumn[] getDataFields(GenericRecord dataRecord, AttunityDataHeaders dataHeaders, AttunityTableColumn[] tableColumns) {
        if (dataRecord == null) {
            return null;
        }
        byte[] columnMask = dataHeaders.getColumnMask();
        byte[] changeMask = dataHeaders.getChangeMask();
        BitSet columnMaskBitSet = null;
        BitSet changeMaskBitSet = null;
        int includedColumnsCount = tableColumns.length;
        if (columnMask != null) {
            columnMaskBitSet = BitSet.valueOf(columnMask);
            includedColumnsCount = columnMaskBitSet.cardinality();
        }
        if (changeMask != null) {
            changeMaskBitSet = BitSet.valueOf(changeMask);
        }
        AttunityDataColumn[] dataColumns = new AttunityDataColumn[includedColumnsCount];
        int dataColumnsIndex = 0;
        for (int i = 0; i < tableColumns.length; ++i) {
            if (columnMask != null && !columnMaskBitSet.get(i)) continue;
            AttunityTableColumn tableColumn = tableColumns[i];
            dataColumns[dataColumnsIndex] = new AttunityDataColumn();
            dataColumns[dataColumnsIndex].setAttunityTableColumn(tableColumn);
            Object data = this.extractData(dataRecord.get(tableColumn.getName()), tableColumn);
            dataColumns[dataColumnsIndex].setData(data);
            if (changeMask != null) {
                dataColumns[dataColumnsIndex].setChanged(changeMaskBitSet.get(i));
            }
            if (++dataColumnsIndex == includedColumnsCount) break;
        }
        return dataColumns;
    }

    private AttunityMetadataMessage createMetadataMessage(GenericRecord metadataGenericRecord) {
        AttunityMetadataMessage metadataMessage = new AttunityMetadataMessage();
        metadataMessage.setSchemaId(metadataGenericRecord.get("schemaId").toString());
        metadataMessage.setLineage(this.readTableLineage((GenericRecord)metadataGenericRecord.get("lineage")));
        metadataMessage.setDataSchema(metadataGenericRecord.get("dataSchema").toString());
        Schema dataSchema = new Schema.Parser().parse(metadataMessage.getDataSchema());
        metadataMessage.setTableColumns(this.getDataFieldsFromSchema(dataSchema, (GenericRecord)metadataGenericRecord.get("tableStructure")));
        this.cachedMetadataMessages.put(metadataMessage.getSchemaId(), new CachedAttunityMetadataMessage(metadataMessage, dataSchema));
        return metadataMessage;
    }

    private AttunityDataMessage createDataMessage(GenericRecord dataGenericRecord, String schemaId) {
        AttunityDataMessage dataMessage = new AttunityDataMessage();
        AttunityDataHeaders dataHeaders = this.readDataHeaders((GenericRecord)dataGenericRecord.get("headers"));
        AttunityMetadataMessage metadataMessage = this.cachedMetadataMessages.get(schemaId).getMetadataMessage();
        AttunityTableColumn[] tableColumns = metadataMessage.getTableColumns();
        dataMessage.setSchemaId(schemaId);
        dataMessage.setDataHeaders(dataHeaders);
        dataMessage.setLineage(metadataMessage.getLineage());
        dataMessage.setDataColumns(this.getDataFields((GenericRecord)dataGenericRecord.get("data"), dataHeaders, tableColumns));
        dataMessage.setBeforeDataColumns(this.getDataFields((GenericRecord)dataGenericRecord.get("beforeData"), dataHeaders, tableColumns));
        return dataMessage;
    }

    private Map<String, String> extractEnvelopedMessageHeaders(GenericRecord envelopedMessage) {
        return (Map)envelopedMessage.get("headers");
    }

    private AttunityMessageType extractEnvelopedMessageType(GenericRecord envelopedMessage) {
        String messageType;
        switch (messageType = envelopedMessage.get("type").toString()) {
            case "MD": {
                return AttunityMessageType.METADATA;
            }
            case "DT": {
                return AttunityMessageType.DATA;
            }
        }
        return AttunityMessageType.UNKNOWN;
    }

    private boolean validateMagicField(GenericRecord envelopedMessage) {
        GenericFixed messageMagicBytes = (GenericFixed)envelopedMessage.get("magic");
        byte[] magicBytes = messageMagicBytes.bytes();
        if (Arrays.equals(magicBytes, attunityMessageMagic)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public AttunityMessage decode(byte[] message) throws AttunityDecoderException {
        AttunityMessage returnedMessage;
        GenericRecord messageBody;
        GenericRecord envelopedMessage;
        try {
            envelopedMessage = this.decodeAvroMessage(message, _envelopeSchema);
        }
        catch (IOException e) {
            throw new AttunityDecoderException(AttunityDecoderExceptionCode.BAD_INPUT_MESSAGE);
        }
        if (!this.validateMagicField(envelopedMessage)) {
            throw new AttunityDecoderException(AttunityDecoderExceptionCode.BAD_MAGIC_VALUE);
        }
        Map<String, String> messageHeaders = this.extractEnvelopedMessageHeaders(envelopedMessage);
        AttunityMessageType messageType = this.extractEnvelopedMessageType(envelopedMessage);
        switch (messageType) {
            case METADATA: {
                messageBody = this.getMetadataMessage(envelopedMessage);
                returnedMessage = this.createMetadataMessage(messageBody);
                try {
                    this.metadataStore.saveMetadata(((AttunityMetadataMessage)returnedMessage).getSchemaId(), message);
                    break;
                }
                catch (Exception e) {
                    throw new AttunityDecoderException(AttunityDecoderExceptionCode.FAILED_TO_SAVE_INTO_METADATA_STORE);
                }
            }
            case DATA: {
                String schemaId = envelopedMessage.get("messageSchemaId").toString();
                messageBody = this.getDataMessage(envelopedMessage, schemaId);
                returnedMessage = this.createDataMessage(messageBody, schemaId);
                break;
            }
            default: {
                throw new AttunityDecoderException(AttunityDecoderExceptionCode.UNRECOGNIZED_MESSAGE);
            }
        }
        returnedMessage.setHeaders(messageHeaders);
        returnedMessage.setRawMessage(messageBody);
        return returnedMessage;
    }

    private class CachedAttunityMetadataMessage {
        private AttunityMetadataMessage metadataMessage;
        private Schema dataSchema;

        CachedAttunityMetadataMessage(AttunityMetadataMessage metadataMessage, Schema dataSchema) {
            this.metadataMessage = metadataMessage;
            this.dataSchema = dataSchema;
        }

        AttunityMetadataMessage getMetadataMessage() {
            return this.metadataMessage;
        }

        Schema getDataSchema() {
            return this.dataSchema;
        }
    }
}

