/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.ClaimsBasedSecurityNode;
import com.azure.core.amqp.implementation.ActiveClientTokenManager;
import com.azure.core.amqp.implementation.TokenManager;
import com.azure.core.amqp.implementation.TokenManagerProvider;
import com.azure.core.amqp.models.CbsAuthorizationType;
import com.azure.core.util.logging.ClientLogger;
import java.util.Locale;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class AzureTokenManagerProvider
implements TokenManagerProvider {
    static final String TOKEN_AUDIENCE_FORMAT = "amqp://%s/%s";
    private static final ClientLogger LOGGER = new ClientLogger(AzureTokenManagerProvider.class);
    private final CbsAuthorizationType authorizationType;
    private final String fullyQualifiedNamespace;
    private final String activeDirectoryScope;

    public AzureTokenManagerProvider(CbsAuthorizationType authorizationType, String fullyQualifiedNamespace, String activeDirectoryScope) {
        this.activeDirectoryScope = Objects.requireNonNull(activeDirectoryScope, "'activeDirectoryScope' cannot be null.");
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.authorizationType = Objects.requireNonNull(authorizationType, "'authorizationType' cannot be null.");
    }

    @Override
    public TokenManager getTokenManager(Mono<ClaimsBasedSecurityNode> cbsNodeMono, String resource) {
        String scopes = this.getScopesFromResource(resource);
        String tokenAudience = String.format(Locale.US, TOKEN_AUDIENCE_FORMAT, this.fullyQualifiedNamespace, resource);
        LOGGER.atVerbose().addKeyValue("audience", tokenAudience).addKeyValue("resource", resource).log("Creating new token manager.");
        return new ActiveClientTokenManager(cbsNodeMono, tokenAudience, scopes);
    }

    @Override
    public String getScopesFromResource(String resource) {
        if (CbsAuthorizationType.JSON_WEB_TOKEN.equals((Object)this.authorizationType)) {
            return this.activeDirectoryScope;
        }
        if (CbsAuthorizationType.SHARED_ACCESS_SIGNATURE.equals((Object)this.authorizationType)) {
            return String.format(Locale.US, TOKEN_AUDIENCE_FORMAT, this.fullyQualifiedNamespace, resource);
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Locale.US, "'%s' is not supported authorization type for token audience.", new Object[]{this.authorizationType})));
    }
}

