/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.amqp.implementation.AmqpConstants;
import com.azure.core.amqp.implementation.ErrorContextProvider;
import com.azure.core.amqp.models.AmqpAnnotatedMessage;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.EventHubsProducerInstrumentation;
import com.azure.messaging.eventhubs.implementation.MessageUtils;
import com.azure.messaging.eventhubs.implementation.instrumentation.EventHubsTracer;
import java.nio.BufferOverflowException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.message.Message;

public final class EventDataBatch {
    private static final ClientLogger LOGGER = new ClientLogger(EventDataBatch.class);
    private final int maxMessageSize;
    private final String partitionKey;
    private final ErrorContextProvider contextProvider;
    private final List<EventData> events;
    private final byte[] eventBytes;
    private final String partitionId;
    private int sizeInBytes;
    private final EventHubsTracer tracer;

    EventDataBatch(int maxMessageSize, String partitionId, String partitionKey, ErrorContextProvider contextProvider, EventHubsProducerInstrumentation instrumentation) {
        this.maxMessageSize = maxMessageSize;
        this.partitionKey = partitionKey;
        this.partitionId = partitionId;
        this.contextProvider = contextProvider;
        this.events = new LinkedList<EventData>();
        this.sizeInBytes = maxMessageSize / 65536 * 1024;
        this.eventBytes = new byte[maxMessageSize];
        this.tracer = instrumentation.getTracer();
    }

    public int getCount() {
        return this.events.size();
    }

    public int getMaxSizeInBytes() {
        return this.maxMessageSize;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public boolean tryAdd(EventData eventData) {
        int size;
        if (eventData == null) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new NullPointerException("eventData cannot be null"));
        }
        this.tracer.reportMessageSpan(eventData, eventData.getContext());
        try {
            size = this.getSize(eventData, this.events.isEmpty());
        }
        catch (BufferOverflowException exception) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new AmqpException(false, AmqpErrorCondition.LINK_PAYLOAD_SIZE_EXCEEDED, String.format(Locale.US, "Size of the payload exceeded maximum message size: %s kb", this.maxMessageSize / 1024), this.contextProvider.getErrorContext()));
        }
        if (this.sizeInBytes + size > this.maxMessageSize) {
            return false;
        }
        this.sizeInBytes += size;
        this.events.add(eventData);
        return true;
    }

    List<EventData> getEvents() {
        return this.events;
    }

    String getPartitionKey() {
        return this.partitionKey;
    }

    String getPartitionId() {
        return this.partitionId;
    }

    private int getSize(EventData eventData, boolean isFirst) {
        Objects.requireNonNull(eventData, "'eventData' cannot be null.");
        Message amqpMessage = EventDataBatch.createAmqpMessage(eventData, this.partitionKey);
        int eventSize = amqpMessage.encode(this.eventBytes, 0, this.maxMessageSize);
        eventSize += 16;
        if (isFirst) {
            amqpMessage.setBody(null);
            amqpMessage.setApplicationProperties(null);
            amqpMessage.setProperties(null);
            amqpMessage.setDeliveryAnnotations(null);
            eventSize += amqpMessage.encode(this.eventBytes, 0, this.maxMessageSize);
        }
        return eventSize;
    }

    private static Message createAmqpMessage(EventData event, String partitionKey) {
        AmqpAnnotatedMessage amqpAnnotatedMessage = event.getRawAmqpMessage();
        Message protonJ = MessageUtils.toProtonJMessage(amqpAnnotatedMessage);
        if (partitionKey == null) {
            return protonJ;
        }
        if (protonJ.getMessageAnnotations() == null) {
            protonJ.setMessageAnnotations(new MessageAnnotations(new HashMap()));
        }
        MessageAnnotations messageAnnotations = protonJ.getMessageAnnotations();
        messageAnnotations.getValue().put(AmqpConstants.PARTITION_KEY, partitionKey);
        return protonJ;
    }
}

