/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.servicebus.administration.implementation.ServiceBusManagementClientImpl;
import com.azure.messaging.servicebus.administration.implementation.models.ServiceBusManagementErrorException;
import reactor.core.publisher.Mono;

public final class EntitiesImpl {
    private final EntitiesService service;
    private final ServiceBusManagementClientImpl client;

    EntitiesImpl(ServiceBusManagementClientImpl client) {
        this.service = (EntitiesService)RestProxy.create(EntitiesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> getWithResponseAsync(String entityName, Boolean enrich) {
        String accept = "application/xml, application/atom+xml";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), entityName, enrich, this.client.getApiVersion(), "application/xml, application/atom+xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> getWithResponseAsync(String entityName, Boolean enrich, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.get(this.client.getEndpoint(), entityName, enrich, this.client.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> getAsync(String entityName, Boolean enrich) {
        return this.getWithResponseAsync(entityName, enrich).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> getAsync(String entityName, Boolean enrich, Context context) {
        return this.getWithResponseAsync(entityName, enrich, context).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Object> getWithResponse(String entityName, Boolean enrich, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.getSync(this.client.getEndpoint(), entityName, enrich, this.client.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Object get(String entityName, Boolean enrich) {
        return this.getWithResponse(entityName, enrich, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> putWithResponseAsync(String entityName, Object requestBody, String ifMatch) {
        String accept = "application/xml, application/atom+xml";
        return FluxUtil.withContext(context -> this.service.put(this.client.getEndpoint(), entityName, this.client.getApiVersion(), ifMatch, requestBody, "application/xml, application/atom+xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> putWithResponseAsync(String entityName, Object requestBody, String ifMatch, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.put(this.client.getEndpoint(), entityName, this.client.getApiVersion(), ifMatch, requestBody, "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> putAsync(String entityName, Object requestBody, String ifMatch) {
        return this.putWithResponseAsync(entityName, requestBody, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> putAsync(String entityName, Object requestBody, String ifMatch, Context context) {
        return this.putWithResponseAsync(entityName, requestBody, ifMatch, context).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Object> putWithResponse(String entityName, Object requestBody, String ifMatch, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.putSync(this.client.getEndpoint(), entityName, this.client.getApiVersion(), ifMatch, requestBody, "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Object put(String entityName, Object requestBody, String ifMatch) {
        return this.putWithResponse(entityName, requestBody, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> deleteWithResponseAsync(String entityName) {
        String accept = "application/xml, application/atom+xml";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), entityName, this.client.getApiVersion(), "application/xml, application/atom+xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> deleteWithResponseAsync(String entityName, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.delete(this.client.getEndpoint(), entityName, this.client.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> deleteAsync(String entityName) {
        return this.deleteWithResponseAsync(entityName).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> deleteAsync(String entityName, Context context) {
        return this.deleteWithResponseAsync(entityName, context).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Object> deleteWithResponse(String entityName, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.deleteSync(this.client.getEndpoint(), entityName, this.client.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Object delete(String entityName) {
        return this.deleteWithResponse(entityName, Context.NONE).getValue();
    }

    @Host(value="https://{endpoint}")
    @ServiceInterface(name="ServiceBusManagement")
    public static interface EntitiesService {
        @Get(value="/{entityName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<Object>> get(@HostParam(value="endpoint") String var1, @PathParam(value="entityName") String var2, @QueryParam(value="enrich") Boolean var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/{entityName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Response<Object> getSync(@HostParam(value="endpoint") String var1, @PathParam(value="entityName") String var2, @QueryParam(value="enrich") Boolean var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Put(value="/{entityName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<Object>> put(@HostParam(value="endpoint") String var1, @PathParam(value="entityName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-Match") String var4, @BodyParam(value="application/atom+xml") Object var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Put(value="/{entityName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Response<Object> putSync(@HostParam(value="endpoint") String var1, @PathParam(value="entityName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-Match") String var4, @BodyParam(value="application/atom+xml") Object var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Delete(value="/{entityName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<Object>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="entityName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/{entityName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Response<Object> deleteSync(@HostParam(value="endpoint") String var1, @PathParam(value="entityName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

