/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.IdentifierProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

public final class IdentifierInner
extends ProxyOnlyResource {
    private IdentifierProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private IdentifierProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public IdentifierInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    public IdentifierInner withValue(String value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IdentifierProperties();
        }
        this.innerProperties().withValue(value);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static IdentifierInner fromJson(JsonReader jsonReader) throws IOException {
        return (IdentifierInner)((Object)jsonReader.readObject(reader -> {
            IdentifierInner deserializedIdentifierInner = new IdentifierInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedIdentifierInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedIdentifierInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIdentifierInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedIdentifierInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedIdentifierInner.innerProperties = IdentifierProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdentifierInner;
        }));
    }
}

