/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.HybridConnectionInner;
import com.azure.resourcemanager.appservice.fluent.models.NetworkFeaturesProperties;
import com.azure.resourcemanager.appservice.fluent.models.RelayServiceConnectionEntityInner;
import com.azure.resourcemanager.appservice.fluent.models.VnetInfo;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.util.List;

public final class NetworkFeaturesInner
extends ProxyOnlyResource {
    private NetworkFeaturesProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private NetworkFeaturesProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public NetworkFeaturesInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String virtualNetworkName() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkName();
    }

    public VnetInfo virtualNetworkConnection() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkConnection();
    }

    public List<RelayServiceConnectionEntityInner> hybridConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().hybridConnections();
    }

    public List<HybridConnectionInner> hybridConnectionsV2() {
        return this.innerProperties() == null ? null : this.innerProperties().hybridConnectionsV2();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NetworkFeaturesInner fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkFeaturesInner)((Object)jsonReader.readObject(reader -> {
            NetworkFeaturesInner deserializedNetworkFeaturesInner = new NetworkFeaturesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNetworkFeaturesInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNetworkFeaturesInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNetworkFeaturesInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedNetworkFeaturesInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNetworkFeaturesInner.innerProperties = NetworkFeaturesProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkFeaturesInner;
        }));
    }
}

