/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.RelayServiceConnectionEntityProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

public final class RelayServiceConnectionEntityInner
extends ProxyOnlyResource {
    private RelayServiceConnectionEntityProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private RelayServiceConnectionEntityProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public RelayServiceConnectionEntityInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String entityName() {
        return this.innerProperties() == null ? null : this.innerProperties().entityName();
    }

    public RelayServiceConnectionEntityInner withEntityName(String entityName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RelayServiceConnectionEntityProperties();
        }
        this.innerProperties().withEntityName(entityName);
        return this;
    }

    public String entityConnectionString() {
        return this.innerProperties() == null ? null : this.innerProperties().entityConnectionString();
    }

    public RelayServiceConnectionEntityInner withEntityConnectionString(String entityConnectionString) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RelayServiceConnectionEntityProperties();
        }
        this.innerProperties().withEntityConnectionString(entityConnectionString);
        return this;
    }

    public String resourceType() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceType();
    }

    public RelayServiceConnectionEntityInner withResourceType(String resourceType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RelayServiceConnectionEntityProperties();
        }
        this.innerProperties().withResourceType(resourceType);
        return this;
    }

    public String resourceConnectionString() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceConnectionString();
    }

    public RelayServiceConnectionEntityInner withResourceConnectionString(String resourceConnectionString) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RelayServiceConnectionEntityProperties();
        }
        this.innerProperties().withResourceConnectionString(resourceConnectionString);
        return this;
    }

    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    public RelayServiceConnectionEntityInner withHostname(String hostname) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RelayServiceConnectionEntityProperties();
        }
        this.innerProperties().withHostname(hostname);
        return this;
    }

    public Integer port() {
        return this.innerProperties() == null ? null : this.innerProperties().port();
    }

    public RelayServiceConnectionEntityInner withPort(Integer port) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RelayServiceConnectionEntityProperties();
        }
        this.innerProperties().withPort(port);
        return this;
    }

    public String biztalkUri() {
        return this.innerProperties() == null ? null : this.innerProperties().biztalkUri();
    }

    public RelayServiceConnectionEntityInner withBiztalkUri(String biztalkUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RelayServiceConnectionEntityProperties();
        }
        this.innerProperties().withBiztalkUri(biztalkUri);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RelayServiceConnectionEntityInner fromJson(JsonReader jsonReader) throws IOException {
        return (RelayServiceConnectionEntityInner)((Object)jsonReader.readObject(reader -> {
            RelayServiceConnectionEntityInner deserializedRelayServiceConnectionEntityInner = new RelayServiceConnectionEntityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRelayServiceConnectionEntityInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRelayServiceConnectionEntityInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRelayServiceConnectionEntityInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedRelayServiceConnectionEntityInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRelayServiceConnectionEntityInner.innerProperties = RelayServiceConnectionEntityProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRelayServiceConnectionEntityInner;
        }));
    }
}

