/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.SwiftVirtualNetworkProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

public final class SwiftVirtualNetworkInner
extends ProxyOnlyResource {
    private SwiftVirtualNetworkProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private SwiftVirtualNetworkProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public SwiftVirtualNetworkInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String subnetResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetResourceId();
    }

    public SwiftVirtualNetworkInner withSubnetResourceId(String subnetResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SwiftVirtualNetworkProperties();
        }
        this.innerProperties().withSubnetResourceId(subnetResourceId);
        return this;
    }

    public Boolean swiftSupported() {
        return this.innerProperties() == null ? null : this.innerProperties().swiftSupported();
    }

    public SwiftVirtualNetworkInner withSwiftSupported(Boolean swiftSupported) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SwiftVirtualNetworkProperties();
        }
        this.innerProperties().withSwiftSupported(swiftSupported);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SwiftVirtualNetworkInner fromJson(JsonReader jsonReader) throws IOException {
        return (SwiftVirtualNetworkInner)((Object)jsonReader.readObject(reader -> {
            SwiftVirtualNetworkInner deserializedSwiftVirtualNetworkInner = new SwiftVirtualNetworkInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSwiftVirtualNetworkInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSwiftVirtualNetworkInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSwiftVirtualNetworkInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedSwiftVirtualNetworkInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSwiftVirtualNetworkInner.innerProperties = SwiftVirtualNetworkProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSwiftVirtualNetworkInner;
        }));
    }
}

