/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowState;
import com.azure.resourcemanager.appservice.models.WorkflowStatus;
import com.azure.resourcemanager.appservice.models.WorkflowTriggerProvisioningState;
import com.azure.resourcemanager.appservice.models.WorkflowTriggerRecurrence;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class WorkflowTriggerProperties
implements JsonSerializable<WorkflowTriggerProperties> {
    private WorkflowTriggerProvisioningState provisioningState;
    private OffsetDateTime createdTime;
    private OffsetDateTime changedTime;
    private WorkflowState state;
    private WorkflowStatus status;
    private OffsetDateTime lastExecutionTime;
    private OffsetDateTime nextExecutionTime;
    private WorkflowTriggerRecurrence recurrence;
    private ResourceReference workflow;

    public WorkflowTriggerProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public OffsetDateTime changedTime() {
        return this.changedTime;
    }

    public WorkflowState state() {
        return this.state;
    }

    public WorkflowStatus status() {
        return this.status;
    }

    public OffsetDateTime lastExecutionTime() {
        return this.lastExecutionTime;
    }

    public OffsetDateTime nextExecutionTime() {
        return this.nextExecutionTime;
    }

    public WorkflowTriggerRecurrence recurrence() {
        return this.recurrence;
    }

    public ResourceReference workflow() {
        return this.workflow;
    }

    public void validate() {
        if (this.recurrence() != null) {
            this.recurrence().validate();
        }
        if (this.workflow() != null) {
            this.workflow().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static WorkflowTriggerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowTriggerProperties)jsonReader.readObject(reader -> {
            WorkflowTriggerProperties deserializedWorkflowTriggerProperties = new WorkflowTriggerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedWorkflowTriggerProperties.provisioningState = WorkflowTriggerProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("createdTime".equals(fieldName)) {
                    deserializedWorkflowTriggerProperties.createdTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("changedTime".equals(fieldName)) {
                    deserializedWorkflowTriggerProperties.changedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedWorkflowTriggerProperties.state = WorkflowState.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedWorkflowTriggerProperties.status = WorkflowStatus.fromString(reader.getString());
                    continue;
                }
                if ("lastExecutionTime".equals(fieldName)) {
                    deserializedWorkflowTriggerProperties.lastExecutionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("nextExecutionTime".equals(fieldName)) {
                    deserializedWorkflowTriggerProperties.nextExecutionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("recurrence".equals(fieldName)) {
                    deserializedWorkflowTriggerProperties.recurrence = WorkflowTriggerRecurrence.fromJson(reader);
                    continue;
                }
                if ("workflow".equals(fieldName)) {
                    deserializedWorkflowTriggerProperties.workflow = ResourceReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowTriggerProperties;
        });
    }
}

