/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.PrivateLinkResourceProperties;
import java.io.IOException;

public final class PrivateLinkResource
implements JsonSerializable<PrivateLinkResource> {
    private String id;
    private String name;
    private String type;
    private PrivateLinkResourceProperties properties;
    private static final ClientLogger LOGGER = new ClientLogger(PrivateLinkResource.class);

    public String id() {
        return this.id;
    }

    public PrivateLinkResource withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PrivateLinkResource withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public PrivateLinkResource withType(String type) {
        this.type = type;
        return this;
    }

    public PrivateLinkResourceProperties properties() {
        return this.properties;
    }

    public PrivateLinkResource withProperties(PrivateLinkResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model PrivateLinkResource"));
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model PrivateLinkResource"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model PrivateLinkResource"));
        }
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model PrivateLinkResource"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static PrivateLinkResource fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateLinkResource)jsonReader.readObject(reader -> {
            PrivateLinkResource deserializedPrivateLinkResource = new PrivateLinkResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPrivateLinkResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPrivateLinkResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPrivateLinkResource.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPrivateLinkResource.properties = PrivateLinkResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateLinkResource;
        });
    }
}

