/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.bucket;

import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.RiakException;
import com.basho.riak.client.bucket.Bucket;
import com.basho.riak.client.bucket.BucketProperties;
import com.basho.riak.client.builders.RiakObjectBuilder;
import com.basho.riak.client.cap.ClobberMutation;
import com.basho.riak.client.cap.DefaultResolver;
import com.basho.riak.client.cap.Mutation;
import com.basho.riak.client.cap.Quorum;
import com.basho.riak.client.cap.Retrier;
import com.basho.riak.client.convert.Converter;
import com.basho.riak.client.convert.JSONConverter;
import com.basho.riak.client.convert.KeyUtil;
import com.basho.riak.client.convert.NoKeySpecifiedException;
import com.basho.riak.client.convert.PassThroughConverter;
import com.basho.riak.client.operations.CounterObject;
import com.basho.riak.client.operations.DeleteObject;
import com.basho.riak.client.operations.FetchObject;
import com.basho.riak.client.operations.MultiFetchObject;
import com.basho.riak.client.operations.StoreObject;
import com.basho.riak.client.query.StreamingOperation;
import com.basho.riak.client.query.functions.NamedErlangFunction;
import com.basho.riak.client.query.functions.NamedFunction;
import com.basho.riak.client.query.indexes.FetchIndex;
import com.basho.riak.client.query.indexes.RiakIndex;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.util.CharsetUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBucket
implements Bucket {
    private final String name;
    private final BucketProperties properties;
    private final RawClient client;
    private final Retrier retrier;

    protected DefaultBucket(String name, BucketProperties properties, RawClient client, Retrier retrier) {
        this.name = name;
        this.properties = properties;
        this.client = client;
        this.retrier = retrier;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Boolean getAllowSiblings() {
        return this.properties.getAllowSiblings();
    }

    @Override
    public Boolean getLastWriteWins() {
        return this.properties.getLastWriteWins();
    }

    @Override
    public Integer getNVal() {
        return this.properties.getNVal();
    }

    @Override
    public String getBackend() {
        return this.properties.getBackend();
    }

    @Override
    public Integer getSmallVClock() {
        return this.properties.getSmallVClock();
    }

    @Override
    public Integer getBigVClock() {
        return this.properties.getBigVClock();
    }

    @Override
    public Long getYoungVClock() {
        return this.properties.getYoungVClock();
    }

    @Override
    public Long getOldVClock() {
        return this.properties.getOldVClock();
    }

    @Override
    public Collection<NamedFunction> getPrecommitHooks() {
        return this.properties.getPrecommitHooks();
    }

    @Override
    public Collection<NamedErlangFunction> getPostcommitHooks() {
        return this.properties.getPostcommitHooks();
    }

    @Override
    public Quorum getR() {
        return this.properties.getR();
    }

    @Override
    public Quorum getW() {
        return this.properties.getW();
    }

    @Override
    public Quorum getRW() {
        return this.properties.getRW();
    }

    @Override
    public Quorum getDW() {
        return this.properties.getDW();
    }

    @Override
    public Quorum getPR() {
        return this.properties.getPR();
    }

    @Override
    public Quorum getPW() {
        return this.properties.getPW();
    }

    @Override
    public Boolean getBasicQuorum() {
        return this.properties.getBasicQuorum();
    }

    @Override
    public Boolean getNotFoundOK() {
        return this.properties.getNotFoundOK();
    }

    @Override
    public NamedErlangFunction getChashKeyFunction() {
        return this.properties.getChashKeyFunction();
    }

    @Override
    public NamedErlangFunction getLinkWalkFunction() {
        return this.properties.getLinkWalkFunction();
    }

    @Override
    public Boolean getSearch() {
        return this.properties.getSearch();
    }

    @Override
    public boolean isSearchEnabled() {
        return this.properties.isSearchEnabled();
    }

    @Override
    public StreamingOperation<String> keys() throws RiakException {
        try {
            return this.client.listKeys(this.name);
        }
        catch (IOException e) {
            throw new RiakException(e);
        }
    }

    @Override
    public StoreObject<IRiakObject> store(final String key, final byte[] value) {
        return new StoreObject<IRiakObject>(this.client, this.name, key, this.retrier).withMutator(new Mutation<IRiakObject>(){

            @Override
            public IRiakObject apply(IRiakObject original) {
                if (original == null) {
                    return RiakObjectBuilder.newBuilder(DefaultBucket.this.name, key).withValue(value).withContentType("application/octet-stream").build();
                }
                original.setValue(value);
                return original;
            }
        }).withResolver(new DefaultResolver()).withConverter(new PassThroughConverter());
    }

    @Override
    public StoreObject<IRiakObject> store(final String key, final String value) {
        Mutation<IRiakObject> m = new Mutation<IRiakObject>(){

            @Override
            public IRiakObject apply(IRiakObject original) {
                if (original == null) {
                    return RiakObjectBuilder.newBuilder(DefaultBucket.this.name, key).withValue(value).withContentType("text/plain; charset=UTF-8").build();
                }
                original.setValue(CharsetUtils.utf8StringToBytes(value));
                original.setContentType("text/plain; charset=UTF-8");
                return original;
            }
        };
        return this.store(key, (Object)CharsetUtils.utf8StringToBytes(value)).withMutator((Mutation<byte[]>)m);
    }

    @Override
    public <T> StoreObject<T> store(T o) {
        Class<?> clazz = o.getClass();
        String key = KeyUtil.getKey(o);
        Converter<?> converter = this.getDefaultConverter(clazz);
        return new StoreObject(this.client, this.name, key, this.retrier).withConverter(converter).withMutator(new ClobberMutation<T>(o)).withResolver(new DefaultResolver());
    }

    private <T> Converter<T> getDefaultConverter(Class<T> clazz) {
        return this.getDefaultConverter(clazz, null);
    }

    private <T> Converter<T> getDefaultConverter(Class<T> clazz, String key) {
        Converter<IRiakObject> converter = IRiakObject.class.isAssignableFrom(clazz) ? new PassThroughConverter() : (key != null ? new JSONConverter<T>(clazz, this.name, key) : new JSONConverter<T>(clazz, this.name));
        return converter;
    }

    @Override
    public <T> StoreObject<T> store(String key, T o) {
        Class<?> clazz = o.getClass();
        Converter<?> converter = this.getDefaultConverter(clazz, key);
        return new StoreObject(this.client, this.name, key, this.retrier).withConverter(converter).withMutator(new ClobberMutation<T>(o)).withResolver(new DefaultResolver());
    }

    @Override
    public <T> FetchObject<T> fetch(T o) {
        Class<?> clazz = o.getClass();
        String key = KeyUtil.getKey(o);
        if (key == null) {
            throw new NoKeySpecifiedException(o);
        }
        Converter<?> converter = this.getDefaultConverter(clazz);
        return new FetchObject(this.client, this.name, key, this.retrier).withConverter(converter).withResolver(new DefaultResolver());
    }

    @Override
    public <T> FetchObject<T> fetch(String key, Class<T> type) {
        Converter<T> converter = this.getDefaultConverter(type, key);
        return new FetchObject<T>(this.client, this.name, key, this.retrier).withConverter(converter).withResolver(new DefaultResolver());
    }

    @Override
    public FetchObject<IRiakObject> fetch(String key) {
        return new FetchObject(this.client, this.name, key, this.retrier).withResolver(new DefaultResolver()).withConverter(new PassThroughConverter());
    }

    @Override
    public <T> DeleteObject delete(T o) {
        String key = KeyUtil.getKey(o);
        if (key == null) {
            throw new NoKeySpecifiedException(o);
        }
        return new DeleteObject(this.client, this.name, key, this.retrier);
    }

    @Override
    public DeleteObject delete(String key) {
        return new DeleteObject(this.client, this.name, key, this.retrier);
    }

    @Override
    public <T> FetchIndex<T> fetchIndex(RiakIndex<T> index) {
        return new FetchIndex<T>(this.client, this.name, index, this.retrier);
    }

    @Override
    public MultiFetchObject<IRiakObject> multiFetch(String[] keys) {
        return new MultiFetchObject(this.client, this.name, Arrays.asList(keys), this.retrier).withResolver(new DefaultResolver()).withConverter(new PassThroughConverter());
    }

    @Override
    public <T> MultiFetchObject<T> multiFetch(List<String> keys, Class<T> type) {
        Converter<T> converter = this.getDefaultConverter(type, keys.get(0));
        return new MultiFetchObject<T>(this.client, this.name, keys, this.retrier).withConverter(converter).withResolver(new DefaultResolver());
    }

    @Override
    public <T> MultiFetchObject<T> multiFetch(List<T> objs) {
        T o = objs.get(0);
        Class<?> clazz = o.getClass();
        ArrayList<String> keyList = new ArrayList<String>(objs.size());
        for (T obj : objs) {
            String key = KeyUtil.getKey(obj);
            if (key == null) {
                throw new NoKeySpecifiedException(o);
            }
            keyList.add(key);
        }
        Converter<?> converter = this.getDefaultConverter(clazz);
        return new MultiFetchObject(this.client, this.name, keyList, this.retrier).withConverter(converter).withResolver(new DefaultResolver());
    }

    @Override
    public CounterObject counter(String counter) {
        return new CounterObject(this.client, this.name, counter);
    }
}

