/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.bucket;

import com.basho.riak.client.bucket.BucketProperties;
import com.basho.riak.client.cap.Quorum;
import com.basho.riak.client.cap.Retrier;
import com.basho.riak.client.query.functions.NamedErlangFunction;
import com.basho.riak.client.query.functions.NamedFunction;
import com.basho.riak.client.raw.RawClient;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyBucketProperties
implements BucketProperties {
    private final FutureTask<BucketProperties> future;

    public LazyBucketProperties(final RawClient client, final Retrier retrier, final String bucket) {
        this.future = new FutureTask<BucketProperties>(new Callable<BucketProperties>(){

            @Override
            public BucketProperties call() throws Exception {
                return retrier.attempt(new Callable<BucketProperties>(){

                    @Override
                    public BucketProperties call() throws Exception {
                        return client.fetchBucket(bucket);
                    }
                });
            }
        });
    }

    @Override
    public Boolean getAllowSiblings() {
        return this.getProperties().getAllowSiblings();
    }

    @Override
    public Boolean getLastWriteWins() {
        return this.getProperties().getLastWriteWins();
    }

    @Override
    public Integer getNVal() {
        return this.getProperties().getNVal();
    }

    @Override
    public String getBackend() {
        return this.getProperties().getBackend();
    }

    @Override
    public Integer getSmallVClock() {
        return this.getProperties().getSmallVClock();
    }

    @Override
    public Integer getBigVClock() {
        return this.getProperties().getBigVClock();
    }

    @Override
    public Long getYoungVClock() {
        return this.getProperties().getYoungVClock();
    }

    @Override
    public Long getOldVClock() {
        return this.getProperties().getOldVClock();
    }

    @Override
    public Collection<NamedFunction> getPrecommitHooks() {
        return this.getProperties().getPrecommitHooks();
    }

    @Override
    public Collection<NamedErlangFunction> getPostcommitHooks() {
        return this.getProperties().getPostcommitHooks();
    }

    @Override
    public Quorum getR() {
        return this.getProperties().getR();
    }

    @Override
    public Quorum getW() {
        return this.getProperties().getW();
    }

    @Override
    public Quorum getRW() {
        return this.getProperties().getRW();
    }

    @Override
    public Quorum getDW() {
        return this.getProperties().getDW();
    }

    @Override
    public Quorum getPR() {
        return this.getProperties().getPR();
    }

    @Override
    public Quorum getPW() {
        return this.getProperties().getPW();
    }

    @Override
    public Boolean getBasicQuorum() {
        return this.getProperties().getBasicQuorum();
    }

    @Override
    public Boolean getNotFoundOK() {
        return this.getProperties().getNotFoundOK();
    }

    @Override
    public NamedErlangFunction getChashKeyFunction() {
        return this.getProperties().getChashKeyFunction();
    }

    @Override
    public NamedErlangFunction getLinkWalkFunction() {
        return this.getProperties().getLinkWalkFunction();
    }

    @Override
    public Boolean getSearch() {
        return this.getProperties().getSearch();
    }

    @Override
    public boolean isSearchEnabled() {
        return this.getProperties().isSearchEnabled();
    }

    private BucketProperties getProperties() {
        this.future.run();
        try {
            return this.future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

