/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.bucket;

import com.basho.riak.client.RiakRetryFailedException;
import com.basho.riak.client.bucket.Bucket;
import com.basho.riak.client.bucket.BucketProperties;
import com.basho.riak.client.bucket.DefaultBucket;
import com.basho.riak.client.bucket.LazyBucketProperties;
import com.basho.riak.client.builders.BucketPropertiesBuilder;
import com.basho.riak.client.cap.Quora;
import com.basho.riak.client.cap.Retrier;
import com.basho.riak.client.operations.RiakOperation;
import com.basho.riak.client.query.functions.NamedErlangFunction;
import com.basho.riak.client.query.functions.NamedFunction;
import com.basho.riak.client.raw.RawClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteBucket
implements RiakOperation<Bucket> {
    private final RawClient client;
    private Retrier retrier;
    private String name;
    private Collection<NamedFunction> precommitHooks;
    private Collection<NamedErlangFunction> postcommitHooks;
    private BucketPropertiesBuilder builder = new BucketPropertiesBuilder();
    private boolean lazyLoadProperties = false;

    public WriteBucket(RawClient client, String name, Retrier retrier) {
        this.name = name;
        this.client = client;
        this.retrier = retrier;
    }

    public WriteBucket(RawClient client, Bucket bucket, Retrier retrier) {
        this.name = bucket.getName();
        this.client = client;
        this.retrier = retrier;
        this.precommitHooks = bucket.getPrecommitHooks();
        this.postcommitHooks = bucket.getPostcommitHooks();
        this.builder = BucketPropertiesBuilder.from(bucket);
    }

    @Override
    public Bucket execute() throws RiakRetryFailedException {
        final BucketProperties propsToStore = this.builder.precommitHooks(this.precommitHooks).postcommitHooks(this.postcommitHooks).build();
        this.retrier.attempt(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                WriteBucket.this.client.updateBucket(WriteBucket.this.name, propsToStore);
                return null;
            }
        });
        BucketProperties properties = !this.lazyLoadProperties ? this.retrier.attempt(new Callable<BucketProperties>(){

            @Override
            public BucketProperties call() throws Exception {
                return WriteBucket.this.client.fetchBucket(WriteBucket.this.name);
            }
        }) : new LazyBucketProperties(this.client, this.retrier, this.name);
        return new DefaultBucket(this.name, properties, this.client, this.retrier);
    }

    public WriteBucket allowSiblings(boolean allowSiblings) {
        this.builder.allowSiblings(allowSiblings);
        return this;
    }

    public WriteBucket lastWriteWins(boolean lastWriteWins) {
        this.builder.lastWriteWins(lastWriteWins);
        return this;
    }

    public WriteBucket nVal(int nVal) {
        this.builder.nVal(nVal);
        return this;
    }

    public WriteBucket backend(String backend) {
        this.builder.backend(backend);
        return this;
    }

    public WriteBucket precommitHooks(Collection<NamedFunction> precommitHooks) {
        this.builder.precommitHooks(precommitHooks);
        return this;
    }

    public WriteBucket addPrecommitHook(NamedFunction preCommitHook) {
        if (preCommitHook != null) {
            if (this.precommitHooks == null) {
                this.precommitHooks = new ArrayList<NamedFunction>();
            }
            this.precommitHooks.add(preCommitHook);
        }
        return this;
    }

    public WriteBucket postcommitHooks(Collection<NamedErlangFunction> postCommitHooks) {
        this.builder.postcommitHooks(postCommitHooks);
        return this;
    }

    public WriteBucket addPostcommitHook(NamedErlangFunction postcommitHook) {
        if (postcommitHook != null) {
            if (this.postcommitHooks == null) {
                this.postcommitHooks = new ArrayList<NamedErlangFunction>();
            }
            this.postcommitHooks.add(postcommitHook);
        }
        return this;
    }

    public WriteBucket chashKeyFunction(NamedErlangFunction chashKeyFunction) {
        this.builder.chashKeyFunction(chashKeyFunction);
        return this;
    }

    public WriteBucket linkWalkFunction(NamedErlangFunction linkWalkFunction) {
        this.builder.linkWalkFunction(linkWalkFunction);
        return this;
    }

    public WriteBucket smallVClock(int smallVClock) {
        this.builder.smallVClock(smallVClock);
        return this;
    }

    public WriteBucket bigVClock(int bigVClock) {
        this.builder.bigVClock(bigVClock);
        return this;
    }

    public WriteBucket youngVClock(long youngVClock) {
        this.builder.youngVClock(youngVClock);
        return this;
    }

    public WriteBucket oldVClock(long oldVClock) {
        this.builder.oldVClock(oldVClock);
        return this;
    }

    public WriteBucket r(Quora r) {
        this.builder.r(r);
        return this;
    }

    public WriteBucket r(int r) {
        this.builder.r(r);
        return this;
    }

    public WriteBucket w(Quora w) {
        this.builder.w(w);
        return this;
    }

    public WriteBucket w(int w) {
        this.builder.w(w);
        return this;
    }

    public WriteBucket rw(Quora rw) {
        this.builder.rw(rw);
        return this;
    }

    public WriteBucket rw(int rw) {
        this.builder.rw(rw);
        return this;
    }

    public WriteBucket dw(Quora dw) {
        this.builder.dw(dw);
        return this;
    }

    public WriteBucket dw(int dw) {
        this.builder.dw(dw);
        return this;
    }

    public WriteBucket pr(Quora pr) {
        this.builder.pr(pr);
        return this;
    }

    public WriteBucket pr(int pr) {
        this.builder.pr(pr);
        return this;
    }

    public WriteBucket pw(Quora pw) {
        this.builder.pw(pw);
        return this;
    }

    public WriteBucket pw(int pw) {
        this.builder.pw(pw);
        return this;
    }

    public WriteBucket basicQuorum(boolean basicQuorum) {
        this.builder.basicQuorum(basicQuorum);
        return this;
    }

    public WriteBucket notFoundOK(boolean notFoundOK) {
        this.builder.notFoundOK(notFoundOK);
        return this;
    }

    public WriteBucket withRetrier(Retrier retrier) {
        this.retrier = retrier;
        return this;
    }

    public WriteBucket enableForSearch() {
        this.addPrecommitHook(NamedErlangFunction.SEARCH_PRECOMMIT_HOOK);
        this.builder.search(true);
        return this;
    }

    public WriteBucket disableSearch() {
        if (this.precommitHooks != null) {
            this.precommitHooks.remove(NamedErlangFunction.SEARCH_PRECOMMIT_HOOK);
        }
        this.builder.search(false);
        return this;
    }

    public WriteBucket lazyLoadBucketProperties() {
        this.lazyLoadProperties = true;
        return this;
    }
}

