/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.builders;

import com.basho.riak.client.DefaultRiakObject;
import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.RiakLink;
import com.basho.riak.client.cap.BasicVClock;
import com.basho.riak.client.cap.VClock;
import com.basho.riak.client.query.indexes.RiakIndexes;
import com.basho.riak.client.util.CharsetUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiakObjectBuilder {
    private final String bucket;
    private final String key;
    private byte[] value;
    private VClock vclock;
    private String vtag;
    private Date lastModified;
    private Collection<RiakLink> links = new ArrayList<RiakLink>();
    private RiakIndexes indexes = new RiakIndexes();
    private Map<String, String> userMeta = new HashMap<String, String>();
    private String contentType;
    private boolean isDeleted = false;

    private RiakObjectBuilder(String bucket, String key) {
        this.bucket = bucket;
        this.key = key;
    }

    public static RiakObjectBuilder newBuilder(String bucket, String key) {
        return new RiakObjectBuilder(bucket, key);
    }

    public static RiakObjectBuilder from(IRiakObject o) {
        RiakObjectBuilder rob = new RiakObjectBuilder(o.getBucket(), o.getKey());
        rob.vclock = o.getVClock();
        rob.contentType = o.getContentType();
        rob.lastModified = o.getLastModified();
        rob.value = o.getValue();
        rob.links = o.getLinks();
        rob.indexes = new RiakIndexes(o.allBinIndexes(), o.allIntIndexesV2());
        rob.userMeta = o.getMeta();
        rob.isDeleted = o.isDeleted();
        return rob;
    }

    public IRiakObject build() {
        return new DefaultRiakObject(this.bucket, this.key, this.vclock, this.vtag, this.lastModified, this.contentType, this.value, this.links, this.userMeta, this.indexes, this.isDeleted);
    }

    public RiakObjectBuilder withValue(byte[] value) {
        this.value = value == null ? null : (byte[])value.clone();
        return this;
    }

    public RiakObjectBuilder withValue(String value) {
        this.value = CharsetUtils.utf8StringToBytes(value);
        this.contentType = CharsetUtils.addUtf8Charset(this.contentType);
        return this;
    }

    public RiakObjectBuilder withVClock(byte[] vclock) {
        this.vclock = new BasicVClock(vclock);
        return this;
    }

    public RiakObjectBuilder withVtag(String vtag) {
        this.vtag = vtag;
        return this;
    }

    public RiakObjectBuilder withLastModified(long lastModified) {
        this.lastModified = new Date(lastModified);
        return this;
    }

    public RiakObjectBuilder withLinks(Collection<RiakLink> links) {
        if (links != null) {
            this.links = new ArrayList<RiakLink>(links);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakObjectBuilder addLink(String bucket, String key, String tag) {
        Collection<RiakLink> collection = this.links;
        synchronized (collection) {
            this.links.add(new RiakLink(bucket, key, tag));
        }
        return this;
    }

    public RiakObjectBuilder withIndexes(RiakIndexes indexes) {
        this.indexes = RiakIndexes.from(indexes);
        return this;
    }

    public RiakObjectBuilder addIndex(String index, long value) {
        this.indexes.add(index, value);
        return this;
    }

    public RiakObjectBuilder addIndex(String index, String value) {
        this.indexes.add(index, value);
        return this;
    }

    public RiakObjectBuilder withUsermeta(Map<String, String> usermeta) {
        if (usermeta != null) {
            this.userMeta = new HashMap<String, String>(usermeta);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakObjectBuilder addUsermeta(String key, String value) {
        Map<String, String> map = this.userMeta;
        synchronized (map) {
            this.userMeta.put(key, value);
        }
        return this;
    }

    public RiakObjectBuilder withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public RiakObjectBuilder withVClock(VClock vclock) {
        this.vclock = vclock;
        return this;
    }

    public RiakObjectBuilder withDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
        return this;
    }
}

