/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.http;

import com.basho.riak.client.http.BinIndex;
import com.basho.riak.client.http.IntIndex;
import com.basho.riak.client.http.RiakClient;
import com.basho.riak.client.http.RiakIndex;
import com.basho.riak.client.http.RiakLink;
import com.basho.riak.client.http.request.RequestMeta;
import com.basho.riak.client.http.request.RiakWalkSpec;
import com.basho.riak.client.http.response.FetchResponse;
import com.basho.riak.client.http.response.HttpResponse;
import com.basho.riak.client.http.response.StoreResponse;
import com.basho.riak.client.http.response.WalkResponse;
import com.basho.riak.client.http.util.ClientUtils;
import com.basho.riak.client.util.CharsetUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiakObject {
    private static final byte[] EMPTY = new byte[0];
    private RiakClient riak;
    private String bucket;
    private String key;
    private boolean isDeleted;
    private byte[] value;
    private List<RiakLink> links;
    private final Object indexLock = new Object();
    private List<RiakIndex> indexes;
    private Map<String, String> userMetaData;
    private String contentType;
    private String vclock;
    private String lastmod;
    private String vtag;
    private InputStream valueStream;
    private Long valueStreamLength;

    public RiakObject(RiakClient riak, String bucket, String key, byte[] value, String contentType, List<RiakLink> links, Map<String, String> userMetaData, String vclock, String lastmod, String vtag, List<RiakIndex> indexes, boolean isDeleted) {
        this.riak = riak;
        this.bucket = bucket;
        this.key = key;
        this.vclock = vclock;
        this.lastmod = lastmod;
        this.vtag = vtag;
        this.isDeleted = isDeleted;
        this.safeSetValue(value);
        this.contentType = contentType == null ? "application/octet-stream" : contentType;
        this.safeSetLinks(links);
        this.safeSetUsermetaData(userMetaData);
        this.safeSetIndexes(indexes);
    }

    public RiakObject(RiakClient riak, String bucket, String key, byte[] value, String contentType, List<RiakLink> links, Map<String, String> userMetaData, String vclock, String lastmod, String vtag) {
        this(riak, bucket, key, value, contentType, links, userMetaData, vclock, lastmod, vtag, null, false);
    }

    public RiakObject(RiakClient riak, String bucket, String key) {
        this(riak, bucket, key, null, null, null, null, null, null, null);
    }

    public RiakObject(RiakClient riak, String bucket, String key, byte[] value) {
        this(riak, bucket, key, value, null, null, null, null, null, null);
    }

    public RiakObject(RiakClient riak, String bucket, String key, byte[] value, String contentType) {
        this(riak, bucket, key, value, contentType, null, null, null, null, null);
    }

    public RiakObject(RiakClient riak, String bucket, String key, byte[] value, String contentType, List<RiakLink> links) {
        this(riak, bucket, key, value, contentType, links, null, null, null, null);
    }

    public RiakObject(RiakClient riak, String bucket, String key, byte[] value, String contentType, List<RiakLink> links, Map<String, String> userMetaData) {
        this(riak, bucket, key, value, contentType, links, userMetaData, null, null, null);
    }

    public RiakObject(String bucket, String key) {
        this(null, bucket, key, null, null, null, null, null, null, null);
    }

    public RiakObject(String bucket, String key, byte[] value) {
        this(null, bucket, key, value, null, null, null, null, null, null);
    }

    public RiakObject(String bucket, String key, byte[] value, String contentType) {
        this(null, bucket, key, value, contentType, null, null, null, null, null);
    }

    public RiakObject(String bucket, String key, byte[] value, String contentType, List<RiakLink> links) {
        this(null, bucket, key, value, contentType, links, null, null, null, null);
    }

    public RiakObject(String bucket, String key, byte[] value, String contentType, List<RiakLink> links, Map<String, String> userMetaData) {
        this(null, bucket, key, value, contentType, links, userMetaData, null, null, null);
    }

    public RiakObject(String bucket, String key, byte[] value, String contentType, List<RiakLink> links, Map<String, String> userMetaData, String vclock, String lastmod, String vtag) {
        this(null, bucket, key, value, contentType, links, userMetaData, vclock, lastmod, vtag);
    }

    public RiakClient getRiakClient() {
        return this.riak;
    }

    public RiakObject setRiakClient(RiakClient client) {
        this.riak = client;
        return this;
    }

    public void copyData(RiakObject object) {
        if (object == null) {
            return;
        }
        this.value = (byte[])(object.value != null ? (byte[])object.value.clone() : null);
        this.valueStream = object.valueStream;
        this.valueStreamLength = object.valueStreamLength;
        this.setLinks(object.links);
        this.userMetaData = new HashMap<String, String>();
        if (object.userMetaData != null) {
            this.userMetaData.putAll(object.userMetaData);
        }
        this.contentType = object.contentType;
        this.vclock = object.vclock;
        this.lastmod = object.lastmod;
        this.vtag = object.vtag;
        this.isDeleted = object.isDeleted;
    }

    void shallowCopy(RiakObject object) {
        this.value = object.value;
        this.links = object.links;
        this.userMetaData = object.userMetaData;
        this.contentType = object.contentType;
        this.vclock = object.vclock;
        this.lastmod = object.lastmod;
        this.vtag = object.vtag;
        this.valueStream = object.valueStream;
        this.valueStreamLength = object.valueStreamLength;
        this.isDeleted = object.isDeleted;
    }

    public void updateMeta(StoreResponse response) {
        if (response == null) {
            this.vclock = null;
            this.lastmod = null;
            this.vtag = null;
        } else {
            this.vclock = response.getVclock();
            this.lastmod = response.getLastmod();
            this.vtag = response.getVtag();
        }
    }

    public void updateMeta(FetchResponse response) {
        if (response == null || response.getObject() == null) {
            this.vclock = null;
            this.lastmod = null;
            this.vtag = null;
        } else {
            this.vclock = response.getObject().getVclock();
            this.lastmod = response.getObject().getLastmod();
            this.vtag = response.getObject().getVtag();
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value == null ? null : CharsetUtils.asString(this.value, CharsetUtils.getCharset(this.contentType));
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public byte[] getValueAsBytes() {
        return this.value == null ? this.value : (byte[])this.value.clone();
    }

    public void setValue(String value) {
        this.value = (byte[])(value != null ? CharsetUtils.asBytes(value, CharsetUtils.getCharset(this.contentType)) : null);
    }

    public void setValue(byte[] value) {
        this.safeSetValue(value);
    }

    private void safeSetValue(byte[] value) {
        this.value = (byte[])(value != null ? (byte[])value.clone() : null);
    }

    public void setValueStream(InputStream in, Long len) {
        this.valueStream = in;
        this.valueStreamLength = len;
    }

    public void setValueStream(InputStream in) {
        this.valueStream = in;
    }

    public InputStream getValueStream() {
        return this.valueStream;
    }

    public void setValueStreamLength(Long len) {
        this.valueStreamLength = len;
    }

    public Long getValueStreamLength() {
        return this.valueStreamLength;
    }

    @Deprecated
    public List<RiakLink> getLinks() {
        return this.links;
    }

    public void setLinks(List<RiakLink> links) {
        this.safeSetLinks(links);
    }

    private void safeSetLinks(List<RiakLink> links) {
        this.links = links == null ? new CopyOnWriteArrayList<RiakLink>() : new CopyOnWriteArrayList<RiakLink>(this.deepCopy(links));
    }

    private void safeSetIndexes(List<RiakIndex> indexes) {
        this.indexes = indexes == null ? new ArrayList<RiakIndex>() : new ArrayList<RiakIndex>(indexes);
    }

    private List<RiakLink> deepCopy(List<RiakLink> links) {
        ArrayList<RiakLink> copyLinks = new ArrayList<RiakLink>();
        for (RiakLink link : links) {
            copyLinks.add(new RiakLink(link));
        }
        return copyLinks;
    }

    public RiakObject addLink(RiakLink link) {
        if (link != null) {
            this.links.add(link);
        }
        return this;
    }

    public RiakObject removeLink(RiakLink link) {
        this.links.remove(link);
        return this;
    }

    public boolean hasLinks() {
        return !this.links.isEmpty();
    }

    public int numLinks() {
        return this.links.size();
    }

    public boolean hasLink(RiakLink riakLink) {
        return this.links.contains(riakLink);
    }

    @Deprecated
    public Map<String, String> getUsermeta() {
        return this.userMetaData;
    }

    public void setUsermeta(Map<String, String> userMetaData) {
        this.safeSetUsermetaData(userMetaData);
    }

    private void safeSetUsermetaData(Map<String, String> userMetaData) {
        this.userMetaData = userMetaData == null ? new ConcurrentHashMap<String, String>() : new ConcurrentHashMap<String, String>(userMetaData);
    }

    public RiakObject addUsermetaItem(String key, String value) {
        this.userMetaData.put(key, value);
        return this;
    }

    public boolean hasUsermeta() {
        return !this.userMetaData.isEmpty();
    }

    public int numUsermetaItems() {
        return this.userMetaData.size();
    }

    public boolean hasUsermetaItem(String key) {
        return this.userMetaData.containsKey(key);
    }

    public String getUsermetaItem(String key) {
        return this.userMetaData.get(key);
    }

    public void removeUsermetaItem(String key) {
        this.userMetaData.remove(key);
    }

    public Iterable<String> usermetaKeys() {
        return this.userMetaData.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RiakIndex> getIndexes() {
        Object object = this.indexLock;
        synchronized (object) {
            return new ArrayList<RiakIndex>(this.indexes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakObject addIndex(String name, String value) {
        Object object = this.indexLock;
        synchronized (object) {
            this.indexes.add(new BinIndex(name, value));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakObject addIndex(String name, long value) {
        Object object = this.indexLock;
        synchronized (object) {
            this.indexes.add(new IntIndex(name, value));
        }
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType != null ? contentType : "application/octet-stream";
    }

    public String getVclock() {
        return this.vclock;
    }

    public String getLastmod() {
        return this.lastmod;
    }

    public Date getLastmodAsDate() {
        return ClientUtils.parseDate(this.lastmod);
    }

    public String getVtag() {
        return this.vtag;
    }

    public StoreResponse store(RequestMeta meta) {
        return this.store(this.riak, meta);
    }

    public StoreResponse store() {
        return this.store(this.riak, null);
    }

    public StoreResponse store(RiakClient riak, RequestMeta meta) {
        if (riak == null) {
            throw new IllegalStateException("Cannot store an object without a RiakClient");
        }
        StoreResponse r = riak.store(this, meta);
        if (r.isSuccess()) {
            this.updateMeta(r);
        }
        return r;
    }

    public FetchResponse fetch(RequestMeta meta) {
        if (this.riak == null) {
            throw new IllegalStateException("Cannot fetch an object without a RiakClient");
        }
        FetchResponse r = this.riak.fetch(this.bucket, this.key, meta);
        if (r.getObject() != null) {
            RiakObject other = r.getObject();
            this.shallowCopy(other);
            r.setObject(this);
        }
        return r;
    }

    public FetchResponse fetch() {
        return this.fetch(null);
    }

    public FetchResponse fetchMeta(RequestMeta meta) {
        if (this.riak == null) {
            throw new IllegalStateException("Cannot fetch meta for an object without a RiakClient");
        }
        FetchResponse r = this.riak.fetchMeta(this.bucket, this.key, meta);
        if (r.isSuccess()) {
            this.updateMeta(r);
        }
        return r;
    }

    public FetchResponse fetchMeta() {
        return this.fetchMeta(null);
    }

    public HttpResponse delete(RequestMeta meta) {
        if (this.riak == null) {
            throw new IllegalStateException("Cannot delete an object without a RiakClient");
        }
        return this.riak.delete(this.bucket, this.key, meta);
    }

    public HttpResponse delete() {
        return this.delete(null);
    }

    public LinkBuilder walk(String bucket, String tag, boolean keep) {
        return new LinkBuilder().walk(bucket, tag, keep);
    }

    public LinkBuilder walk(String bucket, String tag) {
        return new LinkBuilder().walk(bucket, tag);
    }

    public LinkBuilder walk(String bucket, boolean keep) {
        return new LinkBuilder().walk(bucket, keep);
    }

    public LinkBuilder walk(String bucket) {
        return new LinkBuilder().walk(bucket);
    }

    public LinkBuilder walk() {
        return new LinkBuilder().walk();
    }

    public LinkBuilder walk(boolean keep) {
        return new LinkBuilder().walk(keep);
    }

    public void writeToHttpMethod(HttpRequestBase httpMethod) {
        String basePath = this.getBasePathFromHttpMethod(httpMethod);
        this.writeLinks(httpMethod, basePath);
        for (String name : this.userMetaData.keySet()) {
            httpMethod.addHeader("X-Riak-Meta-" + name, this.userMetaData.get(name));
        }
        this.writeIndexes(httpMethod);
        if (this.vclock != null) {
            httpMethod.addHeader("x-riak-vclock", this.vclock);
        }
        if (httpMethod instanceof HttpEntityEnclosingRequestBase) {
            HttpEntityEnclosingRequestBase entityEnclosingMethod = (HttpEntityEnclosingRequestBase)httpMethod;
            Object entity = null;
            entity = this.valueStream != null ? (this.valueStreamLength != null && this.valueStreamLength >= 0L ? new InputStreamEntity(this.valueStream, this.valueStreamLength.longValue()) : new ByteArrayEntity(ClientUtils.bufferStream(this.valueStream))) : (this.value != null ? new ByteArrayEntity(this.value) : new ByteArrayEntity(EMPTY));
            entity.setContentType(this.contentType);
            entityEnclosingMethod.setEntity((HttpEntity)entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndexes(HttpRequestBase httpMethod) {
        Object object = this.indexLock;
        synchronized (object) {
            for (RiakIndex i : this.indexes) {
                String index = i.getName();
                httpMethod.addHeader("X-Riak-Index-" + index, i.getValue().toString());
            }
        }
    }

    private void writeLinks(HttpRequestBase httpMethod, String basePath) {
        StringBuilder linkHeader = new StringBuilder();
        for (RiakLink link : this.links) {
            if (linkHeader.length() > 0) {
                linkHeader.append(", ");
            }
            linkHeader.append("<");
            linkHeader.append(basePath);
            linkHeader.append("/");
            linkHeader.append(link.getBucket());
            linkHeader.append("/");
            linkHeader.append(link.getKey());
            linkHeader.append(">; ");
            linkHeader.append("riaktag");
            linkHeader.append("=\"");
            linkHeader.append(link.getTag());
            linkHeader.append("\"");
            if (linkHeader.length() <= 2000) continue;
            httpMethod.addHeader("link", linkHeader.toString());
            linkHeader = new StringBuilder();
        }
        if (linkHeader.length() > 0) {
            httpMethod.addHeader("link", linkHeader.toString());
        }
    }

    String getBasePathFromHttpMethod(HttpRequestBase httpMethod) {
        if (httpMethod == null || httpMethod.getURI() == null) {
            return "";
        }
        String path = httpMethod.getURI().getRawPath();
        int idx = path.length() - 1;
        if (path.endsWith("/")) {
            --idx;
        }
        idx = path.lastIndexOf(47, idx);
        if ((idx = path.lastIndexOf(47, idx - 1)) <= 0) {
            return "";
        }
        return path.substring(0, idx);
    }

    public Iterable<RiakLink> iterableLinks() {
        return new Iterable<RiakLink>(){

            @Override
            public Iterator<RiakLink> iterator() {
                return RiakObject.this.links.iterator();
            }
        };
    }

    public class LinkBuilder {
        private RiakWalkSpec walkSpec = new RiakWalkSpec();

        public LinkBuilder walk() {
            this.walkSpec.addStep("_", "_");
            return this;
        }

        public LinkBuilder walk(boolean keep) {
            this.walkSpec.addStep("_", "_", keep);
            return this;
        }

        public LinkBuilder walk(String bucket) {
            this.walkSpec.addStep(bucket, "_");
            return this;
        }

        public LinkBuilder walk(String bucket, boolean keep) {
            this.walkSpec.addStep(bucket, "_", keep);
            return this;
        }

        public LinkBuilder walk(String bucket, String tag) {
            this.walkSpec.addStep(bucket, tag);
            return this;
        }

        public LinkBuilder walk(String bucket, String tag, boolean keep) {
            this.walkSpec.addStep(bucket, tag, keep);
            return this;
        }

        public String getWalkSpec() {
            return this.walkSpec.toString();
        }

        public WalkResponse run(RequestMeta meta) {
            if (RiakObject.this.riak == null) {
                throw new IllegalStateException("Cannot perform object link walk without a RiakClient");
            }
            return RiakObject.this.riak.walk(RiakObject.this.bucket, RiakObject.this.key, this.getWalkSpec(), meta);
        }

        public WalkResponse run() {
            return this.run(null);
        }
    }
}

