/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.http.plain;

import com.basho.riak.client.http.RiakBucketInfo;
import com.basho.riak.client.http.RiakClient;
import com.basho.riak.client.http.RiakConfig;
import com.basho.riak.client.http.RiakObject;
import com.basho.riak.client.http.plain.ConvertToCheckedExceptions;
import com.basho.riak.client.http.plain.RiakIOException;
import com.basho.riak.client.http.plain.RiakResponseException;
import com.basho.riak.client.http.request.RequestMeta;
import com.basho.riak.client.http.request.RiakWalkSpec;
import com.basho.riak.client.http.response.BucketResponse;
import com.basho.riak.client.http.response.FetchResponse;
import com.basho.riak.client.http.response.HttpResponse;
import com.basho.riak.client.http.response.RiakResponseRuntimeException;
import com.basho.riak.client.http.response.StoreResponse;
import com.basho.riak.client.http.response.StreamHandler;
import com.basho.riak.client.http.response.WalkResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainClient {
    private RiakClient impl;

    public static PlainClient getClient(RiakConfig config) {
        return new PlainClient(new RiakClient(config));
    }

    public static PlainClient getClient(String url) {
        return new PlainClient(new RiakClient(url));
    }

    public PlainClient(RiakClient riakClient) {
        this.impl = riakClient;
        this.impl.setExceptionHandler(new ConvertToCheckedExceptions());
    }

    public void setBucketSchema(String bucket, RiakBucketInfo bucketInfo, RequestMeta meta) throws RiakIOException, RiakResponseException {
        HttpResponse r = this.impl.setBucketSchema(bucket, bucketInfo, meta);
        if (r.getStatusCode() != 204) {
            throw new RiakResponseException(new RiakResponseRuntimeException(r, r.getBodyAsString()));
        }
    }

    public void setBucketSchema(String bucket, RiakBucketInfo bucketInfo) throws RiakIOException, RiakResponseException {
        this.setBucketSchema(bucket, bucketInfo, null);
    }

    public RiakBucketInfo listBucket(String bucket, RequestMeta meta) throws RiakIOException, RiakResponseException {
        BucketResponse r = this.impl.listBucket(bucket, meta);
        if (r.getStatusCode() != 200) {
            throw new RiakResponseException(new RiakResponseRuntimeException((HttpResponse)r, r.getBodyAsString()));
        }
        return r.getBucketInfo();
    }

    public RiakBucketInfo listBucket(String bucket) throws RiakIOException, RiakResponseException {
        return this.listBucket(bucket, null);
    }

    public void store(RiakObject object, RequestMeta meta) throws RiakIOException, RiakResponseException {
        StoreResponse r = this.impl.store(object, meta);
        if (r.getStatusCode() != 200 && r.getStatusCode() != 204) {
            throw new RiakResponseException(new RiakResponseRuntimeException((HttpResponse)r, r.getBodyAsString()));
        }
        object.updateMeta(r);
    }

    public void store(RiakObject object) throws RiakIOException, RiakResponseException {
        this.store(object, null);
    }

    public RiakObject fetchMeta(String bucket, String key, RequestMeta meta) throws RiakIOException, RiakResponseException {
        FetchResponse r = this.impl.fetchMeta(bucket, key, meta);
        if (r.getStatusCode() == 404) {
            return null;
        }
        if (r.getStatusCode() != 200 && r.getStatusCode() != 304) {
            throw new RiakResponseException(new RiakResponseRuntimeException((HttpResponse)r, r.getBodyAsString()));
        }
        if (r.getStatusCode() == 200 && !r.hasObject()) {
            throw new RiakResponseException(new RiakResponseRuntimeException((HttpResponse)r, "Failed to parse metadata"));
        }
        return r.getObject();
    }

    public RiakObject fetchMeta(String bucket, String key) throws RiakIOException, RiakResponseException {
        return this.fetchMeta(bucket, key, null);
    }

    public RiakObject fetch(String bucket, String key, RequestMeta meta) throws RiakIOException, RiakResponseException {
        FetchResponse r = this.impl.fetch(bucket, key, meta);
        if (r.getStatusCode() == 404) {
            return null;
        }
        if (r.getStatusCode() != 200 && r.getStatusCode() != 304) {
            throw new RiakResponseException(new RiakResponseRuntimeException((HttpResponse)r, r.getBodyAsString()));
        }
        if (r.getStatusCode() == 200 && !r.hasObject()) {
            throw new RiakResponseException(new RiakResponseRuntimeException((HttpResponse)r, "Failed to parse object"));
        }
        return r.getObject();
    }

    public RiakObject fetch(String bucket, String key) throws RiakIOException, RiakResponseException {
        return this.fetch(bucket, key, null);
    }

    public Collection<? extends RiakObject> fetchAll(String bucket, String key, RequestMeta meta) throws RiakIOException, RiakResponseException {
        FetchResponse r = this.impl.fetch(bucket, key, meta);
        if (r.getStatusCode() == 404) {
            return null;
        }
        if (r.getStatusCode() != 200 && r.getStatusCode() != 304) {
            throw new RiakResponseException(new RiakResponseRuntimeException((HttpResponse)r, r.getBodyAsString()));
        }
        if (r.getStatusCode() == 200 && !r.hasObject() && !r.hasSiblings()) {
            throw new RiakResponseException(new RiakResponseRuntimeException((HttpResponse)r, "Failed to parse object"));
        }
        if (r.hasSiblings()) {
            return r.getSiblings();
        }
        return Arrays.asList(r.getObject());
    }

    public Collection<? extends RiakObject> fetchAll(String bucket, String key) throws RiakIOException, RiakResponseException {
        return this.fetchAll(bucket, key, null);
    }

    public boolean stream(String bucket, String key, StreamHandler handler, RequestMeta meta) throws IOException {
        return this.impl.stream(bucket, key, handler, meta);
    }

    public void delete(String bucket, String key, RequestMeta meta) throws RiakIOException, RiakResponseException {
        HttpResponse r = this.impl.delete(bucket, key, meta);
        if (r.getStatusCode() != 204 && r.getStatusCode() != 404) {
            throw new RiakResponseException(new RiakResponseRuntimeException(r, r.getBodyAsString()));
        }
    }

    public void delete(String bucket, String key) throws RiakIOException, RiakResponseException {
        this.delete(bucket, key, null);
    }

    public List<? extends List<? extends RiakObject>> walk(String bucket, String key, String walkSpec, RequestMeta meta) throws RiakIOException, RiakResponseException {
        WalkResponse r = this.impl.walk(bucket, key, walkSpec, meta);
        if (r.getStatusCode() == 404) {
            return null;
        }
        if (r.getStatusCode() != 200) {
            throw new RiakResponseException(new RiakResponseRuntimeException((HttpResponse)r, r.getBodyAsString()));
        }
        if (!r.hasSteps()) {
            throw new RiakResponseException(new RiakResponseRuntimeException((HttpResponse)r, "Failed to parse walk results"));
        }
        return r.getSteps();
    }

    public List<? extends List<? extends RiakObject>> walk(String bucket, String key, String walkSpec) throws RiakIOException, RiakResponseException {
        return this.walk(bucket, key, walkSpec, null);
    }

    public List<? extends List<? extends RiakObject>> walk(String bucket, String key, RiakWalkSpec walkSpec) throws RiakIOException, RiakResponseException {
        return this.walk(bucket, key, walkSpec.toString(), null);
    }
}

