/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.http.response;

import com.basho.riak.client.http.RiakClient;
import com.basho.riak.client.http.RiakIndex;
import com.basho.riak.client.http.RiakLink;
import com.basho.riak.client.http.RiakObject;
import com.basho.riak.client.http.response.RiakIORuntimeException;
import com.basho.riak.client.http.util.ClientUtils;
import com.basho.riak.client.http.util.CollectionWrapper;
import com.basho.riak.client.http.util.Multipart;
import com.basho.riak.client.http.util.StreamedMultipart;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamedSiblingsCollection
extends CollectionWrapper<RiakObject> {
    String bucket;
    String key;
    RiakClient riak;
    StreamedMultipart multipart;

    public StreamedSiblingsCollection(RiakClient riak, String bucket, String key, StreamedMultipart multipart) {
        this.bucket = bucket;
        this.key = key;
        this.riak = riak;
        this.multipart = multipart;
    }

    @Override
    protected boolean cacheNext() {
        Multipart.Part part;
        if (this.multipart == null) {
            return false;
        }
        String vclock = null;
        if (this.multipart.getHeaders() != null) {
            vclock = this.multipart.getHeaders().get("x-riak-vclock");
        }
        try {
            part = this.multipart.next();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw new RiakIORuntimeException(e);
            }
            throw e;
        }
        if (part != null) {
            String[] locationParts;
            Map<String, String> headers = part.getHeaders();
            List<RiakLink> links = ClientUtils.parseLinkHeader(headers.get("link"));
            List<RiakIndex> indexes = ClientUtils.parseIndexHeaders(headers);
            Map<String, String> usermeta = ClientUtils.parseUsermeta(headers);
            String location = headers.get("location");
            String partBucket = this.bucket;
            String partKey = this.key;
            if (location != null && (locationParts = location.split("/")).length >= 2) {
                partBucket = locationParts[locationParts.length - 2];
                partKey = locationParts[locationParts.length - 1];
            }
            RiakObject o = new RiakObject(this.riak, partBucket, partKey, null, headers.get("content-type"), links, usermeta, vclock, headers.get("last-modified"), headers.get("etag"), indexes, headers.get("x-riak-deleted") != null);
            o.setValueStream(part.getStream());
            this.cache(o);
            return true;
        }
        return false;
    }

    @Override
    protected void closeBackend() {
        this.riak = null;
        this.multipart = null;
    }
}

