/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.http.response;

import com.basho.riak.client.http.RiakClient;
import com.basho.riak.client.http.RiakObject;
import com.basho.riak.client.http.response.HttpResponse;
import com.basho.riak.client.http.response.HttpResponseDecorator;
import com.basho.riak.client.http.response.RiakResponseRuntimeException;
import com.basho.riak.client.http.util.ClientUtils;
import com.basho.riak.client.http.util.Multipart;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WalkResponse
extends HttpResponseDecorator
implements HttpResponse {
    private List<? extends List<RiakObject>> steps = new ArrayList<List<RiakObject>>();

    public WalkResponse(HttpResponse r, RiakClient riak) throws RiakResponseRuntimeException {
        super(r);
        if (r != null && r.isSuccess()) {
            this.steps = WalkResponse.parseSteps(r, riak);
        }
    }

    public WalkResponse(HttpResponse r) throws RiakResponseRuntimeException {
        this(r, null);
    }

    public boolean hasSteps() {
        return this.steps.size() > 0;
    }

    public List<? extends List<RiakObject>> getSteps() {
        return this.steps;
    }

    private static List<? extends List<RiakObject>> parseSteps(HttpResponse r, RiakClient riak) throws RiakResponseRuntimeException {
        String bucket = r.getBucket();
        String key = r.getKey();
        ArrayList<List<RiakObject>> parsedSteps = new ArrayList<List<RiakObject>>();
        List<Multipart.Part> parts = Multipart.parse(r.getHttpHeaders(), r.getBody());
        if (parts != null) {
            for (Multipart.Part part : parts) {
                Map<String, String> partHeaders = part.getHeaders();
                String contentType = partHeaders.get("content-type");
                if (contentType == null || !contentType.trim().toLowerCase().startsWith("multipart/mixed")) {
                    throw new RiakResponseRuntimeException(r, "multipart/mixed subparts expected in link walk results");
                }
                parsedSteps.add(ClientUtils.parseMultipart(riak, bucket, key, partHeaders, part.getBody()));
            }
        }
        return parsedSteps;
    }
}

