/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.http.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionWrapper<T>
implements Collection<T> {
    List<T> cache = new ArrayList<T>();

    protected abstract boolean cacheNext();

    protected abstract void closeBackend();

    protected void cache(T object) {
        this.cache.add(object);
    }

    @Override
    public boolean add(T e) {
        return this.cache.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.cache.addAll(c);
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.closeBackend();
    }

    @Override
    public boolean contains(Object o) {
        if (this.cache.contains(o)) {
            return true;
        }
        this.cacheAll();
        return this.cache.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.cache.containsAll(c)) {
            return true;
        }
        this.cacheAll();
        return this.cache.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        this.cacheAll();
        return this.cache.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new WrappedCollectionIterator();
    }

    @Override
    public boolean remove(Object o) {
        if (this.contains(o)) {
            return this.cache.remove(o);
        }
        this.cacheAll();
        return this.cache.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.cacheAll();
        return this.cache.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.cacheAll();
        return this.cache.retainAll(c);
    }

    @Override
    public int size() {
        this.cacheAll();
        return this.cache.size();
    }

    @Override
    public Object[] toArray() {
        this.cacheAll();
        return this.cache.toArray();
    }

    @Override
    public <A> A[] toArray(A[] a) {
        this.cacheAll();
        return this.cache.toArray(a);
    }

    List<T> getCache() {
        return this.cache;
    }

    void cacheAll() {
        while (this.cacheNext()) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WrappedCollectionIterator
    implements Iterator<T> {
        int index = 0;
        boolean removed = false;

        WrappedCollectionIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.index < CollectionWrapper.this.cache.size()) {
                return true;
            }
            return CollectionWrapper.this.cacheNext();
        }

        @Override
        public T next() {
            this.removed = false;
            while (this.index >= CollectionWrapper.this.cache.size() && CollectionWrapper.this.cacheNext()) {
            }
            if (this.index < CollectionWrapper.this.cache.size()) {
                return CollectionWrapper.this.cache.get(this.index++);
            }
            return null;
        }

        @Override
        public void remove() {
            if (!this.removed && this.index > 0 && this.index <= CollectionWrapper.this.cache.size()) {
                --this.index;
                CollectionWrapper.this.cache.remove(this.index);
                this.removed = true;
            }
        }
    }
}

