/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.http.util;

import com.basho.riak.client.http.util.ClientUtils;
import com.basho.riak.client.util.CharsetUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.util.EncodingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multipart {
    private static byte[] HEADER_DELIM = CharsetUtils.utf8StringToBytes("\r\n\r\n");

    private static int indexOf(byte[] text, byte[] pattern, int fromIndex) {
        if (fromIndex >= text.length || fromIndex < 0) {
            throw new IllegalArgumentException("index not within range");
        }
        if (pattern.length == 0) {
            throw new IllegalArgumentException("pattern must not be empty");
        }
        byte first = pattern[0];
        int max = text.length - pattern.length;
        for (int i = fromIndex; i <= max; ++i) {
            if (text[i] != first) {
                while (i <= max && text[i] != first) {
                    ++i;
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + pattern.length - 1;
            int k = 1;
            while (j < end && text[j] == pattern[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static List<Part> parse(Map<String, String> headers, byte[] body) {
        if (headers == null || body == null || body.length == 0) {
            return null;
        }
        if (body.length < 2 || body[0] != 13 || body[1] != 10) {
            byte[] newBody = new byte[body.length + 2];
            newBody[0] = 13;
            newBody[1] = 10;
            System.arraycopy(body, 0, newBody, 2, body.length);
            body = newBody;
        }
        String boundary = "\r\n--" + Multipart.getBoundary(headers.get("content-type"));
        byte[] boundaryBytes = CharsetUtils.asBytes(boundary, CharsetUtils.ISO_8859_1);
        int boundarySize = boundary.length();
        if ("\r\n--".equals(boundary)) {
            return null;
        }
        ArrayList<Part> parts = new ArrayList<Part>();
        int pos = Multipart.indexOf(body, boundaryBytes, 0);
        if (pos != -1) {
            while (pos < body.length) {
                int start = pos + boundarySize;
                int end = Multipart.indexOf(body, boundaryBytes, start);
                int headerEnd = Multipart.indexOf(body, HEADER_DELIM, pos);
                int bodyStart = headerEnd + HEADER_DELIM.length;
                if (body.length >= start + 2 && body[start] == 45 && body[start + 1] == 45) break;
                if (end == -1) {
                    end = body.length;
                }
                if (headerEnd == -1) {
                    headerEnd = body.length;
                    bodyStart = end;
                }
                if (bodyStart > end) {
                    bodyStart = end;
                }
                Map<String, String> partHeaders = Multipart.parseHeaders(EncodingUtils.getAsciiString((byte[])Multipart.copyOfRange(body, start, headerEnd)));
                parts.add(new Part(partHeaders, Multipart.copyOfRange(body, bodyStart, end)));
                pos = end;
            }
        }
        return parts;
    }

    private static byte[] copyOfRange(byte[] original, int start, int end) {
        byte[] copy = new byte[end - start];
        System.arraycopy(original, start, copy, 0, end - start);
        return copy;
    }

    public static Map<String, String> parseHeaders(String s) {
        s.replaceAll("\r\n\\s+", " ");
        String[] headers = s.split("\r\n");
        HashMap<String, String> parsedHeaders = new HashMap<String, String>();
        for (String header : headers) {
            String[] nv = header.split("\\s*:\\s*", 2);
            if (nv.length <= 1) continue;
            parsedHeaders.put(nv[0].trim().toLowerCase(), nv[1].trim());
        }
        return parsedHeaders;
    }

    public static String getBoundary(String contentType) {
        String[] params;
        for (String param : params = contentType.split("\\s*;\\s*")) {
            String[] nv = param.split("\\s*=\\s*", 2);
            if (nv.length <= 1 || !"boundary".equals(nv[0].toLowerCase())) continue;
            return ClientUtils.unquoteString(nv[1]);
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Part {
        private Map<String, String> headers;
        private byte[] body = null;
        private InputStream stream;

        public Part(Map<String, String> headers, byte[] body) {
            this.headers = headers;
            if (body != null) {
                this.body = (byte[])body.clone();
            }
        }

        public Part(Map<String, String> headers, InputStream body) {
            this.headers = headers;
            this.stream = body;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public byte[] getBody() {
            if (this.body == null && this.stream != null) {
                try {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    int readCount = 0;
                    while (readCount != -1) {
                        os.write(buffer, 0, readCount);
                        readCount = this.stream.read(buffer);
                    }
                    this.body = os.toByteArray();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.stream = null;
            }
            return this.body;
        }

        public String getBodyAsString() {
            byte[] body = this.getBody();
            if (body == null) {
                return null;
            }
            return CharsetUtils.asString(body, CharsetUtils.getCharset(this.headers));
        }

        public InputStream getStream() {
            if (this.stream == null && this.body != null) {
                this.stream = new ByteArrayInputStream(this.body);
            }
            return this.stream;
        }
    }
}

