/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.query.indexes;

import com.basho.riak.client.IndexEntry;
import com.basho.riak.client.RiakException;
import com.basho.riak.client.cap.Retrier;
import com.basho.riak.client.operations.RiakOperation;
import com.basho.riak.client.query.StreamingOperation;
import com.basho.riak.client.query.indexes.BinIndex;
import com.basho.riak.client.query.indexes.IntIndex;
import com.basho.riak.client.query.indexes.RiakIndex;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.query.IndexSpec;
import com.basho.riak.client.raw.query.indexes.BinRangeQuery;
import com.basho.riak.client.raw.query.indexes.BinValueQuery;
import com.basho.riak.client.raw.query.indexes.IndexQuery;
import com.basho.riak.client.raw.query.indexes.IntRangeQuery;
import com.basho.riak.client.raw.query.indexes.IntValueQuery;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchIndex<T>
implements RiakOperation<List<String>> {
    private final RawClient client;
    protected final RiakIndex<T> index;
    private final String bucket;
    protected T value;
    protected T from;
    protected T to;
    protected boolean returnTerms;
    protected Integer maxResults;
    protected String continuation;
    private Retrier retrier;

    public FetchIndex(RawClient client, String bucket, RiakIndex<T> index, Retrier retrier) {
        this.client = client;
        this.bucket = bucket;
        this.index = index;
        this.retrier = retrier;
    }

    @Override
    public List<String> execute() throws RiakException {
        if (this.value == null && (this.to == null || this.from == null)) {
            throw new IllegalStateException("Must set either value or range");
        }
        final IndexQuery indexQuery = this.makeIndexQuery();
        List<String> keys = this.retrier.attempt(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return FetchIndex.this.client.fetchIndex(indexQuery);
            }
        });
        return keys;
    }

    public StreamingOperation<IndexEntry> executeStreaming() throws RiakException {
        if (this.value == null && (this.to == null || this.from == null)) {
            throw new IllegalStateException("Must set either value or range");
        }
        IndexSpec.Builder builder = this.makeIndexSpecBuilder();
        builder.withMaxResults(this.maxResults).withReturnKeyAndIndex(this.returnTerms).withContinuation(this.continuation);
        try {
            return this.client.fetchIndex(builder.build());
        }
        catch (IOException ex) {
            throw new RiakException(ex);
        }
    }

    private IndexSpec.Builder makeIndexSpecBuilder() {
        if (this.isRange()) {
            return this.makeRangeSpecBuilder();
        }
        return this.makeValueSpecBuilder();
    }

    private IndexSpec.Builder makeRangeSpecBuilder() {
        if (this.to.getClass().equals(String.class)) {
            return new IndexSpec.Builder(this.bucket, this.index.getFullname()).withRangeStart((String)this.from).withRangeEnd((String)this.to);
        }
        if (Number.class.isAssignableFrom(this.to.getClass())) {
            return new IndexSpec.Builder(this.bucket, this.index.getFullname()).withRangeStart(((Number)this.from).longValue()).withRangeEnd(((Number)this.to).longValue());
        }
        return null;
    }

    private IndexSpec.Builder makeValueSpecBuilder() {
        if (this.value.getClass().equals(String.class)) {
            return new IndexSpec.Builder(this.bucket, this.index.getFullname()).withIndexKey((String)this.value);
        }
        if (Number.class.isAssignableFrom(this.value.getClass())) {
            return new IndexSpec.Builder(this.bucket, this.index.getFullname()).withIndexKey(((Number)this.value).longValue());
        }
        return null;
    }

    private IndexQuery makeIndexQuery() {
        if (this.isRange()) {
            return this.makeRangeQuery();
        }
        return this.makeValueQuery();
    }

    private boolean isRange() {
        return this.to != null && this.from != null;
    }

    private IndexQuery makeValueQuery() {
        if (this.value.getClass().equals(String.class)) {
            return new BinValueQuery((BinIndex)this.index, this.bucket, (String)this.value);
        }
        if (Number.class.isAssignableFrom(this.value.getClass())) {
            return new IntValueQuery((IntIndex)this.index, this.bucket, ((Number)this.value).longValue());
        }
        return null;
    }

    private IndexQuery makeRangeQuery() {
        if (this.to.getClass().equals(String.class)) {
            return new BinRangeQuery((BinIndex)this.index, this.bucket, (String)this.from, (String)this.to);
        }
        if (Number.class.isAssignableFrom(this.to.getClass())) {
            return new IntRangeQuery((IntIndex)this.index, this.bucket, ((Number)this.from).longValue(), ((Number)this.to).longValue());
        }
        throw new RuntimeException("Unkown range query type " + this.to.getClass());
    }

    public FetchIndex<T> withValue(T value) {
        this.value = value;
        return this;
    }

    public FetchIndex<T> from(T from) {
        this.from = from;
        return this;
    }

    public FetchIndex<T> to(T to) {
        this.to = to;
        return this;
    }

    public FetchIndex<T> maxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public FetchIndex<T> returnKeyAndIndexValue(boolean returnBoth) {
        this.returnTerms = returnBoth;
        return this;
    }

    public FetchIndex<T> withContinuation(String continuation) {
        this.continuation = continuation;
        return this;
    }
}

