/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw.http;

import com.basho.riak.client.http.RiakClient;
import com.basho.riak.client.http.RiakConfig;
import com.basho.riak.client.raw.ClusterClient;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.Transport;
import com.basho.riak.client.raw.config.ClusterConfig;
import com.basho.riak.client.raw.http.HTTPClientAdapter;
import com.basho.riak.client.raw.http.HTTPClientConfig;
import com.basho.riak.client.raw.http.HTTPRiakClientFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPClusterClient
extends ClusterClient<HTTPClientConfig> {
    public HTTPClusterClient(ClusterConfig<HTTPClientConfig> clusterConfig) throws IOException {
        super(clusterConfig);
    }

    @Override
    protected RawClient[] fromConfig(ClusterConfig<HTTPClientConfig> clusterConfig) throws IOException {
        ArrayList<RawClient> clients = new ArrayList<RawClient>();
        int maxTotal = clusterConfig.getTotalMaximumConnections();
        if (maxTotal == 0) {
            HTTPRiakClientFactory fac = HTTPRiakClientFactory.getInstance();
            for (HTTPClientConfig node : clusterConfig.getClients()) {
                clients.add(fac.newClient(node));
            }
        } else {
            ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager();
            cm.setMaxTotal(maxTotal);
            for (HTTPClientConfig node : clusterConfig.getClients()) {
                if (node.getMaxConnections() != null) {
                    cm.setMaxForRoute(this.makeRoute(node.getUrl()), node.getMaxConnections().intValue());
                }
                DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)cm);
                if (node.getRetryHandler() != null) {
                    httpClient.setHttpRequestRetryHandler(node.getRetryHandler());
                }
                RiakConfig riakConfig = new RiakConfig(node.getUrl());
                riakConfig.setMapReducePath(node.getMapreducePath());
                riakConfig.setTimeout(node.getTimeout());
                riakConfig.setHttpClient((HttpClient)httpClient);
                clients.add(new HTTPClientAdapter(new RiakClient(riakConfig)));
            }
        }
        return clients.toArray(new RawClient[clients.size()]);
    }

    private HttpRoute makeRoute(String url) throws IOException {
        try {
            URI uri = new URI(url);
            HttpHost host = new HttpHost(uri.getHost(), uri.getPort());
            return new HttpRoute(host);
        }
        catch (URISyntaxException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public Transport getTransport() {
        return Transport.HTTP;
    }
}

