/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.pbc;

import com.basho.riak.pbc.IndexEntry;
import com.basho.riak.pbc.IndexRequest;
import com.basho.riak.pbc.RiakClient;
import com.basho.riak.pbc.RiakConnection;
import com.basho.riak.pbc.RiakStreamClient;
import java.io.IOException;
import java.util.NoSuchElementException;
import shaded.com.bash.riak.protobuf.RiakKvPB;
import shaded.com.bash.riak.protobuf.RiakPB;
import shaded.com.google.protobuf.ByteString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexSource
extends RiakStreamClient<IndexEntry> {
    private IndexRequest request;
    private int index;
    private RiakKvPB.RpbIndexResp pbResponse;

    public IndexSource(RiakClient client, RiakConnection conn, IndexRequest request) throws IOException {
        super(client, conn);
        this.request = request;
        this.getNextResponse();
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.isClosed()) {
            return false;
        }
        if (this.responseIsExhausted()) {
            this.getNextResponse();
        }
        return !this.isClosed();
    }

    @Override
    public IndexEntry next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.request.returnTerms()) {
            if (this.request.isRangeQuery()) {
                RiakPB.RpbPair pair = this.pbResponse.getResults(this.index++);
                return new IndexEntry(pair.getKey(), pair.getValue());
            }
            return new IndexEntry(ByteString.copyFromUtf8(this.request.getIndexKey()), this.pbResponse.getKeys(this.index++));
        }
        return new IndexEntry(this.pbResponse.getKeys(this.index++));
    }

    private boolean responseIsExhausted() {
        if (this.request.returnTerms() && this.request.isRangeQuery()) {
            return this.index == this.pbResponse.getResultsCount();
        }
        return this.index == this.pbResponse.getKeysCount();
    }

    private void getNextResponse() throws IOException {
        if (this.isClosed()) {
            return;
        }
        assert (this.pbResponse == null || this.responseIsExhausted());
        do {
            if (this.pbResponse != null && this.pbResponse.hasDone() && this.pbResponse.getDone()) {
                if (this.pbResponse.hasContinuation()) {
                    this.continuation = this.pbResponse.getContinuation();
                }
                this.close();
                return;
            }
            try {
                byte[] data = this.conn.receive(26);
                if (null == data) {
                    this.close();
                    throw new IOException("Received empty response");
                }
                this.pbResponse = RiakKvPB.RpbIndexResp.parseFrom(data);
                this.index = 0;
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        } while (this.pbResponse.getKeysCount() == 0 && this.pbResponse.getResultsCount() == 0);
    }
}

