/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.pbc;

import com.basho.riak.client.util.CharsetUtils;
import com.basho.riak.pbc.BucketProperties;
import com.basho.riak.pbc.BucketSource;
import com.basho.riak.pbc.DeleteMeta;
import com.basho.riak.pbc.FetchMeta;
import com.basho.riak.pbc.FetchResponse;
import com.basho.riak.pbc.IRequestMeta;
import com.basho.riak.pbc.IndexRequest;
import com.basho.riak.pbc.IndexSource;
import com.basho.riak.pbc.KeySource;
import com.basho.riak.pbc.MapReduceResponseSource;
import com.basho.riak.pbc.RequestMeta;
import com.basho.riak.pbc.RiakConnection;
import com.basho.riak.pbc.RiakConnectionPool;
import com.basho.riak.pbc.RiakMessageCodes;
import com.basho.riak.pbc.RiakObject;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;
import shaded.com.bash.riak.protobuf.RiakKvPB;
import shaded.com.bash.riak.protobuf.RiakPB;
import shaded.com.google.protobuf.ByteString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiakClient
implements RiakMessageCodes {
    private static final int BUFFER_SIZE_KB = Integer.parseInt(System.getProperty("com.basho.riak.client.pbc,buffer", "16"));
    private static final RiakObject[] NO_RIAK_OBJECTS = new RiakObject[0];
    private static final ByteString[] NO_BYTE_STRINGS = new ByteString[0];
    private String node;
    private String serverVersion;
    private volatile byte[] clientId;
    private final RiakConnectionPool pool;

    public RiakClient(String host) throws IOException {
        this(host, 8087);
    }

    public RiakClient(String host, int port) throws IOException {
        this(InetAddress.getByName(host), port);
    }

    public RiakClient(RiakConnectionPool pool) {
        this.pool = pool;
    }

    public RiakClient(InetAddress addr, int port) throws IOException {
        this.pool = new RiakConnectionPool(0, 0, addr, port, 1000L, BUFFER_SIZE_KB, 1000L, 0);
        this.pool.start();
    }

    public RiakClient(String host, int port, int bufferSizeKb) throws IOException {
        this.pool = new RiakConnectionPool(0, 0, InetAddress.getByName(host), port, 1000L, bufferSizeKb, 1000L, 0);
        this.pool.start();
    }

    RiakConnection getConnection() throws IOException {
        RiakConnection c = this.pool.getConnection(this.clientId);
        return c;
    }

    void release(RiakConnection c) {
        this.pool.releaseConnection(c);
    }

    public void prepareClientID() throws IOException {
        Preferences prefs = Preferences.userNodeForPackage(RiakClient.class);
        String clid = prefs.get("client_id", null);
        if (clid == null) {
            SecureRandom sr;
            try {
                sr = SecureRandom.getInstance("SHA1PRNG");
                sr.setSeed(UUID.randomUUID().getLeastSignificantBits() + new Date().getTime());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            byte[] data = new byte[6];
            sr.nextBytes(data);
            clid = CharsetUtils.asString(Base64.encodeBase64Chunked((byte[])data), CharsetUtils.ISO_8859_1);
            prefs.put("client_id", clid);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                throw new IOException(e.toString());
            }
        }
        this.setClientID(clid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() throws IOException {
        RiakConnection c = this.getConnection();
        try {
            c.send(1);
            c.receive_code(2);
        }
        finally {
            this.release(c);
        }
    }

    public void setClientID(String id) throws IOException {
        if (id == null || id.length() < 4) {
            throw new IllegalArgumentException("Client ID must be at least 4 bytes long");
        }
        this.setClientID(ByteString.copyFrom(CharsetUtils.utf8StringToBytes(id), 0, 4));
    }

    public void setClientID(ByteString id) throws IOException {
        if (id.size() > 4) {
            id = ByteString.copyFrom(id.toByteArray(), 0, 4);
        }
        this.clientId = id.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientID() throws IOException {
        RiakConnection c = this.getConnection();
        try {
            c.send(3);
            byte[] data = c.receive(4);
            if (data == null) {
                String string = null;
                return string;
            }
            RiakKvPB.RpbGetClientIdResp res = RiakKvPB.RpbGetClientIdResp.parseFrom(data);
            this.clientId = res.getClientId().toByteArray();
            String string = CharsetUtils.asUTF8String(this.clientId);
            return string;
        }
        finally {
            this.release(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getServerInfo() throws IOException {
        RiakConnection c = this.getConnection();
        try {
            c.send(7);
            byte[] data = c.receive(8);
            if (data == null) {
                Map<String, String> map = Collections.emptyMap();
                return map;
            }
            RiakPB.RpbGetServerInfoResp res = RiakPB.RpbGetServerInfoResp.parseFrom(data);
            if (res.hasNode()) {
                this.node = res.getNode().toStringUtf8();
            }
            if (res.hasServerVersion()) {
                this.serverVersion = res.getServerVersion().toStringUtf8();
            }
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("node", this.node);
            result.put("server_version", this.serverVersion);
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        finally {
            this.release(c);
        }
    }

    public RiakObject[] fetch(String bucket, String key, int readQuorum) throws IOException {
        return this.fetch(ByteString.copyFromUtf8(bucket), ByteString.copyFromUtf8(key), readQuorum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakObject[] fetch(ByteString bucket, ByteString key, int readQuorum) throws IOException {
        RiakKvPB.RpbGetReq req = RiakKvPB.RpbGetReq.newBuilder().setBucket(bucket).setKey(key).setR(readQuorum).build();
        RiakConnection c = this.getConnection();
        try {
            c.send(9, req);
            RiakObject[] riakObjectArray = this.processFetchReply(c, bucket, key).getObjects();
            return riakObjectArray;
        }
        finally {
            this.release(c);
        }
    }

    public FetchResponse fetch(String bucket, String key, FetchMeta fetchMeta) throws IOException {
        return this.fetch(ByteString.copyFromUtf8(bucket), ByteString.copyFromUtf8(key), fetchMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FetchResponse fetch(ByteString bucket, ByteString key, FetchMeta fetchMeta) throws IOException {
        RiakKvPB.RpbGetReq.Builder b = RiakKvPB.RpbGetReq.newBuilder().setBucket(bucket).setKey(key);
        fetchMeta.write(b);
        RiakConnection c = this.getConnection();
        try {
            c.send(9, b.build());
            FetchResponse fetchResponse = this.processFetchReply(c, bucket, key);
            return fetchResponse;
        }
        finally {
            this.release(c);
        }
    }

    public RiakObject[] fetch(String bucket, String key) throws IOException {
        return this.fetch(ByteString.copyFromUtf8(bucket), ByteString.copyFromUtf8(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakObject[] fetch(ByteString bucket, ByteString key) throws IOException {
        RiakKvPB.RpbGetReq req = RiakKvPB.RpbGetReq.newBuilder().setBucket(bucket).setKey(key).build();
        RiakConnection c = this.getConnection();
        try {
            c.send(9, req);
            RiakObject[] riakObjectArray = this.processFetchReply(c, bucket, key).getObjects();
            return riakObjectArray;
        }
        finally {
            this.release(c);
        }
    }

    private FetchResponse processFetchReply(RiakConnection c, ByteString bucket, ByteString key) throws IOException {
        byte[] rep = c.receive(10);
        if (rep == null) {
            return new FetchResponse(NO_RIAK_OBJECTS, false, null);
        }
        RiakKvPB.RpbGetResp resp = RiakKvPB.RpbGetResp.parseFrom(rep);
        int count = resp.getContentCount();
        if (count == 0) {
            RiakKvPB.RpbGetResp.Builder responseBuilder = resp.toBuilder();
            RiakKvPB.RpbContent.Builder contentBuilder = RiakKvPB.RpbContent.getDefaultInstance().toBuilder();
            contentBuilder.setDeleted(true).setValue(ByteString.EMPTY);
            resp = responseBuilder.addContent(contentBuilder.build()).build();
            count = 1;
        }
        RiakObject[] out = new RiakObject[count];
        ByteString vclock = resp.getVclock();
        for (int i = 0; i < count; ++i) {
            out[i] = new RiakObject(vclock, bucket, key, resp.getContent(i));
        }
        boolean unchanged = resp.getUnchanged();
        return new FetchResponse(out, unchanged, vclock.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> index(String bucket, String indexName, String value) throws IOException {
        RiakKvPB.RpbIndexReq req = RiakKvPB.RpbIndexReq.newBuilder().setBucket(ByteString.copyFromUtf8(bucket)).setIndex(ByteString.copyFromUtf8(indexName)).setKey(ByteString.copyFromUtf8(value)).setQtype(RiakKvPB.RpbIndexReq.IndexQueryType.eq).build();
        RiakConnection c = this.getConnection();
        try {
            c.send(25, req);
            List<String> list = this.processIndexReply(c);
            return list;
        }
        finally {
            this.release(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> index(String bucket, String indexName, String start, String end) throws IOException {
        RiakKvPB.RpbIndexReq req = RiakKvPB.RpbIndexReq.newBuilder().setBucket(ByteString.copyFromUtf8(bucket)).setIndex(ByteString.copyFromUtf8(indexName)).setRangeMin(ByteString.copyFromUtf8(start)).setRangeMax(ByteString.copyFromUtf8(end)).setQtype(RiakKvPB.RpbIndexReq.IndexQueryType.range).build();
        RiakConnection c = this.getConnection();
        try {
            c.send(25, req);
            List<String> list = this.processIndexReply(c);
            return list;
        }
        finally {
            this.release(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> index(String bucket, String indexName, long value) throws IOException {
        RiakKvPB.RpbIndexReq req = RiakKvPB.RpbIndexReq.newBuilder().setBucket(ByteString.copyFromUtf8(bucket)).setIndex(ByteString.copyFromUtf8(indexName)).setKey(ByteString.copyFromUtf8(String.valueOf(value))).setQtype(RiakKvPB.RpbIndexReq.IndexQueryType.eq).build();
        RiakConnection c = this.getConnection();
        try {
            c.send(25, req);
            List<String> list = this.processIndexReply(c);
            return list;
        }
        finally {
            this.release(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> index(String bucket, String indexName, long start, long end) throws IOException {
        RiakKvPB.RpbIndexReq req = RiakKvPB.RpbIndexReq.newBuilder().setBucket(ByteString.copyFromUtf8(bucket)).setIndex(ByteString.copyFromUtf8(indexName)).setRangeMin(ByteString.copyFromUtf8(String.valueOf(start))).setRangeMax(ByteString.copyFromUtf8(String.valueOf(end))).setQtype(RiakKvPB.RpbIndexReq.IndexQueryType.range).build();
        RiakConnection c = this.getConnection();
        try {
            c.send(25, req);
            List<String> list = this.processIndexReply(c);
            return list;
        }
        finally {
            this.release(c);
        }
    }

    private List<String> processIndexReply(RiakConnection c) throws IOException {
        byte[] rep = c.receive(26);
        if (null == rep) {
            return Collections.EMPTY_LIST;
        }
        RiakKvPB.RpbIndexResp resp = RiakKvPB.RpbIndexResp.parseFrom(rep);
        ArrayList<String> keys = new ArrayList<String>(resp.getKeysCount());
        for (ByteString bs : resp.getKeysList()) {
            keys.add(bs.toStringUtf8());
        }
        return keys;
    }

    public IndexSource index(IndexRequest request) throws IOException {
        RiakKvPB.RpbIndexReq req = request.buildProtocolBufferReq();
        RiakConnection c = this.getConnection();
        c.send(25, req);
        return new IndexSource(this, c, request);
    }

    public Long incrementCounter(String bucket, String counter, long increment, RequestMeta meta) throws IOException {
        return this.incrementCounter(ByteString.copyFromUtf8(bucket), ByteString.copyFromUtf8(counter), increment, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long incrementCounter(ByteString bucket, ByteString counter, long increment, RequestMeta meta) throws IOException {
        RiakConnection c = this.getConnection();
        RiakKvPB.RpbCounterUpdateReq.Builder builder = RiakKvPB.RpbCounterUpdateReq.newBuilder().setBucket(bucket).setKey(counter).setAmount(increment);
        if (meta != null) {
            meta.prepareCounter(builder);
        }
        try {
            c.send(50, builder.build());
            byte[] r = c.receive(51);
            if (r == null) {
                Long l = null;
                return l;
            }
            RiakKvPB.RpbCounterUpdateResp resp = RiakKvPB.RpbCounterUpdateResp.parseFrom(r);
            Long l = resp.getValue();
            return l;
        }
        finally {
            this.release(c);
        }
    }

    public Long fetchCounter(String bucket, String counter, FetchMeta meta) throws IOException {
        return this.fetchCounter(ByteString.copyFromUtf8(bucket), ByteString.copyFromUtf8(counter), meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long fetchCounter(ByteString bucket, ByteString counter, FetchMeta meta) throws IOException {
        RiakConnection c = this.getConnection();
        RiakKvPB.RpbCounterGetReq.Builder builder = RiakKvPB.RpbCounterGetReq.newBuilder().setBucket(bucket).setKey(counter);
        if (meta != null) {
            meta.writeCounter(builder);
        }
        try {
            c.send(52, builder.build());
            byte[] r = c.receive(53);
            if (r == null) {
                Long l = null;
                return l;
            }
            RiakKvPB.RpbCounterGetResp resp = RiakKvPB.RpbCounterGetResp.parseFrom(r);
            Long l = resp.getValue();
            return l;
        }
        finally {
            this.release(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteString[] store(RiakObject[] values, RequestMeta meta) throws IOException {
        RiakConnection c = this.getConnection();
        try {
            BulkReader reader = new BulkReader(c, values.length);
            Thread worker = new Thread(reader);
            worker.start();
            DataOutputStream dout = c.getOutputStream();
            for (int i = 0; i < values.length; ++i) {
                RiakObject value = values[i];
                RiakKvPB.RpbPutReq.Builder builder = RiakKvPB.RpbPutReq.newBuilder().setBucket(value.getBucketBS()).setKey(value.getKeyBS()).setContent(value.buildContent());
                if (value.getVclock() != null) {
                    builder.setVclock(value.getVclock());
                }
                builder.setReturnBody(true);
                if (meta != null) {
                    if (meta.writeQuorum != null) {
                        builder.setW(meta.writeQuorum);
                    }
                    if (meta.durableWriteQuorum != null) {
                        builder.setDw(meta.durableWriteQuorum);
                    }
                    if (meta.asis != null) {
                        builder.setAsis(meta.asis);
                    }
                }
                RiakKvPB.RpbPutReq req = builder.build();
                int len = req.getSerializedSize();
                dout.writeInt(len + 1);
                dout.write(11);
                req.writeTo(dout);
            }
            dout.flush();
            try {
                worker.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ByteString[] byteStringArray = reader.vclocks;
            return byteStringArray;
        }
        finally {
            this.release(c);
        }
    }

    public void store(RiakObject value) throws IOException {
        this.store(value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakObject[] store(RiakObject value, IRequestMeta meta) throws IOException {
        RiakKvPB.RpbPutReq.Builder builder = RiakKvPB.RpbPutReq.newBuilder().setBucket(value.getBucketBS()).setContent(value.buildContent());
        if (value.getKeyBS() != null) {
            builder.setKey(value.getKeyBS());
        }
        if (value.getVclock() != null) {
            builder.setVclock(value.getVclock());
        }
        if (meta != null) {
            meta.preparePut(builder);
        }
        RiakConnection c = this.getConnection();
        try {
            c.send(11, builder.build());
            byte[] r = c.receive(12);
            if (r == null) {
                RiakObject[] riakObjectArray = NO_RIAK_OBJECTS;
                return riakObjectArray;
            }
            RiakKvPB.RpbPutResp resp = RiakKvPB.RpbPutResp.parseFrom(r);
            RiakObject[] res = new RiakObject[resp.getContentCount()];
            ByteString vclock = resp.getVclock();
            for (int i = 0; i < res.length; ++i) {
                res[i] = new RiakObject(vclock, value.getBucketBS(), resp.hasKey() ? resp.getKey() : value.getKeyBS(), resp.getContent(i));
            }
            RiakObject[] riakObjectArray = res;
            return riakObjectArray;
        }
        finally {
            this.release(c);
        }
    }

    public void delete(String bucket, String key, DeleteMeta deleteMeta) throws IOException {
        this.delete(ByteString.copyFromUtf8(bucket), ByteString.copyFromUtf8(key), deleteMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(ByteString bucket, ByteString key, DeleteMeta deleteMeta) throws IOException {
        RiakKvPB.RpbDelReq.Builder builder = RiakKvPB.RpbDelReq.newBuilder().setBucket(bucket).setKey(key);
        deleteMeta.write(builder);
        RiakConnection c = this.getConnection();
        try {
            c.send(13, builder.build());
            c.receive_code(14);
        }
        finally {
            this.release(c);
        }
    }

    public void delete(String bucket, String key, int rw) throws IOException {
        this.delete(ByteString.copyFromUtf8(bucket), ByteString.copyFromUtf8(key), rw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(ByteString bucket, ByteString key, int rw) throws IOException {
        RiakKvPB.RpbDelReq req = RiakKvPB.RpbDelReq.newBuilder().setBucket(bucket).setKey(key).setRw(rw).build();
        RiakConnection c = this.getConnection();
        try {
            c.send(13, req);
            c.receive_code(14);
        }
        finally {
            this.release(c);
        }
    }

    public void delete(String bucket, String key) throws IOException {
        this.delete(ByteString.copyFromUtf8(bucket), ByteString.copyFromUtf8(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(ByteString bucket, ByteString key) throws IOException {
        RiakKvPB.RpbDelReq req = RiakKvPB.RpbDelReq.newBuilder().setBucket(bucket).setKey(key).build();
        RiakConnection c = this.getConnection();
        try {
            c.send(13, req);
            c.receive_code(14);
        }
        finally {
            this.release(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteString[] listBuckets() throws IOException {
        byte[] data;
        RiakConnection c = this.getConnection();
        try {
            c.send(15);
            data = c.receive(16);
            if (data == null) {
                ByteString[] byteStringArray = NO_BYTE_STRINGS;
                return byteStringArray;
            }
        }
        finally {
            this.release(c);
        }
        RiakKvPB.RpbListBucketsResp resp = RiakKvPB.RpbListBucketsResp.parseFrom(data);
        ByteString[] out = new ByteString[resp.getBucketsCount()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = resp.getBuckets(i);
        }
        return out;
    }

    public BucketSource listBucketsStreaming() throws IOException {
        RiakConnection c = this.getConnection();
        c.send(15, RiakKvPB.RpbListBucketsReq.newBuilder().setStream(true).build());
        return new BucketSource(this, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketProperties getBucketProperties(ByteString bucket) throws IOException {
        RiakConnection c = this.getConnection();
        try {
            c.send(19, RiakPB.RpbGetBucketReq.newBuilder().setBucket(bucket).build());
            byte[] data = c.receive(20);
            BucketProperties bp = new BucketProperties();
            if (data == null) {
                BucketProperties bucketProperties = bp;
                return bucketProperties;
            }
            bp.init(RiakPB.RpbGetBucketResp.parseFrom(data));
            BucketProperties bucketProperties = bp;
            return bucketProperties;
        }
        finally {
            this.release(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBucketProperties(ByteString bucket, BucketProperties props) throws IOException {
        RiakPB.RpbSetBucketReq req = RiakPB.RpbSetBucketReq.newBuilder().setBucket(bucket).setProps(props.build()).build();
        RiakConnection c = this.getConnection();
        try {
            c.send(21, req);
            c.receive_code(22);
        }
        finally {
            this.release(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBucketProperties(ByteString bucket) throws IOException {
        RiakPB.RpbResetBucketReq req = RiakPB.RpbResetBucketReq.newBuilder().setBucket(bucket).build();
        RiakConnection c = this.getConnection();
        try {
            c.send(29, req);
            c.receive_code(30);
        }
        finally {
            this.release(c);
        }
    }

    public KeySource listKeys(ByteString bucket) throws IOException {
        RiakConnection c = this.getConnection();
        c.send(17, RiakKvPB.RpbListKeysReq.newBuilder().setBucket(bucket).build());
        return new KeySource(this, c);
    }

    public MapReduceResponseSource mapReduce(JSONObject obj) throws IOException {
        return this.mapReduce(ByteString.copyFromUtf8(obj.toString()), new RequestMeta().contentType("application/json"));
    }

    public MapReduceResponseSource mapReduce(String request, IRequestMeta meta) throws IOException {
        return this.mapReduce(ByteString.copyFromUtf8(request), meta);
    }

    public MapReduceResponseSource mapReduce(ByteString request, IRequestMeta meta) throws IOException {
        RiakConnection c = this.getConnection();
        ByteString contentType = meta.getContentType();
        if (contentType == null) {
            throw new IllegalArgumentException("no content type");
        }
        RiakKvPB.RpbMapRedReq req = RiakKvPB.RpbMapRedReq.newBuilder().setRequest(request).setContentType(meta.getContentType()).build();
        c.send(23, req);
        return new MapReduceResponseSource(this, c, contentType);
    }

    public void shutdown() {
        this.pool.shutdown();
    }

    class BulkReader
    implements Runnable {
        private ByteString[] vclocks;
        private final RiakConnection c;

        public BulkReader(RiakConnection c, int count) {
            this.c = c;
            this.vclocks = new ByteString[count];
        }

        public void run() {
            try {
                for (int i = 0; i < this.vclocks.length; ++i) {
                    RiakKvPB.RpbPutResp resp;
                    byte[] data = this.c.receive(12);
                    if (data == null || !(resp = RiakKvPB.RpbPutResp.parseFrom(data)).hasVclock()) continue;
                    this.vclocks[i] = resp.getVclock();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

