/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.pbc;

import com.basho.riak.pbc.RiakClient;
import com.basho.riak.pbc.RiakConnection;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import shaded.com.google.protobuf.ByteString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RiakStreamClient<T>
implements Iterable<T> {
    static Timer TIMER = new Timer("riak-stream-timeout-thread", true);
    private RiakClient client;
    protected RiakConnection conn;
    protected ByteString continuation;
    private ReaperTask reaper;

    protected RiakStreamClient(RiakClient client, RiakConnection conn) {
        this.client = client;
        this.conn = conn;
        this.reaper = new ReaperTask(this, conn);
    }

    public boolean hasContinuation() {
        return this.continuation != null;
    }

    public ByteString getContinuation() {
        return this.continuation;
    }

    public synchronized void close() {
        if (!this.isClosed()) {
            this.reaper.cancel();
            this.client.release(this.conn);
            this.conn = null;
        }
    }

    public boolean isClosed() {
        return this.conn == null;
    }

    public abstract boolean hasNext() throws IOException;

    public abstract T next() throws IOException;

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                try {
                    return RiakStreamClient.this.hasNext();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public T next() {
                try {
                    return RiakStreamClient.this.next();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static class ReaperTask
    extends TimerTask {
        private final RiakConnection conn;
        private WeakReference<?> ref;

        ReaperTask(Object holder, RiakConnection conn) {
            this.conn = conn;
            this.ref = new WeakReference<Object>(holder);
            TIMER.scheduleAtFixedRate((TimerTask)this, 1000L, 1000L);
        }

        public synchronized void run() {
            if (this.ref != null) {
                if (this.ref.get() == null) {
                    this.cancel();
                    this.conn.close();
                    this.conn.release();
                } else if (this.conn.isClosed()) {
                    this.cancel();
                }
            }
        }

        public synchronized boolean cancel() {
            this.ref = null;
            return super.cancel();
        }
    }
}

