/*
 * Decompiled with CFR 0.152.
 */
package com.brinkus.labs.neo4j.health.type;

import com.brinkus.labs.neo4j.health.type.HealthStatus;
import com.brinkus.labs.neo4j.health.type.HealthStatusCode;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class Health {
    private final HealthStatus status;
    private final Map<String, Object> details;

    private Health(Builder builder) {
        this.status = builder.status;
        this.details = Collections.unmodifiableMap(builder.details);
    }

    @JsonUnwrapped
    public HealthStatus getStatus() {
        return this.status;
    }

    @JsonAnyGetter
    public Map<String, Object> getDetails() {
        return this.details;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof Health) {
            Health other = (Health)obj;
            return this.status.equals(other.status) && this.details.equals(other.details);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.status.hashCode();
        return 19 * hashCode + this.details.hashCode();
    }

    public String toString() {
        return String.format("%s %s", this.getStatus(), this.getDetails());
    }

    public static class Builder {
        private HealthStatus status = HealthStatus.UNKNOWN;
        private Map<String, Object> details = new LinkedHashMap<String, Object>();

        public Builder withException(Exception ex) {
            return this.withDetail("error", ex.getClass().getName() + ": " + ex.getMessage());
        }

        public Builder withDetail(String key, Object data) {
            this.details.put(key, data);
            return this;
        }

        public Builder unknown() {
            return this.status(HealthStatus.UNKNOWN);
        }

        public Builder up() {
            return this.status(HealthStatus.UP);
        }

        public Builder down() {
            return this.status(HealthStatus.DOWN);
        }

        public Builder outOfService() {
            return this.status(HealthStatus.OUT_OF_SERVICE);
        }

        public Builder status(HealthStatusCode statusCode) {
            return this.status(new HealthStatus(statusCode));
        }

        public Builder status(HealthStatus status) {
            this.status = status;
            return this;
        }

        public Health build() {
            return new Health(this);
        }
    }
}

