/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.catalog.AccountMetastoreAssignmentsService;
import com.databricks.internal.sdk.service.catalog.AccountsCreateMetastoreAssignment;
import com.databricks.internal.sdk.service.catalog.AccountsMetastoreAssignment;
import com.databricks.internal.sdk.service.catalog.AccountsUpdateMetastoreAssignment;
import com.databricks.internal.sdk.service.catalog.DeleteAccountMetastoreAssignmentRequest;
import com.databricks.internal.sdk.service.catalog.GetAccountMetastoreAssignmentRequest;
import com.databricks.internal.sdk.service.catalog.ListAccountMetastoreAssignmentsRequest;
import com.databricks.internal.sdk.service.catalog.ListAccountMetastoreAssignmentsResponse;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class AccountMetastoreAssignmentsImpl
implements AccountMetastoreAssignmentsService {
    private final ApiClient apiClient;

    public AccountMetastoreAssignmentsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void create(AccountsCreateMetastoreAssignment request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces/%s/metastores/%s", this.apiClient.configuredAccountID(), request.getWorkspaceId(), request.getMetastoreId());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteAccountMetastoreAssignmentRequest request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces/%s/metastores/%s", this.apiClient.configuredAccountID(), request.getWorkspaceId(), request.getMetastoreId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AccountsMetastoreAssignment get(GetAccountMetastoreAssignmentRequest request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces/%s/metastore", this.apiClient.configuredAccountID(), request.getWorkspaceId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, AccountsMetastoreAssignment.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListAccountMetastoreAssignmentsResponse list(ListAccountMetastoreAssignmentsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s/workspaces", this.apiClient.configuredAccountID(), request.getMetastoreId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListAccountMetastoreAssignmentsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(AccountsUpdateMetastoreAssignment request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces/%s/metastores/%s", this.apiClient.configuredAccountID(), request.getWorkspaceId(), request.getMetastoreId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

