/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient.impl.sqlexec;

import com.databricks.jdbc.api.impl.DatabricksResultSet;
import com.databricks.jdbc.api.impl.ImmutableSqlParameter;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.common.MetadataResultConstants;
import com.databricks.jdbc.common.StatementType;
import com.databricks.jdbc.common.util.JdbcThreadUtils;
import com.databricks.jdbc.common.util.WildcardUtil;
import com.databricks.jdbc.dbclient.IDatabricksClient;
import com.databricks.jdbc.dbclient.IDatabricksMetadataClient;
import com.databricks.jdbc.dbclient.impl.common.MetadataResultSetBuilder;
import com.databricks.jdbc.dbclient.impl.sqlexec.CommandBuilder;
import com.databricks.jdbc.dbclient.impl.sqlexec.CommandName;
import com.databricks.jdbc.dbclient.impl.sqlexec.ResultConstants;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DatabricksMetadataSdkClient
implements IDatabricksMetadataClient {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksMetadataSdkClient.class);
    private static final int DEFAULT_MAX_THREADS_FETCH_SCHEMAS = 10;
    private static final int TASK_TIMEOUT_FETCH_SCHEMAS_SEC = 90;
    private static final Object THREAD_POOL_LOCK = new Object();
    private static ExecutorService schemasThreadPool = null;
    private final IDatabricksClient sdkClient;
    private final MetadataResultSetBuilder metadataResultSetBuilder;

    public DatabricksMetadataSdkClient(IDatabricksClient sdkClient) {
        this.sdkClient = sdkClient;
        this.metadataResultSetBuilder = new MetadataResultSetBuilder(sdkClient.getConnectionContext());
    }

    @Override
    public DatabricksResultSet listTypeInfo(IDatabricksSession session) {
        LOGGER.debug("public ResultSet getTypeInfo()");
        return ResultConstants.TYPE_INFO_RESULT;
    }

    @Override
    public DatabricksResultSet listCatalogs(IDatabricksSession session) throws SQLException {
        CommandBuilder commandBuilder = new CommandBuilder(session);
        String SQL = commandBuilder.getSQLString(CommandName.LIST_CATALOGS);
        LOGGER.debug("SQL command to fetch catalogs: {}", SQL);
        return this.metadataResultSetBuilder.getCatalogsResult(this.getResultSet(SQL, session));
    }

    @Override
    public DatabricksResultSet listSchemas(IDatabricksSession session, String catalog, String schemaNamePattern) throws SQLException {
        CommandBuilder commandBuilder = new CommandBuilder(catalog, session).setSchemaPattern(schemaNamePattern);
        String SQL = commandBuilder.getSQLString(CommandName.LIST_SCHEMAS);
        LOGGER.debug("SQL command to fetch schemas: {}", SQL);
        try {
            return this.metadataResultSetBuilder.getSchemasResult(this.getResultSet(SQL, session), catalog);
        }
        catch (SQLException e) {
            if (WildcardUtil.isNullOrWildcard(catalog) && e.getSQLState().equals("42601")) {
                LOGGER.debug("SQL command failed with syntax error. Fetching schemas across all catalogs.");
                return this.fetchSchemasAcrossCatalogs(session, schemaNamePattern);
            }
            throw e;
        }
    }

    @Override
    public DatabricksResultSet listTables(IDatabricksSession session, String catalog, String schemaNamePattern, String tableNamePattern, String[] tableTypes) throws SQLException {
        String[] validatedTableTypes = Optional.ofNullable(tableTypes).filter(types -> ((String[])types).length > 0).orElse(MetadataResultConstants.DEFAULT_TABLE_TYPES);
        CommandBuilder commandBuilder = new CommandBuilder(catalog, session).setSchemaPattern(schemaNamePattern).setTablePattern(tableNamePattern);
        String SQL = commandBuilder.getSQLString(CommandName.LIST_TABLES);
        LOGGER.debug("SQL command to fetch tables: {}", SQL);
        LOGGER.debug(String.format("SQL command to fetch tables: {%s}", SQL));
        try {
            return this.metadataResultSetBuilder.getTablesResult(this.getResultSet(SQL, session), validatedTableTypes);
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("42601") && (catalog == null || catalog.equals("*") || catalog.equals("%"))) {
                LOGGER.debug("SQL command failed with syntax error. Returning empty result set.");
                return this.metadataResultSetBuilder.getResultSetWithGivenRowsAndColumns(MetadataResultConstants.TABLE_COLUMNS, new ArrayList<List<Object>>(), "gettables-metadata", com.databricks.jdbc.common.CommandName.LIST_TABLES);
            }
            throw e;
        }
    }

    @Override
    public DatabricksResultSet listTableTypes(IDatabricksSession session) throws SQLException {
        LOGGER.debug("Returning list of table types.");
        return this.metadataResultSetBuilder.getTableTypesResult();
    }

    @Override
    public DatabricksResultSet listColumns(IDatabricksSession session, String catalog, String schemaNamePattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        CommandBuilder commandBuilder = new CommandBuilder(catalog, session).setSchemaPattern(schemaNamePattern).setTablePattern(tableNamePattern).setColumnPattern(columnNamePattern);
        String SQL = commandBuilder.getSQLString(CommandName.LIST_COLUMNS);
        LOGGER.debug("SQL command to fetch columns: {}", SQL);
        return this.metadataResultSetBuilder.getColumnsResult(this.getResultSet(SQL, session));
    }

    @Override
    public DatabricksResultSet listFunctions(IDatabricksSession session, String catalog, String schemaNamePattern, String functionNamePattern) throws SQLException {
        CommandBuilder commandBuilder = new CommandBuilder(catalog, session).setSchemaPattern(schemaNamePattern).setFunctionPattern(functionNamePattern);
        String SQL = commandBuilder.getSQLString(CommandName.LIST_FUNCTIONS);
        LOGGER.debug("SQL command to fetch functions: {}", SQL);
        return this.metadataResultSetBuilder.getFunctionsResult(this.getResultSet(SQL, session), catalog);
    }

    @Override
    public DatabricksResultSet listPrimaryKeys(IDatabricksSession session, String catalog, String schema, String table) throws SQLException {
        CommandBuilder commandBuilder = new CommandBuilder(catalog, session).setSchema(schema).setTable(table);
        String SQL = commandBuilder.getSQLString(CommandName.LIST_PRIMARY_KEYS);
        LOGGER.debug("SQL command to fetch primary keys: {}", SQL);
        return this.metadataResultSetBuilder.getPrimaryKeysResult(this.getResultSet(SQL, session));
    }

    @Override
    public DatabricksResultSet listImportedKeys(IDatabricksSession session, String catalog, String schema, String table) throws SQLException {
        LOGGER.debug("public ResultSet listImportedKeys() using SDK");
        CommandBuilder commandBuilder = new CommandBuilder(catalog, session).setSchema(schema).setTable(table);
        String SQL = commandBuilder.getSQLString(CommandName.LIST_FOREIGN_KEYS);
        try {
            return this.metadataResultSetBuilder.getImportedKeysResult(this.getResultSet(SQL, session));
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("42601")) {
                LOGGER.debug("SQL command failed with syntax error. Returning empty result set.");
                return this.metadataResultSetBuilder.getResultSetWithGivenRowsAndColumns(MetadataResultConstants.IMPORTED_KEYS_COLUMNS, new ArrayList<List<Object>>(), "metadata-statement", com.databricks.jdbc.common.CommandName.GET_IMPORTED_KEYS);
            }
            throw e;
        }
    }

    @Override
    public DatabricksResultSet listExportedKeys(IDatabricksSession session, String catalog, String schema, String table) {
        LOGGER.debug("public ResultSet listExportedKeys() using SDK");
        return this.metadataResultSetBuilder.getResultSetWithGivenRowsAndColumns(MetadataResultConstants.EXPORTED_KEYS_COLUMNS, new ArrayList<List<Object>>(), "metadata-statement", com.databricks.jdbc.common.CommandName.GET_EXPORTED_KEYS);
    }

    @Override
    public DatabricksResultSet listCrossReferences(IDatabricksSession session, String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        LOGGER.debug("public ResultSet listCrossReferences() using SDK");
        CommandBuilder commandBuilder = new CommandBuilder(foreignCatalog, session).setSchema(foreignSchema).setTable(foreignTable);
        String SQL = commandBuilder.getSQLString(CommandName.LIST_FOREIGN_KEYS);
        try {
            return this.metadataResultSetBuilder.getCrossReferenceKeysResult(this.getResultSet(SQL, session), parentCatalog, parentSchema, parentTable);
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("42601")) {
                LOGGER.debug("SQL command failed with syntax error. Returning empty result set.");
                return this.metadataResultSetBuilder.getResultSetWithGivenRowsAndColumns(MetadataResultConstants.CROSS_REFERENCE_COLUMNS, new ArrayList<List<Object>>(), "metadata-statement", com.databricks.jdbc.common.CommandName.GET_CROSS_REFERENCE);
            }
            LOGGER.error(e, "Error while executing SQL command: %s, SQL state: %s", e.getMessage(), e.getSQLState());
            throw e;
        }
    }

    private DatabricksResultSet getResultSet(String SQL, IDatabricksSession session) throws SQLException {
        return this.sdkClient.executeStatement(SQL, session.getComputeResource(), new HashMap<Integer, ImmutableSqlParameter>(), StatementType.METADATA, session, null);
    }

    private DatabricksResultSet fetchSchemasAcrossCatalogs(IDatabricksSession session, String schemaPattern) throws SQLException {
        ArrayList<String> catalogList = new ArrayList<String>();
        try (DatabricksResultSet catalogs = session.getDatabricksMetadataClient().listCatalogs(session);){
            while (catalogs.next()) {
                String c2 = catalogs.getString(1);
                if (c2 == null || c2.isEmpty()) continue;
                catalogList.add(c2);
            }
        }
        List<List<Object>> schemaRows = JdbcThreadUtils.parallelFlatMap(catalogList, session.getConnectionContext(), 10, 90, c -> {
            ArrayList rows = new ArrayList();
            try (DatabricksResultSet catalogSchemas = session.getDatabricksMetadataClient().listSchemas(session, (String)c, schemaPattern);){
                while (catalogSchemas.next()) {
                    ArrayList<String> schemaRow = new ArrayList<String>();
                    schemaRow.add(catalogSchemas.getString(1));
                    schemaRow.add(catalogSchemas.getString(2));
                    rows.add(schemaRow);
                }
            }
            catch (SQLException e) {
                LOGGER.warn("Error fetching schemas for catalog %s %s", c, e.getMessage());
            }
            return rows;
        }, DatabricksMetadataSdkClient.getOrCreateSchemasThreadPool());
        return this.metadataResultSetBuilder.getResultSetWithGivenRowsAndColumns(MetadataResultConstants.SCHEMA_COLUMNS, schemaRows, "metadata-statement", com.databricks.jdbc.common.CommandName.LIST_SCHEMAS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService getOrCreateSchemasThreadPool() {
        Object object = THREAD_POOL_LOCK;
        synchronized (object) {
            if (schemasThreadPool == null || schemasThreadPool.isShutdown()) {
                schemasThreadPool = Executors.newFixedThreadPool(10, r -> {
                    Thread t2 = new Thread(r, "jdbc-schemas-fetcher");
                    t2.setDaemon(true);
                    return t2;
                });
            }
            return schemasThreadPool;
        }
    }
}

