/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.catalog.ConnectionInfo;
import com.databricks.internal.sdk.service.catalog.ConnectionsImpl;
import com.databricks.internal.sdk.service.catalog.ConnectionsService;
import com.databricks.internal.sdk.service.catalog.CreateConnection;
import com.databricks.internal.sdk.service.catalog.DeleteConnectionRequest;
import com.databricks.internal.sdk.service.catalog.GetConnectionRequest;
import com.databricks.internal.sdk.service.catalog.ListConnectionsRequest;
import com.databricks.internal.sdk.service.catalog.ListConnectionsResponse;
import com.databricks.internal.sdk.service.catalog.UpdateConnection;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ConnectionsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionsAPI.class);
    private final ConnectionsService impl;

    public ConnectionsAPI(ApiClient apiClient) {
        this.impl = new ConnectionsImpl(apiClient);
    }

    public ConnectionsAPI(ConnectionsService mock) {
        this.impl = mock;
    }

    public ConnectionInfo create(CreateConnection request) {
        return this.impl.create(request);
    }

    public void delete(String name) {
        this.delete(new DeleteConnectionRequest().setName(name));
    }

    public void delete(DeleteConnectionRequest request) {
        this.impl.delete(request);
    }

    public ConnectionInfo get(String name) {
        return this.get(new GetConnectionRequest().setName(name));
    }

    public ConnectionInfo get(GetConnectionRequest request) {
        return this.impl.get(request);
    }

    public Iterable<ConnectionInfo> list(ListConnectionsRequest request) {
        return new Paginator(request, this.impl::list, ListConnectionsResponse::getConnections, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public ConnectionInfo update(UpdateConnection request) {
        return this.impl.update(request);
    }

    public ConnectionsService impl() {
        return this.impl;
    }
}

