/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.volume;

import com.databricks.jdbc.api.IDatabricksVolumeClient;
import com.databricks.jdbc.api.impl.volume.DBFSVolumeClient;
import com.databricks.jdbc.api.impl.volume.DatabricksUCVolumeClient;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.util.DatabricksThreadContextHolder;
import com.databricks.jdbc.exception.DatabricksHttpException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.sql.Connection;

public class DatabricksVolumeClientFactory {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksVolumeClientFactory.class);

    public static IDatabricksVolumeClient getVolumeClient(Connection con) {
        LOGGER.debug(String.format("Entering public static IDatabricksVolumeClient getVolumeClient with Connection con = {%s}", con));
        return new DatabricksUCVolumeClient(con);
    }

    public static IDatabricksVolumeClient getVolumeClient(IDatabricksConnectionContext connectionContext) throws DatabricksHttpException {
        LOGGER.debug(String.format("Entering public static IDatabricksVolumeClient getVolumeClient with IDatabricksConnectionContext connectionContext = {%s}", connectionContext));
        DatabricksThreadContextHolder.setConnectionContext(connectionContext);
        return new DBFSVolumeClient(connectionContext);
    }
}

