/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.partitioner;

import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.shaded.guava.common.collect.ComparisonChain;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.datastax.oss.dsbulk.partitioner.BulkTokenFactory;
import com.datastax.oss.dsbulk.partitioner.BulkTokenRange;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class TokenRangeClusterer {
    private final BulkTokenFactory tokenFactory;

    public TokenRangeClusterer(@NonNull BulkTokenFactory tokenFactory) {
        this.tokenFactory = tokenFactory;
    }

    @NonNull
    public List<BulkTokenRange> group(List<BulkTokenRange> ranges, int groupCount, int maxGroupSize) {
        double ringFractionPerGroup = 1.0 / (double)groupCount;
        LinkedList sorted = Lists.newLinkedList(ranges);
        sorted.sort((tr1, tr2) -> ComparisonChain.start().compare((Comparable)tr1.getStart(), (Comparable)tr2.getStart()).compare((Comparable)tr1.getEnd(), (Comparable)tr2.getEnd()).result());
        if (sorted.isEmpty()) {
            return sorted;
        }
        ArrayList<BulkTokenRange> grouped = new ArrayList<BulkTokenRange>();
        while (!sorted.isEmpty()) {
            BulkTokenRange head = (BulkTokenRange)sorted.peek();
            assert (head != null);
            double ringFractionLimit = Math.max(ringFractionPerGroup, head.fraction());
            double cumulativeRingFraction = 0.0;
            Token end = head.getStart();
            for (int i = 0; i < Math.max(1, maxGroupSize) && !sorted.isEmpty(); ++i) {
                BulkTokenRange current = (BulkTokenRange)sorted.peek();
                assert (current != null);
                if ((cumulativeRingFraction += current.fraction()) > ringFractionLimit || !head.replicas().equals(current.replicas()) || !end.equals(current.getStart())) break;
                sorted.pop();
                end = current.getEnd();
            }
            grouped.add(this.tokenFactory.range(head.getStart(), end, head.replicas()));
        }
        ArrayList<BulkTokenRange> list = new ArrayList<BulkTokenRange>();
        for (BulkTokenRange tr : grouped) {
            for (TokenRange r : tr.unwrap()) {
                list.add(this.tokenFactory.range(r.getStart(), r.getEnd(), tr.replicas()));
            }
        }
        return list;
    }
}

