/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.spark.connector.cql.AuthConf;
import com.datastax.spark.connector.cql.AuthConf$;
import com.datastax.spark.connector.cql.CassandraConnectionFactory;
import com.datastax.spark.connector.cql.CassandraConnectionFactory$;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.CassandraConnectorConf$CassandraSSLConf$;
import com.datastax.spark.connector.cql.CloudBasedContactInfo;
import com.datastax.spark.connector.cql.ContactInfo;
import com.datastax.spark.connector.cql.DefaultConnectionFactory$;
import com.datastax.spark.connector.cql.IpBasedContactInfo;
import com.datastax.spark.connector.cql.ProfileFileBasedContactInfo;
import com.datastax.spark.connector.util.ConfigCheck$;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.util.ConfigParameter$;
import com.datastax.spark.connector.util.DeprecatedConfigParameter;
import com.datastax.spark.connector.util.DeprecatedConfigParameter$;
import com.datastax.spark.connector.util.Logging;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple15;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class CassandraConnectorConf$
implements Logging,
scala.Serializable {
    public static CassandraConnectorConf$ MODULE$;
    private final String ReferenceSection;
    private final ConfigParameter<Object> ConnectionPortParam;
    private final ConfigParameter<String> ConnectionHostParam;
    private final ConfigParameter<Option<String>> LocalDCParam;
    private final DeprecatedConfigParameter<Option<String>> DeprecatedLocalDCParam;
    private final ConfigParameter<Object> ConnectionTimeoutParam;
    private final DeprecatedConfigParameter<Object> DeprecatedConnectionTimeoutParam;
    private final ConfigParameter<Object> KeepAliveMillisParam;
    private final DeprecatedConfigParameter<Object> DeprecatedKeepAliveMillisParam;
    private final ConfigParameter<Object> MinReconnectionDelayParam;
    private final DeprecatedConfigParameter<Object> DeprecatedMinReconnectionDelayParam;
    private final ConfigParameter<Object> MaxReconnectionDelayParam;
    private final ConfigParameter<Option<Object>> LocalConnectionsPerExecutorParam;
    private final DeprecatedConfigParameter<Object> DeprecatedMaxReconnectionDelayParam;
    private final ConfigParameter<Option<Object>> RemoteConnectionsPerExecutorParam;
    private final ConfigParameter<String> CompressionParam;
    private final ConfigParameter<Object> QuietPeriodBeforeCloseParam;
    private final ConfigParameter<Object> TimeoutBeforeCloseParam;
    private final ConfigParameter<Object> QueryRetryParam;
    private final ConfigParameter<Object> ReadTimeoutParam;
    private final DeprecatedConfigParameter<Object> DeprecatedReadTimeoutParam;
    private final ConfigParameter<Object> ResolveContactPoints;
    private final String ReferenceSectionAlternativeConnection;
    private final ConfigParameter<Option<String>> CloudBasedConfigurationParam;
    private final ConfigParameter<Option<String>> ProfileFileBasedConfigurationParam;
    private final String ReferenceSectionSSL;
    private final CassandraConnectorConf.CassandraSSLConf DefaultCassandraSSLConf;
    private final ConfigParameter<Object> SSLEnabledParam;
    private final ConfigParameter<Option<String>> SSLTrustStorePathParam;
    private final ConfigParameter<Option<String>> SSLTrustStorePasswordParam;
    private final ConfigParameter<String> SSLTrustStoreTypeParam;
    private final ConfigParameter<String> SSLProtocolParam;
    private final ConfigParameter<Set<String>> SSLEnabledAlgorithmsParam;
    private final ConfigParameter<Object> SSLClientAuthEnabledParam;
    private final ConfigParameter<Option<String>> SSLKeyStorePathParam;
    private final ConfigParameter<Option<String>> SSLKeyStorePasswordParam;
    private final ConfigParameter<String> SSLKeyStoreTypeParam;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new CassandraConnectorConf$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public Option<String> $lessinit$greater$default$2() {
        return this.LocalDCParam().default();
    }

    public int $lessinit$greater$default$3() {
        return BoxesRunTime.unboxToInt((Object)this.KeepAliveMillisParam().default());
    }

    public int $lessinit$greater$default$4() {
        return BoxesRunTime.unboxToInt((Object)this.MinReconnectionDelayParam().default());
    }

    public int $lessinit$greater$default$5() {
        return BoxesRunTime.unboxToInt((Object)this.MaxReconnectionDelayParam().default());
    }

    public Option<Object> $lessinit$greater$default$6() {
        return this.LocalConnectionsPerExecutorParam().default();
    }

    public Option<Object> $lessinit$greater$default$7() {
        return this.RemoteConnectionsPerExecutorParam().default();
    }

    public String $lessinit$greater$default$8() {
        return this.CompressionParam().default();
    }

    public int $lessinit$greater$default$9() {
        return BoxesRunTime.unboxToInt((Object)this.QueryRetryParam().default());
    }

    public int $lessinit$greater$default$10() {
        return BoxesRunTime.unboxToInt((Object)this.ConnectionTimeoutParam().default());
    }

    public int $lessinit$greater$default$11() {
        return BoxesRunTime.unboxToInt((Object)this.ReadTimeoutParam().default());
    }

    public CassandraConnectionFactory $lessinit$greater$default$12() {
        return DefaultConnectionFactory$.MODULE$;
    }

    public int $lessinit$greater$default$13() {
        return BoxesRunTime.unboxToInt((Object)this.QuietPeriodBeforeCloseParam().default());
    }

    public int $lessinit$greater$default$14() {
        return BoxesRunTime.unboxToInt((Object)this.TimeoutBeforeCloseParam().default());
    }

    public boolean $lessinit$greater$default$15() {
        return BoxesRunTime.unboxToBoolean((Object)this.ResolveContactPoints().default());
    }

    public String ReferenceSection() {
        return this.ReferenceSection;
    }

    public ConfigParameter<Object> ConnectionPortParam() {
        return this.ConnectionPortParam;
    }

    public ConfigParameter<String> ConnectionHostParam() {
        return this.ConnectionHostParam;
    }

    public ConfigParameter<Option<String>> LocalDCParam() {
        return this.LocalDCParam;
    }

    public DeprecatedConfigParameter<Option<String>> DeprecatedLocalDCParam() {
        return this.DeprecatedLocalDCParam;
    }

    public ConfigParameter<Object> ConnectionTimeoutParam() {
        return this.ConnectionTimeoutParam;
    }

    public DeprecatedConfigParameter<Object> DeprecatedConnectionTimeoutParam() {
        return this.DeprecatedConnectionTimeoutParam;
    }

    public ConfigParameter<Object> KeepAliveMillisParam() {
        return this.KeepAliveMillisParam;
    }

    public DeprecatedConfigParameter<Object> DeprecatedKeepAliveMillisParam() {
        return this.DeprecatedKeepAliveMillisParam;
    }

    public ConfigParameter<Object> MinReconnectionDelayParam() {
        return this.MinReconnectionDelayParam;
    }

    public DeprecatedConfigParameter<Object> DeprecatedMinReconnectionDelayParam() {
        return this.DeprecatedMinReconnectionDelayParam;
    }

    public ConfigParameter<Object> MaxReconnectionDelayParam() {
        return this.MaxReconnectionDelayParam;
    }

    public ConfigParameter<Option<Object>> LocalConnectionsPerExecutorParam() {
        return this.LocalConnectionsPerExecutorParam;
    }

    public DeprecatedConfigParameter<Object> DeprecatedMaxReconnectionDelayParam() {
        return this.DeprecatedMaxReconnectionDelayParam;
    }

    public ConfigParameter<Option<Object>> RemoteConnectionsPerExecutorParam() {
        return this.RemoteConnectionsPerExecutorParam;
    }

    public ConfigParameter<String> CompressionParam() {
        return this.CompressionParam;
    }

    public ConfigParameter<Object> QuietPeriodBeforeCloseParam() {
        return this.QuietPeriodBeforeCloseParam;
    }

    public ConfigParameter<Object> TimeoutBeforeCloseParam() {
        return this.TimeoutBeforeCloseParam;
    }

    public ConfigParameter<Object> QueryRetryParam() {
        return this.QueryRetryParam;
    }

    public ConfigParameter<Object> ReadTimeoutParam() {
        return this.ReadTimeoutParam;
    }

    public DeprecatedConfigParameter<Object> DeprecatedReadTimeoutParam() {
        return this.DeprecatedReadTimeoutParam;
    }

    public ConfigParameter<Object> ResolveContactPoints() {
        return this.ResolveContactPoints;
    }

    public String ReferenceSectionAlternativeConnection() {
        return this.ReferenceSectionAlternativeConnection;
    }

    public ConfigParameter<Option<String>> CloudBasedConfigurationParam() {
        return this.CloudBasedConfigurationParam;
    }

    public ConfigParameter<Option<String>> ProfileFileBasedConfigurationParam() {
        return this.ProfileFileBasedConfigurationParam;
    }

    public String ReferenceSectionSSL() {
        return this.ReferenceSectionSSL;
    }

    public CassandraConnectorConf.CassandraSSLConf DefaultCassandraSSLConf() {
        return this.DefaultCassandraSSLConf;
    }

    public ConfigParameter<Object> SSLEnabledParam() {
        return this.SSLEnabledParam;
    }

    public ConfigParameter<Option<String>> SSLTrustStorePathParam() {
        return this.SSLTrustStorePathParam;
    }

    public ConfigParameter<Option<String>> SSLTrustStorePasswordParam() {
        return this.SSLTrustStorePasswordParam;
    }

    public ConfigParameter<String> SSLTrustStoreTypeParam() {
        return this.SSLTrustStoreTypeParam;
    }

    public ConfigParameter<String> SSLProtocolParam() {
        return this.SSLProtocolParam;
    }

    public ConfigParameter<Set<String>> SSLEnabledAlgorithmsParam() {
        return this.SSLEnabledAlgorithmsParam;
    }

    public ConfigParameter<Object> SSLClientAuthEnabledParam() {
        return this.SSLClientAuthEnabledParam;
    }

    public ConfigParameter<Option<String>> SSLKeyStorePathParam() {
        return this.SSLKeyStorePathParam;
    }

    public ConfigParameter<Option<String>> SSLKeyStorePasswordParam() {
        return this.SSLKeyStorePasswordParam;
    }

    public ConfigParameter<String> SSLKeyStoreTypeParam() {
        return this.SSLKeyStoreTypeParam;
    }

    private Option<InetSocketAddress> maybeResolveHostAndPort(String hostAndPort, int defaultPort, boolean resolveContactPoints) {
        Some some;
        Tuple2 tuple2;
        Tuple2 tuple22;
        if (hostAndPort.contains(":")) {
            String[] splitStr = hostAndPort.split(":");
            if (splitStr.length != 2) {
                throw new IllegalArgumentException(new StringBuilder(20).append("Couldn't parse host ").append(hostAndPort).toString());
            }
            tuple22 = new Tuple2((Object)splitStr[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(splitStr[1])).toInt()));
        } else {
            tuple22 = tuple2 = new Tuple2((Object)hostAndPort, (Object)BoxesRunTime.boxToInteger((int)defaultPort));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String hostName = (String)tuple2._1();
        int port = tuple2._2$mcI$sp();
        Tuple2 tuple23 = new Tuple2((Object)hostName, (Object)BoxesRunTime.boxToInteger((int)port));
        Tuple2 tuple24 = tuple23;
        String hostName2 = (String)tuple24._1();
        int port2 = tuple24._2$mcI$sp();
        if (resolveContactPoints) {
            try {
                some = new Some((Object)new InetSocketAddress(InetAddress.getByName(hostName2), port2));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Unknown host '").append(hostName2).append("'").toString(), e);
                None$ none$ = None$.MODULE$;
                some = none$;
            }
        } else {
            some = new Some((Object)InetSocketAddress.createUnresolved(hostName2, port2));
        }
        return some;
    }

    public CassandraConnectorConf apply(SparkConf conf) {
        return this.fromSparkConf(conf);
    }

    public Option<String> apply$default$2() {
        return this.LocalDCParam().default();
    }

    public int apply$default$3() {
        return BoxesRunTime.unboxToInt((Object)this.KeepAliveMillisParam().default());
    }

    public int apply$default$4() {
        return BoxesRunTime.unboxToInt((Object)this.MinReconnectionDelayParam().default());
    }

    public int apply$default$5() {
        return BoxesRunTime.unboxToInt((Object)this.MaxReconnectionDelayParam().default());
    }

    public Option<Object> apply$default$6() {
        return this.LocalConnectionsPerExecutorParam().default();
    }

    public Option<Object> apply$default$7() {
        return this.RemoteConnectionsPerExecutorParam().default();
    }

    public String apply$default$8() {
        return this.CompressionParam().default();
    }

    public int apply$default$9() {
        return BoxesRunTime.unboxToInt((Object)this.QueryRetryParam().default());
    }

    public int apply$default$10() {
        return BoxesRunTime.unboxToInt((Object)this.ConnectionTimeoutParam().default());
    }

    public int apply$default$11() {
        return BoxesRunTime.unboxToInt((Object)this.ReadTimeoutParam().default());
    }

    public CassandraConnectionFactory apply$default$12() {
        return DefaultConnectionFactory$.MODULE$;
    }

    public int apply$default$13() {
        return BoxesRunTime.unboxToInt((Object)this.QuietPeriodBeforeCloseParam().default());
    }

    public int apply$default$14() {
        return BoxesRunTime.unboxToInt((Object)this.TimeoutBeforeCloseParam().default());
    }

    public boolean apply$default$15() {
        return BoxesRunTime.unboxToBoolean((Object)this.ResolveContactPoints().default());
    }

    public ContactInfo getContactInfoFromSparkConf(SparkConf conf) {
        return (ContactInfo)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{conf.getOption(this.CloudBasedConfigurationParam().name()).map((Function1 & Serializable & scala.Serializable)url -> new CloudBasedContactInfo((String)url, AuthConf$.MODULE$.fromSparkConf(conf))), conf.getOption(this.ProfileFileBasedConfigurationParam().name()).map((Function1 & Serializable & scala.Serializable)path -> new ProfileFileBasedContactInfo((String)path)), new Some((Object)this.getIpBasedContactInfoFromSparkConf(conf))}))).collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Option<Product>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    Product contactPoint = (Product)some.value();
                    object = contactPoint;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<Product> x1) {
                Option<Product> option = x1;
                boolean bl = option instanceof Some;
                return bl;
            }
        }).get();
    }

    private IpBasedContactInfo getIpBasedContactInfoFromSparkConf(SparkConf conf) {
        boolean resolveContactPoints = conf.getBoolean(this.ResolveContactPoints().name(), BoxesRunTime.unboxToBoolean((Object)this.ResolveContactPoints().default()));
        int port = conf.getInt(this.ConnectionPortParam().name(), BoxesRunTime.unboxToInt((Object)this.ConnectionPortParam().default()));
        String hostsStr = conf.get(this.ConnectionHostParam().name(), this.ConnectionHostParam().default());
        Set hosts = (Set)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hostsStr.split(","))).toSet().flatMap((Function1 & Serializable & scala.Serializable)hostName -> Option$.MODULE$.option2Iterable(MODULE$.maybeResolveHostAndPort(hostName.trim(), port, resolveContactPoints).map((Function1 & Serializable & scala.Serializable)hostAddress -> hostAddress)), Set$.MODULE$.canBuildFrom());
        AuthConf authConf = AuthConf$.MODULE$.fromSparkConf(conf);
        boolean sslEnabled = conf.getBoolean(this.SSLEnabledParam().name(), BoxesRunTime.unboxToBoolean((Object)this.SSLEnabledParam().default()));
        Option sslTrustStorePath = conf.getOption(this.SSLTrustStorePathParam().name()).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.SSLTrustStorePathParam().default());
        Option sslTrustStorePassword = conf.getOption(this.SSLTrustStorePasswordParam().name()).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.SSLTrustStorePasswordParam().default());
        String sslTrustStoreType = conf.get(this.SSLTrustStoreTypeParam().name(), this.SSLTrustStoreTypeParam().default());
        String sslProtocol = conf.get(this.SSLProtocolParam().name(), this.SSLProtocolParam().default());
        Set sslEnabledAlgorithms = (Set)conf.getOption(this.SSLEnabledAlgorithmsParam().name()).map((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.split(","))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.SSLEnabledAlgorithmsParam().default());
        boolean sslClientAuthEnabled = conf.getBoolean(this.SSLClientAuthEnabledParam().name(), BoxesRunTime.unboxToBoolean((Object)this.SSLClientAuthEnabledParam().default()));
        Option sslKeyStorePath = conf.getOption(this.SSLKeyStorePathParam().name()).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.SSLKeyStorePathParam().default());
        Option sslKeyStorePassword = conf.getOption(this.SSLKeyStorePasswordParam().name()).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.SSLKeyStorePasswordParam().default());
        String sslKeyStoreType = conf.get(this.SSLKeyStoreTypeParam().name(), this.SSLKeyStoreTypeParam().default());
        boolean x$1 = sslEnabled;
        Option x$22 = sslTrustStorePath;
        Option x$3 = sslTrustStorePassword;
        String x$4 = sslTrustStoreType;
        boolean x$5 = sslClientAuthEnabled;
        Option x$6 = sslKeyStorePath;
        Option x$7 = sslKeyStorePassword;
        String x$8 = sslKeyStoreType;
        String x$9 = sslProtocol;
        Set x$10 = sslEnabledAlgorithms;
        CassandraConnectorConf.CassandraSSLConf cassandraSSLConf = new CassandraConnectorConf.CassandraSSLConf(x$1, (Option<String>)x$22, (Option<String>)x$3, x$4, x$9, (Set<String>)x$10, x$5, (Option<String>)x$6, (Option<String>)x$7, x$8);
        return new IpBasedContactInfo((Set<InetSocketAddress>)hosts, authConf, cassandraSSLConf);
    }

    public CassandraConnectorConf fromSparkConf(SparkConf conf) {
        ConfigCheck$.MODULE$.checkConfig(conf);
        Option localDC = conf.getOption(this.LocalDCParam().name());
        int keepAlive = conf.getInt(this.KeepAliveMillisParam().name(), BoxesRunTime.unboxToInt((Object)this.KeepAliveMillisParam().default()));
        int minReconnectionDelay = conf.getInt(this.MinReconnectionDelayParam().name(), BoxesRunTime.unboxToInt((Object)this.MinReconnectionDelayParam().default()));
        int maxReconnectionDelay = conf.getInt(this.MaxReconnectionDelayParam().name(), BoxesRunTime.unboxToInt((Object)this.MaxReconnectionDelayParam().default()));
        Option localConnections = conf.getOption(this.LocalConnectionsPerExecutorParam().name()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)CassandraConnectorConf$.$anonfun$fromSparkConf$1(x$4)));
        Option remoteConnections = conf.getOption(this.RemoteConnectionsPerExecutorParam().name()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)CassandraConnectorConf$.$anonfun$fromSparkConf$2(x$5)));
        int queryRetryCount = conf.getInt(this.QueryRetryParam().name(), BoxesRunTime.unboxToInt((Object)this.QueryRetryParam().default()));
        int connectTimeout = conf.getInt(this.ConnectionTimeoutParam().name(), BoxesRunTime.unboxToInt((Object)this.ConnectionTimeoutParam().default()));
        int readTimeout = conf.getInt(this.ReadTimeoutParam().name(), BoxesRunTime.unboxToInt((Object)this.ReadTimeoutParam().default()));
        int quietPeriodBeforeClose = conf.getInt(this.QuietPeriodBeforeCloseParam().name(), BoxesRunTime.unboxToInt((Object)this.QuietPeriodBeforeCloseParam().default()));
        int timeoutBeforeClose = conf.getInt(this.TimeoutBeforeCloseParam().name(), BoxesRunTime.unboxToInt((Object)this.TimeoutBeforeCloseParam().default()));
        boolean resolveContactPoints = conf.getBoolean(this.ResolveContactPoints().name(), BoxesRunTime.unboxToBoolean((Object)this.ResolveContactPoints().default()));
        String compression = (String)conf.getOption(this.CompressionParam().name()).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.CompressionParam().default());
        CassandraConnectionFactory connectionFactory = CassandraConnectionFactory$.MODULE$.fromSparkConf(conf);
        return new CassandraConnectorConf(this.getContactInfoFromSparkConf(conf), (Option<String>)localDC, keepAlive, minReconnectionDelay, maxReconnectionDelay, (Option<Object>)localConnections, (Option<Object>)remoteConnections, compression, queryRetryCount, connectTimeout, readTimeout, connectionFactory, quietPeriodBeforeClose, timeoutBeforeClose, resolveContactPoints);
    }

    private CassandraConnectorConf fromConnectionParams(SparkConf conf, Map<String, String> params) {
        return this.apply(conf.clone().setAll((Iterable)params.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String k = (String)A1._1();
                    String v = (String)A1._2();
                    if (ConfigCheck$.MODULE$.validStaticPropertyNames().contains((Object)new StringBuilder(0).append(ConfigCheck$.MODULE$.Prefix()).append(k).toString())) {
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(ConfigCheck$.MODULE$.Prefix()).append(k).toString()), (Object)v);
                        return (B1)object;
                    }
                }
                if (A1 != null) {
                    String k = (String)A1._1();
                    String v = (String)A1._2();
                    if (k.startsWith("spark.")) {
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<String, String> x1) {
                Tuple2<String, String> tuple2 = x1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    if (ConfigCheck$.MODULE$.validStaticPropertyNames().contains((Object)new StringBuilder(0).append(ConfigCheck$.MODULE$.Prefix()).append(k).toString())) {
                        return true;
                    }
                }
                if (tuple2 == null) return false;
                String k = (String)tuple2._1();
                if (!k.startsWith("spark.")) return false;
                return true;
            }
        }, Map$.MODULE$.canBuildFrom())));
    }

    public CassandraConnectorConf fromConnectionParams(Map<String, String> params) {
        return this.fromConnectionParams(new SparkConf(false), params);
    }

    public CassandraConnectorConf apply(ContactInfo contactInfo, Option<String> localDC, int keepAliveMillis, int minReconnectionDelayMillis, int maxReconnectionDelayMillis, Option<Object> localConnectionsPerExecutor, Option<Object> remoteConnectionsPerExecutor, String compression, int queryRetryCount, int connectTimeoutMillis, int readTimeoutMillis, CassandraConnectionFactory connectionFactory, int quietPeriodBeforeCloseMillis, int timeoutBeforeCloseMillis, boolean resolveContactPoints) {
        return new CassandraConnectorConf(contactInfo, localDC, keepAliveMillis, minReconnectionDelayMillis, maxReconnectionDelayMillis, localConnectionsPerExecutor, remoteConnectionsPerExecutor, compression, queryRetryCount, connectTimeoutMillis, readTimeoutMillis, connectionFactory, quietPeriodBeforeCloseMillis, timeoutBeforeCloseMillis, resolveContactPoints);
    }

    public Option<Tuple15<ContactInfo, Option<String>, Object, Object, Object, Option<Object>, Option<Object>, String, Object, Object, Object, CassandraConnectionFactory, Object, Object, Object>> unapply(CassandraConnectorConf x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple15((Object)x$0.contactInfo(), x$0.localDC(), (Object)BoxesRunTime.boxToInteger((int)x$0.keepAliveMillis()), (Object)BoxesRunTime.boxToInteger((int)x$0.minReconnectionDelayMillis()), (Object)BoxesRunTime.boxToInteger((int)x$0.maxReconnectionDelayMillis()), x$0.localConnectionsPerExecutor(), x$0.remoteConnectionsPerExecutor(), (Object)x$0.compression(), (Object)BoxesRunTime.boxToInteger((int)x$0.queryRetryCount()), (Object)BoxesRunTime.boxToInteger((int)x$0.connectTimeoutMillis()), (Object)BoxesRunTime.boxToInteger((int)x$0.readTimeoutMillis()), (Object)x$0.connectionFactory(), (Object)BoxesRunTime.boxToInteger((int)x$0.quietPeriodBeforeCloseMillis()), (Object)BoxesRunTime.boxToInteger((int)x$0.timeoutBeforeCloseMillis()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.resolveContactPoints())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ int $anonfun$fromSparkConf$1(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    public static final /* synthetic */ int $anonfun$fromSparkConf$2(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
    }

    private CassandraConnectorConf$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.ReferenceSection = "Cassandra Connection Parameters";
        this.ConnectionPortParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.port", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)9042), "Cassandra native connection port, will be set to all hosts if no individual ports are given");
        this.ConnectionHostParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.host", this.ReferenceSection(), "localhost", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(228).append("Contact point to connect to the Cassandra cluster. A comma separated list\n        |may also be used. Ports may be provided but are optional. If Ports are missing ").append(this.ConnectionPortParam().name()).append(" will\n        | be used (\"127.0.0.1:9042,192.168.0.1:9051\")\n      ").toString())).stripMargin());
        this.LocalDCParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.localDC", this.ReferenceSection(), None$.MODULE$, "The local DC to connect to (other nodes will be ignored)");
        String x$1 = "spark.cassandra.connection.local_dc";
        Some x$2 = new Some(this.LocalDCParam());
        String x$3 = "DSE 6.0.0";
        Function1<String, String> x$4 = DeprecatedConfigParameter$.MODULE$.apply$default$3();
        String x$5 = DeprecatedConfigParameter$.MODULE$.apply$default$5();
        this.DeprecatedLocalDCParam = DeprecatedConfigParameter$.MODULE$.apply(x$1, x$2, x$4, x$3, x$5);
        this.ConnectionTimeoutParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.timeoutMS", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)5000), "Maximum period of time to attempt connecting to a node");
        String x$6 = "spark.cassandra.connection.timeout_ms";
        Some x$7 = new Some(this.ConnectionTimeoutParam());
        String x$8 = "DSE 6.0.0";
        Function1<String, String> x$9 = DeprecatedConfigParameter$.MODULE$.apply$default$3();
        String x$10 = DeprecatedConfigParameter$.MODULE$.apply$default$5();
        this.DeprecatedConnectionTimeoutParam = DeprecatedConfigParameter$.MODULE$.apply(x$6, x$7, x$9, x$8, x$10);
        this.KeepAliveMillisParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.keepAliveMS", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)3600000), "Period of time to keep unused connections open");
        String x$11 = "spark.cassandra.connection.keep_alive_ms";
        Some x$12 = new Some(this.KeepAliveMillisParam());
        String x$13 = "DSE 6.0.0";
        Function1<String, String> x$14 = DeprecatedConfigParameter$.MODULE$.apply$default$3();
        String x$15 = DeprecatedConfigParameter$.MODULE$.apply$default$5();
        this.DeprecatedKeepAliveMillisParam = DeprecatedConfigParameter$.MODULE$.apply(x$11, x$12, x$14, x$13, x$15);
        this.MinReconnectionDelayParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.reconnectionDelayMS.min", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)1000), "Minimum period of time to wait before reconnecting to a dead node");
        String x$16 = "spark.cassandra.connection.reconnection_delay_ms.min";
        Some x$17 = new Some(this.MinReconnectionDelayParam());
        String x$18 = "DSE 6.0.0";
        Function1<String, String> x$19 = DeprecatedConfigParameter$.MODULE$.apply$default$3();
        String x$20 = DeprecatedConfigParameter$.MODULE$.apply$default$5();
        this.DeprecatedMinReconnectionDelayParam = DeprecatedConfigParameter$.MODULE$.apply(x$16, x$17, x$19, x$18, x$20);
        this.MaxReconnectionDelayParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.reconnectionDelayMS.max", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)60000), "Maximum period of time to wait before reconnecting to a dead node");
        this.LocalConnectionsPerExecutorParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.localConnectionsPerExecutor", this.ReferenceSection(), None$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("Number of local connections set on each Executor JVM. Defaults to the number\n          | of available CPU cores on the local node if not specified and not in a Spark Env")).stripMargin());
        String x$21 = "spark.cassandra.connection.reconnection_delay_ms.max";
        Some x$22 = new Some(this.MaxReconnectionDelayParam());
        String x$23 = "DSE 6.0.0";
        Function1<String, String> x$24 = DeprecatedConfigParameter$.MODULE$.apply$default$3();
        String x$25 = DeprecatedConfigParameter$.MODULE$.apply$default$5();
        this.DeprecatedMaxReconnectionDelayParam = DeprecatedConfigParameter$.MODULE$.apply(x$21, x$22, x$24, x$23, x$25);
        this.RemoteConnectionsPerExecutorParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.remoteConnectionsPerExecutor", this.ReferenceSection(), None$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("Minimum number of remote connections per Host set on each Executor JVM. Default value is\n          | estimated automatically based on the total number of executors in the cluster")).stripMargin());
        this.CompressionParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.compression", this.ReferenceSection(), "NONE", "Compression to use (LZ4, SNAPPY or NONE)");
        this.QuietPeriodBeforeCloseParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.quietPeriodBeforeCloseMS", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)0), "The time in seconds that must pass without any additional request after requesting connection close (see Netty quiet period)");
        this.TimeoutBeforeCloseParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.timeoutBeforeCloseMS", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)15000), "The time in seconds for all in-flight connections to finish after requesting connection close");
        this.QueryRetryParam = ConfigParameter$.MODULE$.apply("spark.cassandra.query.retry.count", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)60), new StringOps(Predef$.MODULE$.augmentString("Number of times to retry a timed-out query\n        |Setting this to -1 means unlimited retries\n      ")).stripMargin());
        this.ReadTimeoutParam = ConfigParameter$.MODULE$.apply("spark.cassandra.read.timeoutMS", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)120000), "Maximum period of time to wait for a read to return ");
        String x$26 = "spark.cassandra.read.timeout_ms";
        Some x$27 = new Some(this.ReadTimeoutParam());
        String x$28 = "DSE 6.0.0";
        Function1<String, String> x$29 = DeprecatedConfigParameter$.MODULE$.apply$default$3();
        String x$30 = DeprecatedConfigParameter$.MODULE$.apply$default$5();
        this.DeprecatedReadTimeoutParam = DeprecatedConfigParameter$.MODULE$.apply(x$26, x$27, x$29, x$28, x$30);
        this.ResolveContactPoints = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.resolveContactPoints", this.ReferenceSection(), BoxesRunTime.boxToBoolean((boolean)true), new StringOps(Predef$.MODULE$.augmentString("Controls, if we need to resolve contact points at start (true), or at reconnection (false).\n        |Helpful for usage with Kubernetes or other systems with dynamic endpoints which may change\n        |while the application is running.")).stripMargin());
        this.ReferenceSectionAlternativeConnection = "Alternative Connection Configuration Options";
        this.CloudBasedConfigurationParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.config.cloud.path", this.ReferenceSectionAlternativeConnection(), None$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("Path to Secure Connect Bundle to be used for this connection. Accepts URLs and references to files\n        |distributed via spark.files (--files) setting.<br/>\n        |Provided URL must by accessible from each executor.<br/>\n        |Using spark.files is recommended as it relies on Spark to distribute the bundle to every executor and\n        |leverages Spark capabilities to access files located in distributed file systems like HDFS, S3, etc.\n        |For example, to use a bundle located in HDFS in spark-shell:\n        |\n        |    spark-shell --conf spark.files=hdfs:///some_dir/bundle.zip \\\n        |       --conf spark.cassandra.connection.config.cloud.path=bundle.zip \\\n        |       --conf spark.cassandra.auth.username=<name> \\\n        |       --conf spark.cassandra.auth.password=<pass> ...\n        |\n        |")).stripMargin());
        this.ProfileFileBasedConfigurationParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.config.profile.path", this.ReferenceSectionAlternativeConnection(), None$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("Specifies a default Java Driver 4.0 Profile file to be used for this connection. Accepts\n                    |URLs and references to files distributed via spark.files (--files) setting.")).stripMargin());
        this.ReferenceSectionSSL = "Cassandra SSL Connection Options";
        this.DefaultCassandraSSLConf = new CassandraConnectorConf.CassandraSSLConf(CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$1(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$2(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$3(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$4(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$5(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$6(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$7(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$8(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$9(), CassandraConnectorConf$CassandraSSLConf$.MODULE$.apply$default$10());
        this.SSLEnabledParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.ssl.enabled", this.ReferenceSectionSSL(), BoxesRunTime.boxToBoolean((boolean)this.DefaultCassandraSSLConf().enabled()), "Enable secure connection to Cassandra cluster");
        this.SSLTrustStorePathParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.ssl.trustStore.path", this.ReferenceSectionSSL(), this.DefaultCassandraSSLConf().trustStorePath(), "Path for the trust store being used");
        this.SSLTrustStorePasswordParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.ssl.trustStore.password", this.ReferenceSectionSSL(), this.DefaultCassandraSSLConf().trustStorePassword(), "Trust store password");
        this.SSLTrustStoreTypeParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.ssl.trustStore.type", this.ReferenceSectionSSL(), this.DefaultCassandraSSLConf().trustStoreType(), "Trust store type");
        this.SSLProtocolParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.ssl.protocol", this.ReferenceSectionSSL(), this.DefaultCassandraSSLConf().protocol(), "SSL protocol");
        this.SSLEnabledAlgorithmsParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.ssl.enabledAlgorithms", this.ReferenceSectionSSL(), this.DefaultCassandraSSLConf().enabledAlgorithms(), "SSL cipher suites");
        this.SSLClientAuthEnabledParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.ssl.clientAuth.enabled", this.ReferenceSectionSSL(), BoxesRunTime.boxToBoolean((boolean)this.DefaultCassandraSSLConf().clientAuthEnabled()), "Enable 2-way secure connection to Cassandra cluster");
        this.SSLKeyStorePathParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.ssl.keyStore.path", this.ReferenceSectionSSL(), this.DefaultCassandraSSLConf().keyStorePath(), "Path for the key store being used");
        this.SSLKeyStorePasswordParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.ssl.keyStore.password", this.ReferenceSectionSSL(), this.DefaultCassandraSSLConf().keyStorePassword(), "Key store password");
        this.SSLKeyStoreTypeParam = ConfigParameter$.MODULE$.apply("spark.cassandra.connection.ssl.keyStore.type", this.ReferenceSectionSSL(), this.DefaultCassandraSSLConf().keyStoreType(), "Key store type");
    }
}

