/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.datasource;

import com.datastax.dse.driver.api.core.type.DseDataTypes;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.RelationMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.spark.connector.cql.CassandraConnectionFactory$;
import com.datastax.spark.connector.util.ConfigParameter$;
import com.datastax.spark.connector.util.DeprecatedConfigParameter$;
import com.datastax.spark.connector.util.Logging;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class CassandraSourceUtil$
implements Logging {
    public static CassandraSourceUtil$ MODULE$;
    private final Regex BracketList;
    private final Regex BracketMap;
    private final scala.collection.immutable.Map<DataType, org.apache.spark.sql.types.DataType> primitiveTypeMap;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new CassandraSourceUtil$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    private Regex BracketList() {
        return this.BracketList;
    }

    private Regex BracketMap() {
        return this.BracketMap;
    }

    private scala.collection.immutable.Map<DataType, org.apache.spark.sql.types.DataType> primitiveTypeMap() {
        return this.primitiveTypeMap;
    }

    public SparkConf consolidateConfs(SparkConf sparkConf, scala.collection.immutable.Map<String, String> sqlConf, String cluster, String keyspace, scala.collection.immutable.Map<String, String> userOptions) {
        SparkConf conf = sparkConf.clone();
        Option factoryName = CassandraSourceUtil$.consolidate$1(CassandraConnectionFactory$.MODULE$.FactoryParam().name(), userOptions, sqlConf, cluster, keyspace);
        Set<String> customConnectionFactoryProperties = CassandraConnectionFactory$.MODULE$.fromNameOrDefault((Option<String>)factoryName).properties();
        Seq AllSCCConfNames = (Seq)((TraversableLike)ConfigParameter$.MODULE$.names().$plus$plus(DeprecatedConfigParameter$.MODULE$.names(), Seq$.MODULE$.canBuildFrom())).$plus$plus(customConnectionFactoryProperties, Seq$.MODULE$.canBuildFrom());
        Seq SqlPropertyKeys = (Seq)AllSCCConfNames.flatMap((Function1 & Serializable & scala.Serializable)prop -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(2).append(cluster).append(":").append(keyspace).append("/").append((String)prop).toString(), new StringBuilder(1).append(cluster).append("/").append((String)prop).toString(), new StringBuilder(8).append("default/").append((String)prop).toString(), prop})), Seq$.MODULE$.canBuildFrom());
        AllSCCConfNames.foreach((Function1 & Serializable & scala.Serializable)prop -> {
            CassandraSourceUtil$.$anonfun$consolidateConfs$3(conf, userOptions, sqlConf, cluster, keyspace, prop);
            return BoxedUnit.UNIT;
        });
        conf.setAll((Iterable)sqlConf.$minus$minus((GenTraversableOnce)SqlPropertyKeys));
        conf.setAll((Iterable)userOptions.$minus$minus((GenTraversableOnce)AllSCCConfNames.$plus$plus((GenTraversableOnce)AllSCCConfNames.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toLowerCase(Locale.ROOT), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())));
        return conf;
    }

    public String consolidateConfs$default$3() {
        return "default";
    }

    public String consolidateConfs$default$4() {
        return "";
    }

    public scala.collection.immutable.Map<String, String> consolidateConfs$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    public DataType sparkSqlToJavaDriverType(org.apache.spark.sql.types.DataType dataType, ProtocolVersion protocolVersion) {
        DataType dataType2;
        boolean pvGt4 = protocolVersion.getCode() >= ProtocolVersion.V4.getCode();
        org.apache.spark.sql.types.DataType dataType3 = dataType;
        if (ByteType$.MODULE$.equals(dataType3)) {
            dataType2 = pvGt4 ? DataTypes.TINYINT : DataTypes.INT;
        } else if (ShortType$.MODULE$.equals(dataType3)) {
            dataType2 = pvGt4 ? DataTypes.SMALLINT : DataTypes.INT;
        } else if (IntegerType$.MODULE$.equals(dataType3)) {
            dataType2 = DataTypes.INT;
        } else if (LongType$.MODULE$.equals(dataType3)) {
            dataType2 = DataTypes.BIGINT;
        } else if (FloatType$.MODULE$.equals(dataType3)) {
            dataType2 = DataTypes.FLOAT;
        } else if (DoubleType$.MODULE$.equals(dataType3)) {
            dataType2 = DataTypes.DOUBLE;
        } else if (StringType$.MODULE$.equals(dataType3)) {
            dataType2 = DataTypes.TEXT;
        } else if (BinaryType$.MODULE$.equals(dataType3)) {
            dataType2 = DataTypes.BLOB;
        } else if (BooleanType$.MODULE$.equals(dataType3)) {
            dataType2 = DataTypes.BOOLEAN;
        } else if (TimestampType$.MODULE$.equals(dataType3)) {
            dataType2 = DataTypes.TIMESTAMP;
        } else if (DateType$.MODULE$.equals(dataType3)) {
            dataType2 = pvGt4 ? DataTypes.DATE : DataTypes.TIMESTAMP;
        } else if (DecimalType$.MODULE$.unapply(dataType3)) {
            dataType2 = DataTypes.DECIMAL;
        } else if (dataType3 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType3;
            org.apache.spark.sql.types.DataType sparkSqlElementType = arrayType.elementType();
            DataType argType = this.sparkSqlToJavaDriverType(sparkSqlElementType, this.sparkSqlToJavaDriverType$default$2());
            dataType2 = DataTypes.listOf((DataType)argType);
        } else if (dataType3 instanceof org.apache.spark.sql.types.MapType) {
            org.apache.spark.sql.types.MapType mapType = (org.apache.spark.sql.types.MapType)dataType3;
            org.apache.spark.sql.types.DataType sparkSqlKeyType = mapType.keyType();
            org.apache.spark.sql.types.DataType sparkSqlValueType = mapType.valueType();
            DataType keyType = this.sparkSqlToJavaDriverType(sparkSqlKeyType, this.sparkSqlToJavaDriverType$default$2());
            DataType valueType = this.sparkSqlToJavaDriverType(sparkSqlValueType, this.sparkSqlToJavaDriverType$default$2());
            dataType2 = DataTypes.mapOf((DataType)keyType, (DataType)valueType);
        } else {
            throw CassandraSourceUtil$.unsupportedType$1(dataType);
        }
        return dataType2;
    }

    public ProtocolVersion sparkSqlToJavaDriverType$default$2() {
        return ProtocolVersion.DEFAULT;
    }

    public org.apache.spark.sql.types.DataType catalystDataType(DataType cassandraType, boolean nullable) {
        ArrayType arrayType;
        DataType dataType = cassandraType;
        if (dataType instanceof SetType) {
            SetType setType = (SetType)dataType;
            arrayType = new ArrayType(this.catalystDataType(setType.getElementType(), nullable), nullable);
        } else if (dataType instanceof ListType) {
            ListType listType = (ListType)dataType;
            arrayType = new ArrayType(this.catalystDataType(listType.getElementType(), nullable), nullable);
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            arrayType = new org.apache.spark.sql.types.MapType(this.catalystDataType(mapType.getKeyType(), nullable), this.catalystDataType(mapType.getValueType(), nullable), nullable);
        } else if (dataType instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            arrayType = CassandraSourceUtil$.fromUdt$1(userDefinedType);
        } else if (dataType instanceof TupleType) {
            TupleType tupleType = (TupleType)dataType;
            arrayType = CassandraSourceUtil$.fromTuple$1(tupleType);
        } else {
            DataType dataType2 = DataTypes.VARINT;
            DataType dataType3 = dataType;
            if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "VarIntType is mapped to catalystTypes.DecimalType with unlimited values.");
                arrayType = this.primitiveCatalystDataType(cassandraType);
            } else {
                arrayType = this.primitiveCatalystDataType(cassandraType);
            }
        }
        return arrayType;
    }

    public org.apache.spark.sql.types.DataType primitiveCatalystDataType(DataType cassandraType) {
        return (org.apache.spark.sql.types.DataType)this.primitiveTypeMap().apply((Object)cassandraType);
    }

    public StructField toStructField(ColumnMetadata column, boolean nullable) {
        return new StructField(column.getName().asInternal(), this.catalystDataType(column.getType(), true), nullable, StructField$.MODULE$.apply$default$4());
    }

    public StructType toStructType(RelationMetadata metadata) {
        Set partitionKeys = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.getPartitionKey()).asScala()).toSet();
        Seq allColumns = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata.getColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> (ColumnMetadata)x$3._2(), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSeq();
        return StructType$.MODULE$.apply((Seq)allColumns.map((Function1 & Serializable & scala.Serializable)column -> MODULE$.toStructField((ColumnMetadata)column, !partitionKeys.contains(column)), Seq$.MODULE$.canBuildFrom()));
    }

    public StructType toStructTypeAllNullable(TableMetadata metadata) {
        Seq allColumns = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata.getColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> (ColumnMetadata)x$4._2(), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSeq();
        return StructType$.MODULE$.apply((Seq)allColumns.map((Function1 & Serializable & scala.Serializable)column -> MODULE$.toStructField((ColumnMetadata)column, true), Seq$.MODULE$.canBuildFrom()));
    }

    public List<String> parseList(String str) {
        String string = str;
        Option option = this.BracketList().unapplySeq((CharSequence)string);
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
            throw new MatchError((Object)string);
        }
        String innerStr = (String)((LinearSeqOptimized)option.get()).apply(0);
        String[] stringArray = innerStr.split(",");
        String[] arr = stringArray;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.replaceAll("\\s", ""), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList();
    }

    public Object parseProperty(String str) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(MODULE$.parseMap(str)).asJava()).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> str)).get();
    }

    public scala.collection.immutable.Map<String, String> parseMap(String str) {
        Tuple2[] tuple2Array;
        String string = str;
        Option option = this.BracketList().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String innerStr = (String)((LinearSeqOptimized)option.get()).apply(0);
            tuple2Array = CassandraSourceUtil$.handleInner$1(innerStr, str);
        } else {
            Option option2 = this.BracketMap().unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                String innerStr = (String)((LinearSeqOptimized)option2.get()).apply(0);
                tuple2Array = CassandraSourceUtil$.handleInner$1(innerStr, str);
            } else {
                throw new MatchError((Object)string);
            }
        }
        Tuple2[] m = tuple2Array;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])m)).toMap(Predef$.MODULE$.$conforms());
    }

    public String optionsListToString(List<Tuple2<String, Object>> options) {
        return ((TraversableOnce)options.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                if (k != null) {
                    String string = k;
                    if (v instanceof String) {
                        String string2 = (String)v;
                        return new StringBuilder(3).append(string).append("='").append(string2).append("'").toString();
                    }
                }
            }
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object innerM = tuple2._2();
                if (k != null) {
                    String string = k;
                    if (innerM instanceof scala.collection.immutable.Map) {
                        scala.collection.immutable.Map map = (scala.collection.immutable.Map)innerM;
                        return new StringBuilder(3).append(string).append("='").append(MODULE$.mapToString((scala.collection.immutable.Map<String, String>)map)).append("'").toString();
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            throw new IllegalArgumentException(new StringBuilder(16).append("Unable to parse ").append(options).toString());
        }, List$.MODULE$.canBuildFrom())).mkString(",");
    }

    public String mapToString(scala.collection.immutable.Map<String, String> m) {
        return ((TraversableOnce)m.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
    }

    private static final Option consolidate$1(String prop, scala.collection.immutable.Map userOptions$1, scala.collection.immutable.Map sqlConf$1, String cluster$1, String keyspace$1) {
        return ((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{userOptions$1.get((Object)prop.toLowerCase(Locale.ROOT)), sqlConf$1.get((Object)new StringBuilder(2).append(cluster$1).append(":").append(keyspace$1).append("/").append(prop).toString()), sqlConf$1.get((Object)new StringBuilder(1).append(cluster$1).append("/").append(prop).toString()), sqlConf$1.get((Object)new StringBuilder(8).append("default/").append(prop).toString()), sqlConf$1.get((Object)prop)})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).headOption();
    }

    public static final /* synthetic */ void $anonfun$consolidateConfs$3(SparkConf conf$1, scala.collection.immutable.Map userOptions$1, scala.collection.immutable.Map sqlConf$1, String cluster$1, String keyspace$1, String prop) {
        Option value = CassandraSourceUtil$.consolidate$1(prop, userOptions$1, sqlConf$1, cluster$1, keyspace$1);
        value.foreach((Function1 & Serializable & scala.Serializable)x$1 -> conf$1.set(prop, x$1));
    }

    private static final Nothing$ unsupportedType$1(org.apache.spark.sql.types.DataType dataType$1) {
        throw new IllegalArgumentException(new StringBuilder(18).append("Unsupported type: ").append(dataType$1).toString());
    }

    private static final StructType fromUdt$1(UserDefinedType udt) {
        Buffer fieldsAndType = (Buffer)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(udt.getFieldNames()).asScala()).zip((GenIterable)JavaConverters$.MODULE$.asScalaBufferConverter(udt.getFieldTypes()).asScala(), Buffer$.MODULE$.canBuildFrom());
        Buffer structFields = (Buffer)fieldsAndType.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            CqlIdentifier fieldName = (CqlIdentifier)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            StructField structField = new StructField(fieldName.asInternal(), MODULE$.catalystDataType(dataType, true), true, StructField$.MODULE$.apply$default$4());
            return structField;
        }, Buffer$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply((Seq)structFields);
    }

    private static final StructType fromTuple$1(TupleType t) {
        Buffer structFields = (Buffer)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(t.getComponentTypes()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DataType dataType = (DataType)tuple2._1();
            int index = tuple2._2$mcI$sp();
            StructField structField = new StructField(((Object)BoxesRunTime.boxToInteger((int)index)).toString(), MODULE$.catalystDataType(dataType, true), true, StructField$.MODULE$.apply$default$4());
            return structField;
        }, Buffer$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply((Seq)structFields);
    }

    private static final Tuple2[] handleInner$1(String innerStr, String str$2) {
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])innerStr.split(","))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.replaceAll("\\s", ""), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.split("="), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).map((Function1 & Serializable & scala.Serializable)kv -> {
            if (((String[])kv).length != 2) {
                throw new IllegalArgumentException(new StringBuilder(21).append("Cannot form Map from ").append(str$2).toString());
            }
            return new Tuple2((Object)kv[0], (Object)kv[1]);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    private CassandraSourceUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.BracketList = new StringOps(Predef$.MODULE$.augmentString("\\[(.*)\\]")).r();
        this.BracketMap = new StringOps(Predef$.MODULE$.augmentString("\\{(.*)\\}")).r();
        this.primitiveTypeMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.ASCII), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.BIGINT), (Object)LongType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.BLOB), (Object)BinaryType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.BOOLEAN), (Object)BooleanType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.COUNTER), (Object)LongType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.DATE), (Object)DateType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DseDataTypes.DATE_RANGE), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.DECIMAL), (Object)new DecimalType(38, 18)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.DOUBLE), (Object)DoubleType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.DURATION), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.FLOAT), (Object)FloatType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.INET), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.INT), (Object)IntegerType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DseDataTypes.LINE_STRING), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DseDataTypes.POLYGON), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DseDataTypes.POINT), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.SMALLINT), (Object)ShortType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.TEXT), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.TINYINT), (Object)ByteType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.TIME), (Object)LongType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.TIMESTAMP), (Object)TimestampType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.TIMEUUID), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.UUID), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataTypes.VARINT), (Object)new DecimalType(38, 0))}));
    }
}

