/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.util;

import com.datastax.spark.connector.cql.AuthConfFactory;
import com.datastax.spark.connector.cql.AuthConfFactory$;
import com.datastax.spark.connector.cql.CassandraConnectionFactory;
import com.datastax.spark.connector.cql.CassandraConnectionFactory$;
import com.datastax.spark.connector.util.ConfigCheck;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.util.ConfigParameter$;
import com.datastax.spark.connector.util.DeprecatedConfigParameter;
import com.datastax.spark.connector.util.DeprecatedConfigParameter$;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConfigCheck$ {
    public static ConfigCheck$ MODULE$;
    private final double MatchThreshold;
    private final String Prefix;
    private final Set<ConfigParameter<?>> validStaticProperties;
    private final Set<String> validStaticPropertyNames;
    private final Set<DeprecatedConfigParameter<?>> deprecatedProperties;

    static {
        new ConfigCheck$();
    }

    public double MatchThreshold() {
        return this.MatchThreshold;
    }

    public String Prefix() {
        return this.Prefix;
    }

    public Set<ConfigParameter<?>> validStaticProperties() {
        return this.validStaticProperties;
    }

    public Set<String> validStaticPropertyNames() {
        return this.validStaticPropertyNames;
    }

    public Set<DeprecatedConfigParameter<?>> deprecatedProperties() {
        return this.deprecatedProperties;
    }

    public void checkConfig(SparkConf conf) {
        this.deprecatedProperties().foreach((Function1 & Serializable & scala.Serializable)deprecatedProperty -> {
            deprecatedProperty.maybeReplace(conf);
            return BoxedUnit.UNIT;
        });
        CassandraConnectionFactory connectionFactory = CassandraConnectionFactory$.MODULE$.fromSparkConf(conf);
        AuthConfFactory authConfFactory = AuthConfFactory$.MODULE$.fromSparkConf(conf);
        scala.collection.immutable.Set extraProps = (scala.collection.immutable.Set)connectionFactory.properties().$plus$plus(authConfFactory.properties());
        Set invalidProperties = (Set)this.validStaticPropertyNames().$plus$plus((GenTraversableOnce)extraProps).filter((Function1 & Serializable & scala.Serializable)property -> BoxesRunTime.boxToBoolean((boolean)property.contains("_")));
        if (invalidProperties.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(90).append("Developer Error: These properties will not work in SparkSql/DataSets ").append("because of capitals: ").append(invalidProperties.mkString(",")).toString());
        }
        Seq<String> unknownProps = this.unknownProperties(conf, (scala.collection.immutable.Set<String>)extraProps);
        if (unknownProps.nonEmpty()) {
            Seq suggestions = (Seq)unknownProps.map((Function1 & Serializable & scala.Serializable)u -> new Tuple2(u, MODULE$.suggestedProperties((String)u, MODULE$.suggestedProperties$default$2())), Seq$.MODULE$.canBuildFrom());
            throw new ConfigCheck.ConnectorConfigurationException(unknownProps, (Map<String, Seq<String>>)suggestions.toMap(Predef$.MODULE$.$conforms()));
        }
    }

    public Seq<String> unknownProperties(SparkConf conf, scala.collection.immutable.Set<String> extraProps) {
        Set validProps = this.validStaticPropertyNames().$plus$plus(extraProps);
        String[] scEnv = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAll())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigCheck$.$anonfun$unknownProperties$1(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ConfigCheck$.$anonfun$unknownProperties$2(x$2))).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            String key;
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String string = key = (String)tuple2._1();
            return string;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scEnv)).withFilter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ConfigCheck$.$anonfun$unknownProperties$4(validProps, key))).map((Function1 & Serializable & scala.Serializable)key -> key, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public scala.collection.immutable.Set<String> unknownProperties$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    public Seq<String> suggestedProperties(String unknownProp, scala.collection.immutable.Set<String> extraProps) {
        Set validProps = this.validStaticPropertyNames().$plus$plus(extraProps);
        String[] unknownFragments = new StringOps(Predef$.MODULE$.augmentString(unknownProp)).stripPrefix(this.Prefix()).split("\\.");
        return (Seq)validProps.toSeq().filter((Function1 & Serializable & scala.Serializable)knownProp -> BoxesRunTime.boxToBoolean((boolean)ConfigCheck$.$anonfun$suggestedProperties$1(unknownFragments, knownProp)));
    }

    public scala.collection.immutable.Set<String> suggestedProperties$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    public static final /* synthetic */ boolean $anonfun$unknownProperties$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$unknownProperties$2(Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith(MODULE$.Prefix());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$unknownProperties$4(Set validProps$1, String key) {
        return !validProps$1.contains((Object)key);
    }

    public static final /* synthetic */ boolean $anonfun$suggestedProperties$3(String unknown$1, String known) {
        double matchScore = StringUtils.getJaroWinklerDistance((CharSequence)unknown$1, (CharSequence)known);
        return matchScore >= MODULE$.MatchThreshold();
    }

    public static final /* synthetic */ boolean $anonfun$suggestedProperties$2(String[] knownFragments$1, String unknown) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])knownFragments$1)).exists((Function1 & Serializable & scala.Serializable)known -> BoxesRunTime.boxToBoolean((boolean)ConfigCheck$.$anonfun$suggestedProperties$3(unknown, known)));
    }

    public static final /* synthetic */ boolean $anonfun$suggestedProperties$1(String[] unknownFragments$1, String knownProp) {
        String[] knownFragments = new StringOps(Predef$.MODULE$.augmentString(knownProp)).stripPrefix(MODULE$.Prefix()).split("\\.");
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unknownFragments$1)).forall((Function1 & Serializable & scala.Serializable)unknown -> BoxesRunTime.boxToBoolean((boolean)ConfigCheck$.$anonfun$suggestedProperties$2(knownFragments, unknown)));
    }

    private ConfigCheck$() {
        MODULE$ = this;
        this.MatchThreshold = 0.85;
        this.Prefix = "spark.cassandra.";
        this.validStaticProperties = ConfigParameter$.MODULE$.staticParameters();
        this.validStaticPropertyNames = (Set)this.validStaticProperties().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Set$.MODULE$.canBuildFrom());
        this.deprecatedProperties = DeprecatedConfigParameter$.MODULE$.deprecatedParameters();
    }
}

