/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.QueryUtils$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.util.DriverUtil$;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.PatitionKeyTools$;
import com.datastax.spark.connector.writer.BoundStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder$;
import com.datastax.spark.connector.writer.ReplicaLocator$;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\n\u0015\u0001}A\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A!\b\u0001B\u0001B\u0003%1\bC\u0003K\u0001\u0011%1\nC\u0004Q\u0001\t\u0007I\u0011A)\t\ru\u0003\u0001\u0015!\u0003S\u0011\u001dq\u0006A1A\u0005\u0002ECaa\u0018\u0001!\u0002\u0013\u0011\u0006b\u00021\u0001\u0005\u0004%\t!\u0019\u0005\u0007W\u0002\u0001\u000b\u0011\u00022\t\u000f1\u0004!\u0019!C\u0001[\"1A\u0010\u0001Q\u0001\n9DQ! \u0001\u0005\u0002y<q!a\r\u0015\u0011\u0003\t)D\u0002\u0004\u0014)!\u0005\u0011q\u0007\u0005\u0007\u0015>!\t!!\u000f\t\u000f\u0005mr\u0002\"\u0001\u0002>!I\u0011QM\b\u0002\u0002\u0013%\u0011q\r\u0002\u000f%\u0016\u0004H.[2b\u0019>\u001c\u0017\r^8s\u0015\t)b#\u0001\u0004xe&$XM\u001d\u0006\u0003/a\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005eQ\u0012!B:qCJ\\'BA\u000e\u001d\u0003!!\u0017\r^1ti\u0006D(\"A\u000f\u0002\u0007\r|Wn\u0001\u0001\u0016\u0005\u0001\n5\u0003\u0002\u0001\"O)\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0012)\u0013\tI3E\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0005\u0002,]5\tAF\u0003\u0002.-\u0005!Q\u000f^5m\u0013\tyCFA\u0004M_\u001e<\u0017N\\4\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005M2\u0012aA2rY&\u0011QG\r\u0002\u0013\u0007\u0006\u001c8/\u00198ee\u0006\u001cuN\u001c8fGR|'/\u0001\u0005uC\ndW\rR3g!\t\t\u0004(\u0003\u0002:e\tAA+\u00192mK\u0012+g-A\u0005s_^<&/\u001b;feB\u0019A(P \u000e\u0003QI!A\u0010\u000b\u0003\u0013I{wo\u0016:ji\u0016\u0014\bC\u0001!B\u0019\u0001!QA\u0011\u0001C\u0002\r\u0013\u0011\u0001V\t\u0003\t\u001e\u0003\"AI#\n\u0005\u0019\u001b#a\u0002(pi\"Lgn\u001a\t\u0003E!K!!S\u0012\u0003\u0007\u0005s\u00170\u0001\u0004=S:LGO\u0010\u000b\u0005\u00196su\nE\u0002=\u0001}BQa\u0006\u0003A\u0002ABQA\u000e\u0003A\u0002]BQA\u000f\u0003A\u0002m\nAb[3zgB\f7-\u001a(b[\u0016,\u0012A\u0015\t\u0003'js!\u0001\u0016-\u0011\u0005U\u001bS\"\u0001,\u000b\u0005]s\u0012A\u0002\u001fs_>$h(\u0003\u0002ZG\u00051\u0001K]3eK\u001aL!a\u0017/\u0003\rM#(/\u001b8h\u0015\tI6%A\u0007lKf\u001c\b/Y2f\u001d\u0006lW\rI\u0001\ni\u0006\u0014G.\u001a(b[\u0016\f!\u0002^1cY\u0016t\u0015-\\3!\u0003-\u0019w\u000e\\;n]:\u000bW.Z:\u0016\u0003\t\u00042a\u00195S\u001d\t!gM\u0004\u0002VK&\tA%\u0003\u0002hG\u00059\u0001/Y2lC\u001e,\u0017BA5k\u0005\r\u0019V-\u001d\u0006\u0003O\u000e\nAbY8mk6tg*Y7fg\u0002\n\u0001\u0002^8lK:l\u0015\r]\u000b\u0002]B\u0011qN_\u0007\u0002a*\u0011\u0011O]\u0001\t[\u0016$\u0018\rZ1uC*\u00111\u000f^\u0001\u0005G>\u0014XM\u0003\u0002vm\u0006\u0019\u0011\r]5\u000b\u0005]D\u0018A\u00023sSZ,'O\u0003\u0002z5\u0005\u0019qn]:\n\u0005m\u0004(\u0001\u0003+pW\u0016tW*\u00199\u0002\u0013Q|7.\u001a8NCB\u0004\u0013!D6fs\nK(+\u001a9mS\u000e\f7\u000fF\u0002\u0000\u0003[\u0001b!!\u0001\u0002\b\u0005-QBAA\u0002\u0015\r\t)aI\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0005\u0003\u0007\u0011\u0001\"\u0013;fe\u0006$xN\u001d\t\u0007E\u00055\u0011\u0011C \n\u0007\u0005=1E\u0001\u0004UkBdWM\r\t\u0007\u0003'\tI\"!\b\u000e\u0005\u0005U!\u0002BA\f\u0003\u0007\t\u0011\"[7nkR\f'\r\\3\n\t\u0005m\u0011Q\u0003\u0002\u0004'\u0016$\b\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\u0004]\u0016$(BAA\u0014\u0003\u0011Q\u0017M^1\n\t\u0005-\u0012\u0011\u0005\u0002\f\u0013:,G/\u00113ee\u0016\u001c8\u000fC\u0004\u000205\u0001\r!!\r\u0002\t\u0011\fG/\u0019\t\u0006\u0003\u0003\t9aP\u0001\u000f%\u0016\u0004H.[2b\u0019>\u001c\u0017\r^8s!\tatbE\u0002\u0010C\u001d\"\"!!\u000e\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\u0005}\u0012q\t\u000b\u000b\u0003\u0003\n\u0019&!\u0016\u0002X\u0005eC\u0003BA\"\u0003\u0013\u0002B\u0001\u0010\u0001\u0002FA\u0019\u0001)a\u0012\u0005\u000b\t\u000b\"\u0019A\"\t\u0013\u0005-\u0013#!AA\u0004\u00055\u0013AC3wS\u0012,gnY3%cA)A(a\u0014\u0002F%\u0019\u0011\u0011\u000b\u000b\u0003!I{wo\u0016:ji\u0016\u0014h)Y2u_JL\b\"B\f\u0012\u0001\u0004\u0001\u0004\"\u0002)\u0012\u0001\u0004\u0011\u0006\"\u00020\u0012\u0001\u0004\u0011\u0006bBA.#\u0001\u0007\u0011QL\u0001\u0013a\u0006\u0014H/\u001b;j_:\\U-_'baB,'\u000f\u0005\u0003\u0002`\u0005\u0005T\"\u0001\f\n\u0007\u0005\rdC\u0001\bD_2,XN\\*fY\u0016\u001cGo\u001c:\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003S\u0002B!a\u001b\u0002r5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n)#\u0001\u0003mC:<\u0017\u0002BA:\u0003[\u0012aa\u00142kK\u000e$\b")
public class ReplicaLocator<T>
implements scala.Serializable,
Logging {
    private final CassandraConnector connector;
    private final TableDef tableDef;
    private final RowWriter<T> rowWriter;
    private final String keyspaceName;
    private final String tableName;
    private final Seq<String> columnNames;
    private final TokenMap tokenMap;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    public static <T> ReplicaLocator<T> apply(CassandraConnector cassandraConnector, String string, String string2, ColumnSelector columnSelector, RowWriterFactory<T> rowWriterFactory) {
        return ReplicaLocator$.MODULE$.apply(cassandraConnector, string, string2, columnSelector, rowWriterFactory);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public String keyspaceName() {
        return this.keyspaceName;
    }

    public String tableName() {
        return this.tableName;
    }

    public Seq<String> columnNames() {
        return this.columnNames;
    }

    public TokenMap tokenMap() {
        return this.tokenMap;
    }

    public Iterator<Tuple2<Set<InetAddress>, T>> keyByReplicas(Iterator<T> data) {
        return (Iterator)this.connector.withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
            ProtocolVersion protocolVersion = session.getContext().getProtocolVersion();
            PreparedStatement stmt = PatitionKeyTools$.MODULE$.prepareDummyStatement((CqlSession)session, $this.tableDef);
            RowWriter x$1 = $this.rowWriter;
            PreparedStatement x$2 = stmt;
            ProtocolVersion x$3 = protocolVersion;
            Seq<Object> x$4 = BoundStatementBuilder$.MODULE$.$lessinit$greater$default$3();
            boolean x$5 = BoundStatementBuilder$.MODULE$.$lessinit$greater$default$4();
            BoundStatementBuilder boundStmtBuilder = new BoundStatementBuilder(x$1, x$2, x$4, x$5, x$3);
            Metadata clusterMetadata = session.getMetadata();
            return data.map((Function1 & Serializable & scala.Serializable)row -> {
                Set hosts = ((TraversableOnce)((SetLike)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(this.tokenMap().getReplicas(CqlIdentifier.fromInternal((String)this.keyspaceName()), QueryUtils$.MODULE$.getRoutingKeyOrError(boundStmtBuilder.bind(row).stmt()))).map((Function1 & Serializable & scala.Serializable)node -> (InetSocketAddress)DriverUtil$.MODULE$.toAddress(node).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(46).append("Unable to determine Node Broadcast Address of ").append(node).toString());
                }), Set$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getAddress(), Set$.MODULE$.canBuildFrom())).toSet();
                return new Tuple2((Object)hosts, row);
            });
        });
    }

    public ReplicaLocator(CassandraConnector connector, TableDef tableDef, RowWriter<T> rowWriter) {
        this.connector = connector;
        this.tableDef = tableDef;
        this.rowWriter = rowWriter;
        Logging.$init$((Logging)this);
        this.keyspaceName = tableDef.keyspaceName();
        this.tableName = tableDef.tableName();
        this.columnNames = rowWriter.columnNames();
        this.tokenMap = (TokenMap)DriverUtil$.MODULE$.toOption((Optional)connector.withSessionDo((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getMetadata().getTokenMap())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Unable to determine Token Map Metadata");
        });
    }
}

