/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.DefaultBatchType;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.spark.connector.CollectionAppend$;
import com.datastax.spark.connector.CollectionBehavior;
import com.datastax.spark.connector.CollectionColumnName;
import com.datastax.spark.connector.CollectionOverwrite$;
import com.datastax.spark.connector.CollectionPrepend$;
import com.datastax.spark.connector.CollectionRemove$;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.QueryUtils$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.types.ListType;
import com.datastax.spark.connector.util.CountingIterator;
import com.datastax.spark.connector.util.CountingIterator$;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Quote$;
import com.datastax.spark.connector.writer.AsyncStatementWriter;
import com.datastax.spark.connector.writer.AsyncStatementWriter$;
import com.datastax.spark.connector.writer.BatchGroupingKey;
import com.datastax.spark.connector.writer.BatchGroupingKey$None$;
import com.datastax.spark.connector.writer.BatchGroupingKey$Partition$;
import com.datastax.spark.connector.writer.BatchGroupingKey$ReplicaSet$;
import com.datastax.spark.connector.writer.BatchStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder$;
import com.datastax.spark.connector.writer.GroupingBatchBuilderBase;
import com.datastax.spark.connector.writer.PerRowWriteOptionValue;
import com.datastax.spark.connector.writer.RateLimiter;
import com.datastax.spark.connector.writer.RateLimiter$;
import com.datastax.spark.connector.writer.RichBoundStatementWrapper;
import com.datastax.spark.connector.writer.RichStatement;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import com.datastax.spark.connector.writer.StaticWriteOptionValue;
import com.datastax.spark.connector.writer.TTLOption;
import com.datastax.spark.connector.writer.TableWriter$;
import com.datastax.spark.connector.writer.TimestampOption;
import com.datastax.spark.connector.writer.WriteConf;
import com.datastax.spark.connector.writer.WriteOptionValue;
import java.io.IOException;
import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.spark.TaskContext;
import org.apache.spark.metrics.OutputMetricsUpdater;
import org.apache.spark.metrics.OutputMetricsUpdater$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t-f\u0001\u0002\u00180\u0001iB\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t#\u0002\u0011\t\u0011)A\u0005%\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011!\u0001\bA!A!\u0002\u0013\t\b\"\u0002;\u0001\t\u0013)\bb\u0002?\u0001\u0005\u0004%\t! \u0005\b\u0003'\u0001\u0001\u0015!\u0003\u007f\u0011!\t)\u0002\u0001b\u0001\n\u0003i\bbBA\f\u0001\u0001\u0006IA \u0005\n\u00033\u0001!\u0019!C\u0001\u00037A\u0001\"a\t\u0001A\u0003%\u0011Q\u0004\u0005\n\u0003K\u0001!\u0019!C\u0001\u0003OA\u0001\"!\r\u0001A\u0003%\u0011\u0011\u0006\u0005\u000b\u0003g\u0001\u0001R1A\u0005\u0002Ej\bbBA\u001b\u0001\u0011%\u0011q\u0007\u0005\n\u0003\u0007\u0002\u0001R1A\u0005\nuD\u0011\"!\u0012\u0001\u0005\u0004%I!a\u0012\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u0013B\u0011\"!\u0015\u0001\u0005\u0004%I!a\u0012\t\u0011\u0005M\u0003\u0001)A\u0005\u0003\u0013B!\"!\u0016\u0001\u0005\u0004%\t!MA$\u0011!\t9\u0006\u0001Q\u0001\n\u0005%\u0003bBA-\u0001\u0011%\u00111\f\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\tI\n\u0001C\u0001\u00037Cq!a1\u0001\t\u0003\t)\rC\u0004\u0002P\u0002!\t!!5\t\u000f\u0005e\u0007\u0001\"\u0003\u0002\\\"9\u0011q\u001c\u0001\u0005\n\u0005\u0005xaBAv_!\u0005\u0011Q\u001e\u0004\u0007]=B\t!a<\t\rQ\u0004C\u0011AAy\u0011\u001d\t\u0019\u0010\tC\u0005\u0003kDq!!@!\t\u0013\ty\u0010C\u0004\u0003\u0006\u0001\"IAa\u0002\t\u000f\t5\u0001\u0005\"\u0003\u0003\u0010!9!Q\u0003\u0011\u0005\n\t]\u0001b\u0002B\u0010A\u0011%!\u0011\u0005\u0005\n\u0005W\u0001#\u0019!C\u0005\u0005[A\u0001Ba\u0011!A\u0003%!q\u0006\u0005\b\u0005\u000b\u0002C\u0011\u0001B$\u0011%\u0011I\u0007II\u0001\n\u0003\u0011Y\u0007C\u0004\u0003F\u0001\"\tA!\"\t\u0013\t\u0005\u0006%!A\u0005\n\t\r&a\u0003+bE2,wK]5uKJT!\u0001M\u0019\u0002\r]\u0014\u0018\u000e^3s\u0015\t\u00114'A\u0005d_:tWm\u0019;pe*\u0011A'N\u0001\u0006gB\f'o\u001b\u0006\u0003m]\n\u0001\u0002Z1uCN$\u0018\r\u001f\u0006\u0002q\u0005\u00191m\\7\u0004\u0001U\u00111hZ\n\u0005\u0001q\u0012U\t\u0005\u0002>\u00016\taHC\u0001@\u0003\u0015\u00198-\u00197b\u0013\t\teH\u0001\u0004B]f\u0014VM\u001a\t\u0003{\rK!\u0001\u0012 \u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0005\u0019KU\"A$\u000b\u0005!\u000b\u0014\u0001B;uS2L!AS$\u0003\u000f1{wmZ5oOB\u0011AjT\u0007\u0002\u001b*\u0011a*M\u0001\u0004GFd\u0017B\u0001)N\u0005I\u0019\u0015m]:b]\u0012\u0014\u0018mQ8o]\u0016\u001cGo\u001c:\u0002\u0011Q\f'\r\\3EK\u001a\u0004\"\u0001T*\n\u0005Qk%\u0001\u0003+bE2,G)\u001a4\u0002\u001d\r|G.^7o'\u0016dWm\u0019;peB\u0019qK\u0017/\u000e\u0003aS!!\u0017 \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\\1\nQ\u0011J\u001c3fq\u0016$7+Z9\u0011\u0005usV\"A\u0019\n\u0005}\u000b$!C\"pYVlgNU3g\u0003%\u0011xn^,sSR,'\u000fE\u0002cG\u0016l\u0011aL\u0005\u0003I>\u0012\u0011BU8x/JLG/\u001a:\u0011\u0005\u0019<G\u0002\u0001\u0003\u0006Q\u0002\u0011\r!\u001b\u0002\u0002)F\u0011!.\u001c\t\u0003{-L!\u0001\u001c \u0003\u000f9{G\u000f[5oOB\u0011QH\\\u0005\u0003_z\u00121!\u00118z\u0003%9(/\u001b;f\u0007>tg\r\u0005\u0002ce&\u00111o\f\u0002\n/JLG/Z\"p]\u001a\fa\u0001P5oSRtDC\u0002<xqfT8\u0010E\u0002c\u0001\u0015DQA\r\u0004A\u0002-CQ!\u0015\u0004A\u0002ICQ!\u0016\u0004A\u0002YCQ\u0001\u0019\u0004A\u0002\u0005DQ\u0001\u001d\u0004A\u0002E\fAb[3zgB\f7-\u001a(b[\u0016,\u0012A \t\u0004\u007f\u00065a\u0002BA\u0001\u0003\u0013\u00012!a\u0001?\u001b\t\t)AC\u0002\u0002\be\na\u0001\u0010:p_Rt\u0014bAA\u0006}\u00051\u0001K]3eK\u001aLA!a\u0004\u0002\u0012\t11\u000b\u001e:j]\u001eT1!a\u0003?\u00035YW-_:qC\u000e,g*Y7fA\u0005IA/\u00192mK:\u000bW.Z\u0001\u000bi\u0006\u0014G.\u001a(b[\u0016\u0004\u0013aC2pYVlgNT1nKN,\"!!\b\u0011\t]\u000byB`\u0005\u0004\u0003CA&aA*fc\u0006a1m\u001c7v[:t\u0015-\\3tA\u000591m\u001c7v[:\u001cXCAA\u0015!\u00159\u0016qDA\u0016!\ra\u0015QF\u0005\u0004\u0003_i%!C\"pYVlg\u000eR3g\u0003!\u0019w\u000e\\;n]N\u0004\u0013\u0001G9vKJLH+Z7qY\u0006$X-V:j]\u001eLen]3si\u0006\u0019B-\u001a7fi\u0016\fV/\u001a:z)\u0016l\u0007\u000f\\1uKR\u0019a0!\u000f\t\u000f\u0005m\u0002\u00031\u0001\u0002>\u0005iA-\u001a7fi\u0016\u001cu\u000e\\;n]N\u00042!XA \u0013\r\t\t%\r\u0002\u000f\u0007>dW/\u001c8TK2,7\r^8s\u0003a\tX/\u001a:z)\u0016l\u0007\u000f\\1uKV\u001b\u0018N\\4Va\u0012\fG/Z\u0001\u0010SN\u001cu.\u001e8uKJ,\u0006\u000fZ1uKV\u0011\u0011\u0011\n\t\u0004{\u0005-\u0013bAA'}\t9!i\\8mK\u0006t\u0017\u0001E5t\u0007>,h\u000e^3s+B$\u0017\r^3!\u0003m\u0019wN\u001c;bS:\u001c8i\u001c7mK\u000e$\u0018n\u001c8CK\"\fg/[8sg\u0006a2m\u001c8uC&t7oQ8mY\u0016\u001cG/[8o\u0005\u0016D\u0017M^5peN\u0004\u0013\u0001D5t\u0013\u0012,W\u000e]8uK:$\u0018!D5t\u0013\u0012,W\u000e]8uK:$\b%\u0001\tqe\u0016\u0004\u0018M]3Ti\u0006$X-\\3oiR1\u0011QLA<\u0003w\u0002B!a\u0018\u0002t5\u0011\u0011\u0011\r\u0006\u0004\u001d\u0006\r$\u0002BA3\u0003O\nAaY8sK*!\u0011\u0011NA6\u0003\r\t\u0007/\u001b\u0006\u0005\u0003[\ny'\u0001\u0004ee&4XM\u001d\u0006\u0004\u0003c*\u0014aA8tg&!\u0011QOA1\u0005E\u0001&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e\u0005\u0007\u0003sB\u0002\u0019\u0001@\u0002\u001bE,XM]=UK6\u0004H.\u0019;f\u0011\u001d\ti\b\u0007a\u0001\u0003\u007f\nqa]3tg&|g\u000e\u0005\u0003\u0002\u0002\u0006\rUBAA2\u0013\u0011\t))a\u0019\u0003\u0015\r\u000bHnU3tg&|g.A\bcCR\u001c\u0007NU8vi&twmS3z)\u0011\tY)a&\u0015\u00075\fi\tC\u0004\u0002\u0010f\u0001\r!!%\u0002\u0005\t\u001c\bc\u00012\u0002\u0014&\u0019\u0011QS\u0018\u00033IK7\r\u001b\"pk:$7\u000b^1uK6,g\u000e^,sCB\u0004XM\u001d\u0005\b\u0003{J\u0002\u0019AA@\u0003\u00159(/\u001b;f)\u0019\ti*a)\u0002:B\u0019Q(a(\n\u0007\u0005\u0005fH\u0001\u0003V]&$\bbBAS5\u0001\u0007\u0011qU\u0001\fi\u0006\u001c8nQ8oi\u0016DH\u000f\u0005\u0003\u0002*\u0006UVBAAV\u0015\r!\u0014Q\u0016\u0006\u0005\u0003_\u000b\t,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003g\u000b1a\u001c:h\u0013\u0011\t9,a+\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010\u001e\u0005\b\u0003wS\u0002\u0019AA_\u0003\u0011!\u0017\r^1\u0011\t]\u000by,Z\u0005\u0004\u0003\u0003D&\u0001C%uKJ\fGo\u001c:\u0002\r\u0011,G.\u001a;f)\u0011\t9-!4\u0015\r\u0005u\u0015\u0011ZAf\u0011\u001d\t)k\u0007a\u0001\u0003OCq!a/\u001c\u0001\u0004\ti\fC\u0004\u0002&m\u0001\r!!\u0010\u0002\u001d\u001d,G/Q:z]\u000e<&/\u001b;feR\u0011\u00111\u001b\t\u0005E\u0006UW-C\u0002\u0002X>\u0012A#Q:z]\u000e\u001cF/\u0019;f[\u0016tGo\u0016:ji\u0016\u0014\u0018AF4fi\u0006\u001b\u0018P\\2Xe&$XM]%oi\u0016\u0014h.\u00197\u0015\t\u0005M\u0017Q\u001c\u0005\u0007\u0003sj\u0002\u0019\u0001@\u0002\u001b]\u0014\u0018\u000e^3J]R,'O\\1m)!\ti*a9\u0002h\u0006%\bbBAs=\u0001\u0007\u00111[\u0001\u0015CNLhnY*uCR,W.\u001a8u/JLG/\u001a:\t\u000f\u0005\u0015f\u00041\u0001\u0002(\"9\u00111\u0018\u0010A\u0002\u0005u\u0016a\u0003+bE2,wK]5uKJ\u0004\"A\u0019\u0011\u0014\u0007\u0001b$\t\u0006\u0002\u0002n\u0006\u00192\r[3dW6K7o]5oO\u000e{G.^7ogR1\u0011QTA|\u0003wDa!!?#\u0001\u0004\u0011\u0016!\u0002;bE2,\u0007bBA\rE\u0001\u0007\u0011QD\u0001\u001eG\",7m['jgNLgn\u001a)sS6\f'/_&fs\u000e{G.^7ogR1\u0011Q\u0014B\u0001\u0005\u0007Aa!!?$\u0001\u0004\u0011\u0006bBA\rG\u0001\u0007\u0011QD\u0001 G\",7m['jgNLgn\u001a)beRLG/[8o\u0017\u0016L8i\u001c7v[:\u001cHCBAO\u0005\u0013\u0011Y\u0001\u0003\u0004\u0002z\u0012\u0002\rA\u0015\u0005\b\u00033!\u0003\u0019AA\u000f\u0003eyg\u000e\\=QCJ$\u0018\u000e^5p].+\u00170\u00118e'R\fG/[2\u0015\r\u0005%#\u0011\u0003B\n\u0011\u0019\tI0\na\u0001%\"9\u0011\u0011D\u0013A\u0002\u0005u\u0011\u0001G2iK\u000e\\7i\u001c7mK\u000e$\u0018n\u001c8CK\"\fg/[8sgR1\u0011Q\u0014B\r\u00057Aa!!?'\u0001\u0004\u0011\u0006B\u0002B\u000fM\u0001\u0007a+\u0001\u0006d_2,XN\u001c*fMN\fAb\u00195fG.\u001cu\u000e\\;n]N$\u0002\"!(\u0003$\t\u0015\"q\u0005\u0005\u0007\u0003s<\u0003\u0019\u0001*\t\r\tuq\u00051\u0001W\u0011\u001d\u0011Ic\na\u0001\u0003\u0013\n\u0011c\u00195fG.\u0004\u0016M\u001d;ji&|gnS3z\u0003=Ie\u000e^3s]\u0006d7i\u001c7v[:\u001cXC\u0001B\u0018!\u00159&\u0011\u0007B\u001b\u0013\r\u0011\u0019\u0004\u0017\u0002\u0004'\u0016$\b\u0003\u0002B\u001c\u0005\u0003j!A!\u000f\u000b\t\tm\"QH\u0001\u0005Y\u0006twM\u0003\u0002\u0003@\u0005!!.\u0019<b\u0013\u0011\tyA!\u000f\u0002!%sG/\u001a:oC2\u001cu\u000e\\;n]N\u0004\u0013!B1qa2LX\u0003\u0002B%\u0005#\"bBa\u0013\u0003^\t}#\u0011\rB2\u0005K\u00129\u0007\u0006\u0003\u0003N\tM\u0003\u0003\u00022\u0001\u0005\u001f\u00022A\u001aB)\t\u0015A'F1\u0001j\u0011%\u0011)FKA\u0001\u0002\b\u00119&\u0001\u0006fm&$WM\\2fIE\u0002RA\u0019B-\u0005\u001fJ1Aa\u00170\u0005A\u0011vn^,sSR,'OR1di>\u0014\u0018\u0010C\u00033U\u0001\u00071\nC\u0003}U\u0001\u0007a\u0010\u0003\u0004\u0002\u0016)\u0002\rA \u0005\b\u00033Q\u0003\u0019AA\u001f\u0011\u0015\u0001(\u00061\u0001r\u0011%\u0011IC\u000bI\u0001\u0002\u0004\tI%A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00137+\u0011\u0011iGa!\u0016\u0005\t=$\u0006BA%\u0005cZ#Aa\u001d\u0011\t\tU$qP\u0007\u0003\u0005oRAA!\u001f\u0003|\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005{r\u0014AC1o]>$\u0018\r^5p]&!!\u0011\u0011B<\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0006Q.\u0012\r![\u000b\u0005\u0005\u000f\u0013y\t\u0006\u0007\u0003\n\n]%\u0011\u0014BN\u0005;\u0013y\n\u0006\u0003\u0003\f\nE\u0005\u0003\u00022\u0001\u0005\u001b\u00032A\u001aBH\t\u0015AGF1\u0001j\u0011%\u0011\u0019\nLA\u0001\u0002\b\u0011)*\u0001\u0006fm&$WM\\2fII\u0002RA\u0019B-\u0005\u001bCQA\r\u0017A\u0002-CQ!\u0015\u0017A\u0002ICq!!\u0007-\u0001\u0004\ti\u0004C\u0003qY\u0001\u0007\u0011\u000fC\u0004\u0003*1\u0002\r!!\u0013\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005K\u0003BAa\u000e\u0003(&!!\u0011\u0016B\u001d\u0005\u0019y%M[3di\u0002")
public class TableWriter<T>
implements scala.Serializable,
Logging {
    private String queryTemplateUsingInsert;
    private String queryTemplateUsingUpdate;
    private final CassandraConnector connector;
    private final TableDef tableDef;
    private final IndexedSeq<ColumnRef> columnSelector;
    private final RowWriter<T> rowWriter;
    private final WriteConf writeConf;
    private final String keyspaceName;
    private final String tableName;
    private final Seq<String> columnNames;
    private final Seq<ColumnDef> columns;
    private final boolean isCounterUpdate;
    private final boolean containsCollectionBehaviors;
    private final boolean isIdempotent;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;
    private volatile byte bitmap$0;

    public static <T> TableWriter<T> apply(CassandraConnector cassandraConnector, TableDef tableDef, ColumnSelector columnSelector, WriteConf writeConf, boolean bl, RowWriterFactory<T> rowWriterFactory) {
        return TableWriter$.MODULE$.apply(cassandraConnector, tableDef, columnSelector, writeConf, bl, rowWriterFactory);
    }

    public static <T> boolean apply$default$6() {
        return TableWriter$.MODULE$.apply$default$6();
    }

    public static <T> TableWriter<T> apply(CassandraConnector cassandraConnector, String string, String string2, ColumnSelector columnSelector, WriteConf writeConf, boolean bl, RowWriterFactory<T> rowWriterFactory) {
        return TableWriter$.MODULE$.apply(cassandraConnector, string, string2, columnSelector, writeConf, bl, rowWriterFactory);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public String keyspaceName() {
        return this.keyspaceName;
    }

    public String tableName() {
        return this.tableName;
    }

    public Seq<String> columnNames() {
        return this.columnNames;
    }

    public Seq<ColumnDef> columns() {
        return this.columns;
    }

    private String queryTemplateUsingInsert$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                WriteOptionValue<Object> writeOptionValue;
                None$ none$;
                WriteOptionValue<Object> writeOptionValue2;
                WriteOptionValue<Object> writeOptionValue3;
                None$ none$2;
                WriteOptionValue<Object> writeOptionValue4;
                Seq quotedColumnNames = (Seq)this.columnNames().map((Function1 & Serializable & scala.Serializable)name -> Quote$.MODULE$.quote(name), Seq$.MODULE$.canBuildFrom());
                String columnSpec = quotedColumnNames.mkString(", ");
                String valueSpec = ((TraversableOnce)quotedColumnNames.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append(":").append((String)x$1).toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String ifNotExistsSpec = this.writeConf.ifNotExists() ? "IF NOT EXISTS " : "";
                TTLOption tTLOption = this.writeConf.ttl();
                if (tTLOption != null && (writeOptionValue4 = tTLOption.value()) instanceof PerRowWriteOptionValue) {
                    PerRowWriteOptionValue perRowWriteOptionValue = (PerRowWriteOptionValue)writeOptionValue4;
                    String placeholder = perRowWriteOptionValue.placeholder();
                    none$2 = new Some((Object)new StringBuilder(5).append("TTL :").append(placeholder).toString());
                } else if (tTLOption != null && (writeOptionValue3 = tTLOption.value()) instanceof StaticWriteOptionValue) {
                    StaticWriteOptionValue staticWriteOptionValue = (StaticWriteOptionValue)writeOptionValue3;
                    int value = BoxesRunTime.unboxToInt(staticWriteOptionValue.value());
                    none$2 = new Some((Object)new StringBuilder(4).append("TTL ").append(value).toString());
                } else {
                    none$2 = None$.MODULE$;
                }
                None$ ttlSpec = none$2;
                TimestampOption timestampOption = this.writeConf.timestamp();
                if (timestampOption != null && (writeOptionValue2 = timestampOption.value()) instanceof PerRowWriteOptionValue) {
                    PerRowWriteOptionValue perRowWriteOptionValue = (PerRowWriteOptionValue)writeOptionValue2;
                    String placeholder = perRowWriteOptionValue.placeholder();
                    none$ = new Some((Object)new StringBuilder(11).append("TIMESTAMP :").append(placeholder).toString());
                } else if (timestampOption != null && (writeOptionValue = timestampOption.value()) instanceof StaticWriteOptionValue) {
                    StaticWriteOptionValue staticWriteOptionValue = (StaticWriteOptionValue)writeOptionValue;
                    long value = BoxesRunTime.unboxToLong(staticWriteOptionValue.value());
                    none$ = new Some((Object)new StringBuilder(10).append("TIMESTAMP ").append(value).toString());
                } else {
                    none$ = None$.MODULE$;
                }
                None$ timestampSpec = none$;
                List options = (List)new .colon.colon((Object)ttlSpec, (List)new .colon.colon((Object)timestampSpec, (List)Nil$.MODULE$)).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
                String optionsSpec = options.nonEmpty() ? new StringBuilder(6).append("USING ").append(options.mkString(" AND ")).toString() : "";
                this.queryTemplateUsingInsert = new StringBuilder(27).append("INSERT INTO ").append(Quote$.MODULE$.quote(this.keyspaceName())).append(".").append(Quote$.MODULE$.quote(this.tableName())).append(" (").append(columnSpec).append(") VALUES (").append(valueSpec).append(") ").append(ifNotExistsSpec).append(optionsSpec).toString().trim();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.queryTemplateUsingInsert;
    }

    public String queryTemplateUsingInsert() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.queryTemplateUsingInsert$lzycompute() : this.queryTemplateUsingInsert;
    }

    private String deleteQueryTemplate(ColumnSelector deleteColumns) {
        Seq deleteColumnNames = (Seq)deleteColumns.selectFrom(this.tableDef).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.columnName(), IndexedSeq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = this.columns().partition((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isPrimaryKeyColumn()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq primaryKey = (Seq)tuple2._1();
        Seq regularColumns = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)primaryKey, (Object)regularColumns);
        Tuple2 tuple23 = tuple22;
        Seq primaryKey2 = (Seq)tuple23._1();
        Seq regularColumns2 = (Seq)tuple23._2();
        if (regularColumns2.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(71).append("Only primary key columns can be used in delete. Regular columns found: ").append(regularColumns2.mkString(", ")).toString());
        }
        TableWriter$.MODULE$.com$datastax$spark$connector$writer$TableWriter$$checkMissingColumns(this.tableDef, (Seq<String>)deleteColumnNames);
        String deleteColumnsClause = ((TraversableOnce)deleteColumnNames.map((Function1 & Serializable & scala.Serializable)name -> Quote$.MODULE$.quote(name), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        String whereClause = ((TraversableOnce)TableWriter.quotedColumnNames$1(primaryKey2).map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(4).append((String)c).append(" = :").append((String)c).toString(), Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
        return new StringBuilder(21).append("DELETE ").append(deleteColumnsClause).append(" FROM ").append(Quote$.MODULE$.quote(this.keyspaceName())).append(".").append(Quote$.MODULE$.quote(this.tableName())).append(" WHERE ").append(whereClause).toString();
    }

    private String queryTemplateUsingUpdate$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple2 tuple2 = this.columns().partition((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isPrimaryKeyColumn()));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Seq primaryKey = (Seq)tuple2._1();
                Seq regularColumns = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)primaryKey, (Object)regularColumns);
                Tuple2 tuple23 = tuple22;
                Seq primaryKey2 = (Seq)tuple23._1();
                Seq regularColumns2 = (Seq)tuple23._2();
                Tuple2 tuple24 = regularColumns2.partition((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isCounterColumn()));
                if (tuple24 == null) {
                    throw new MatchError((Object)tuple24);
                }
                Seq counterColumns = (Seq)tuple24._1();
                Seq nonCounterColumns = (Seq)tuple24._2();
                Tuple2 tuple25 = new Tuple2((Object)counterColumns, (Object)nonCounterColumns);
                Tuple2 tuple26 = tuple25;
                Seq counterColumns2 = (Seq)tuple26._1();
                Seq nonCounterColumns2 = (Seq)tuple26._2();
                Map nameToBehavior = ((TraversableOnce)this.columnSelector.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends ColumnRef, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof CollectionColumnName) {
                            CollectionColumnName collectionColumnName = (CollectionColumnName)A1;
                            object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)collectionColumnName.columnName()), (Object)collectionColumnName.collectionBehavior());
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(ColumnRef x1) {
                        ColumnRef columnRef = x1;
                        boolean bl = columnRef instanceof CollectionColumnName;
                        return bl;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                Seq setNonCounterColumnsClause = (Seq)((TraversableLike)nonCounterColumns2.map((Function1 & Serializable & scala.Serializable)colDef -> {
                    String name = colDef.columnName();
                    Option collectionBehavior = nameToBehavior.get((Object)name);
                    String quotedName = Quote$.MODULE$.quote(name);
                    return new Tuple4(colDef, (Object)name, (Object)collectionBehavior, (Object)quotedName);
                }, Seq$.MODULE$.canBuildFrom())).map(TableWriter::$anonfun$queryTemplateUsingUpdate$4, Seq$.MODULE$.canBuildFrom());
                Seq setCounterColumnsClause = (Seq)TableWriter.quotedColumnNames$2(counterColumns2).map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(7).append((String)c).append(" = ").append((String)c).append(" + :").append((String)c).toString(), Seq$.MODULE$.canBuildFrom());
                String setClause = ((TraversableOnce)setNonCounterColumnsClause.$plus$plus((GenTraversableOnce)setCounterColumnsClause, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String whereClause = ((TraversableOnce)TableWriter.quotedColumnNames$2(primaryKey2).map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(4).append((String)c).append(" = :").append((String)c).toString(), Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
                this.queryTemplateUsingUpdate = new StringBuilder(20).append("UPDATE ").append(Quote$.MODULE$.quote(this.keyspaceName())).append(".").append(Quote$.MODULE$.quote(this.tableName())).append(" SET ").append(setClause).append(" WHERE ").append(whereClause).toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.queryTemplateUsingUpdate;
    }

    private String queryTemplateUsingUpdate() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.queryTemplateUsingUpdate$lzycompute() : this.queryTemplateUsingUpdate;
    }

    private boolean isCounterUpdate() {
        return this.isCounterUpdate;
    }

    private boolean containsCollectionBehaviors() {
        return this.containsCollectionBehaviors;
    }

    public boolean isIdempotent() {
        return this.isIdempotent;
    }

    private PreparedStatement prepareStatement(String queryTemplate, CqlSession session) {
        PreparedStatement preparedStatement;
        try {
            SimpleStatement stmt = (SimpleStatement)SimpleStatement.newInstance((String)queryTemplate).setIdempotent(Predef$.MODULE$.boolean2Boolean(this.isIdempotent())).setConsistencyLevel(this.writeConf.consistencyLevel());
            preparedStatement = session.prepare(stmt);
        }
        catch (Throwable t) {
            throw new IOException(new StringBuilder(30).append("Failed to prepare statement ").append(queryTemplate).append(": ").append(t.getMessage()).toString(), t);
        }
        return preparedStatement;
    }

    public Object batchRoutingKey(CqlSession session, RichBoundStatementWrapper bs) {
        Object object;
        BatchGroupingKey batchGroupingKey = this.writeConf.batchGroupingKey();
        if (BatchGroupingKey$None$.MODULE$.equals(batchGroupingKey)) {
            object = BoxesRunTime.boxToInteger((int)0);
        } else if (BatchGroupingKey$ReplicaSet$.MODULE$.equals(batchGroupingKey)) {
            object = ((TokenMap)session.getMetadata().getTokenMap().orElseThrow(TableWriter.missingMetadataException$1())).getReplicas(this.keyspaceName(), QueryUtils$.MODULE$.getRoutingKeyOrError(bs.stmt()));
        } else if (BatchGroupingKey$Partition$.MODULE$.equals(batchGroupingKey)) {
            object = QueryUtils$.MODULE$.getRoutingKeyOrError(bs.stmt());
        } else {
            throw new MatchError((Object)batchGroupingKey);
        }
        return object;
    }

    public void write(TaskContext taskContext, Iterator<T> data) {
        AsyncStatementWriter<T> asyncStatementWriter = this.getAsyncWriter();
        this.writeInternal(asyncStatementWriter, taskContext, data);
    }

    public void delete(ColumnSelector columns, TaskContext taskContext, Iterator<T> data) {
        this.writeInternal(this.getAsyncWriterInternal(this.deleteQueryTemplate(columns)), taskContext, data);
    }

    public AsyncStatementWriter<T> getAsyncWriter() {
        return this.isCounterUpdate() || this.containsCollectionBehaviors() ? this.getAsyncWriterInternal(this.queryTemplateUsingUpdate()) : this.getAsyncWriterInternal(this.queryTemplateUsingInsert());
    }

    private AsyncStatementWriter<T> getAsyncWriterInternal(String queryTemplate) {
        return (AsyncStatementWriter)this.connector.withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
            Function1 & Serializable & scala.Serializable intersect;
            ProtocolVersion protocolVersion = session.getContext().getProtocolVersion();
            PreparedStatement stmt2 = this.prepareStatement(queryTemplate, (CqlSession)session);
            DefaultBatchType batchType = this.isCounterUpdate() ? DefaultBatchType.COUNTER : DefaultBatchType.UNLOGGED;
            RowWriter x$1 = $this.rowWriter;
            PreparedStatement x$2 = stmt2;
            ProtocolVersion x$3 = protocolVersion;
            boolean x$4 = $this.writeConf.ignoreNulls();
            Seq<Object> x$5 = BoundStatementBuilder$.MODULE$.$lessinit$greater$default$3();
            BoundStatementBuilder boundStmtBuilder = new BoundStatementBuilder(x$1, x$2, x$5, x$4, x$3);
            BatchStatementBuilder batchStmtBuilder = new BatchStatementBuilder((BatchType)batchType, $this.writeConf.consistencyLevel());
            Function1 & Serializable & scala.Serializable batchKeyGenerator = (Function1 & Serializable & scala.Serializable)bs -> this.batchRoutingKey((CqlSession)session, (RichBoundStatementWrapper)bs);
            GroupingBatchBuilderBase batchBuilder = new GroupingBatchBuilderBase(boundStmtBuilder, batchStmtBuilder, (Function1<RichBoundStatementWrapper, Object>)batchKeyGenerator, $this.writeConf.batchSize(), $this.writeConf.batchGroupingBufferSize());
            Option<Object> option = $this.writeConf.throughputMiBPS();
            if (option instanceof Some) {
                Some some = (Some)option;
                double throughput = BoxesRunTime.unboxToDouble((Object)some.value());
                RateLimiter rateLimiter = new RateLimiter((long)(throughput * (double)1024 * (double)1024), 0x100000L, RateLimiter$.MODULE$.$lessinit$greater$default$3(), RateLimiter$.MODULE$.$lessinit$greater$default$4());
                intersect = (Function1 & Serializable & scala.Serializable)stmt -> {
                    rateLimiter.maybeSleep(stmt.bytesCount());
                    return BoxedUnit.UNIT;
                };
            } else if (None$.MODULE$.equals(option)) {
                intersect = (Function1 & Serializable & scala.Serializable)stmt -> {
                    TableWriter.$anonfun$getAsyncWriterInternal$4(stmt);
                    return BoxedUnit.UNIT;
                };
            } else {
                throw new MatchError(option);
            }
            Function1 & Serializable & scala.Serializable maybeRateLimit = intersect;
            return new AsyncStatementWriter($this.connector, $this.writeConf, $this.tableDef, stmt2, batchBuilder, (Function1<RichStatement, BoxedUnit>)maybeRateLimit, AsyncStatementWriter$.MODULE$.apply$default$7(), AsyncStatementWriter$.MODULE$.apply$default$8());
        });
    }

    private void writeInternal(AsyncStatementWriter<T> asyncStatementWriter, TaskContext taskContext, Iterator<T> data) {
        OutputMetricsUpdater updater = OutputMetricsUpdater$.MODULE$.apply(taskContext, this.writeConf);
        Some x$1 = new Some((Function3 & Serializable & scala.Serializable)(x$15, x$16, x$17) -> {
            updater.batchFinished(true, x$15, BoxesRunTime.unboxToLong((Object)x$16), BoxesRunTime.unboxToLong((Object)x$17));
            return BoxedUnit.UNIT;
        });
        Some x$2 = new Some((Function3 & Serializable & scala.Serializable)(x$18, x$19, x$20) -> {
            updater.batchFinished(false, x$18, BoxesRunTime.unboxToLong((Object)x$19), BoxesRunTime.unboxToLong((Object)x$20));
            return BoxedUnit.UNIT;
        });
        CassandraConnector x$3 = asyncStatementWriter.copy$default$1();
        WriteConf x$4 = asyncStatementWriter.copy$default$2();
        TableDef x$5 = asyncStatementWriter.copy$default$3();
        PreparedStatement x$6 = asyncStatementWriter.copy$default$4();
        GroupingBatchBuilderBase<T> x$7 = asyncStatementWriter.copy$default$5();
        Function1<RichStatement, BoxedUnit> x$8 = asyncStatementWriter.copy$default$6();
        AsyncStatementWriter metricMonitoringWriter = asyncStatementWriter.copy(x$3, x$4, x$5, x$6, x$7, x$8, (Option<Function3<RichStatement, Object, Object, BoxedUnit>>)x$1, (Option<Function3<RichStatement, Object, Object, BoxedUnit>>)x$2);
        CountingIterator rowIterator = new CountingIterator(data, CountingIterator$.MODULE$.$lessinit$greater$default$2());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Writing data partition to ").append(this.keyspaceName()).append(".").append(this.tableName()).append(" in batches of ").append($this.writeConf.batchSize()).append(".").toString());
        rowIterator.foreach((Function1 & Serializable & scala.Serializable)stmtToWrite -> {
            metricMonitoringWriter.write(stmtToWrite);
            return BoxedUnit.UNIT;
        });
        metricMonitoringWriter.close();
        double duration = (double)updater.finish() / 1.0E9;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)rowIterator.count());
            String arg$macro$2 = this.keyspaceName();
            String arg$macro$3 = this.tableName();
            double arg$macro$4 = duration;
            return new StringOps("Wrote %s rows to %s.%s in %.3f s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3, BoxesRunTime.boxToDouble((double)arg$macro$4)}));
        });
    }

    private static final Seq quotedColumnNames$1(Seq columns) {
        return (Seq)((TraversableLike)columns.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.columnName(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)name -> Quote$.MODULE$.quote(name), Seq$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ String $anonfun$queryTemplateUsingUpdate$4(Tuple4 x$10) {
        var4_1 = x$10;
        if (var4_1 == null) ** GOTO lbl26
        collectionBehavior = (Option)var4_1._3();
        quotedName = (String)var4_1._4();
        var7_4 = false;
        var8_5 = null;
        var9_6 = collectionBehavior;
        if (!(var9_6 instanceof Some)) ** GOTO lbl-1000
        var7_4 = true;
        var8_5 = (Some)var9_6;
        var10_7 = (CollectionBehavior)var8_5.value();
        if (CollectionAppend$.MODULE$.equals(var10_7)) {
            var2_8 = new StringBuilder(7).append(quotedName).append(" = ").append(quotedName).append(" + :").append(quotedName).toString();
        } else if (var7_4 && CollectionPrepend$.MODULE$.equals(var11_9 = (CollectionBehavior)var8_5.value())) {
            var2_8 = new StringBuilder(7).append(quotedName).append(" = :").append(quotedName).append(" + ").append(quotedName).toString();
        } else if (var7_4 && CollectionRemove$.MODULE$.equals(var12_10 = (CollectionBehavior)var8_5.value())) {
            var2_8 = new StringBuilder(7).append(quotedName).append(" = ").append(quotedName).append(" - :").append(quotedName).toString();
        } else {
            var3_13 = var9_6 instanceof Some != false && CollectionOverwrite$.MODULE$.equals(var14_12 = (CollectionBehavior)(var13_11 = (Some)var9_6).value()) != false ? true : None$.MODULE$.equals(var9_6) != false;
            if (var3_13) {
                var2_8 = new StringBuilder(4).append(quotedName).append(" = :").append(quotedName).toString();
            } else {
                throw new MatchError((Object)var9_6);
lbl26:
                // 1 sources

                throw new MatchError((Object)var4_1);
            }
        }
        var1_14 = var2_8;
        return var1_14;
    }

    private static final Seq quotedColumnNames$2(Seq columns) {
        return (Seq)((TraversableLike)columns.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.columnName(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)name -> Quote$.MODULE$.quote(name), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$containsCollectionBehaviors$1(ColumnRef x$13) {
        return x$13 instanceof CollectionColumnName;
    }

    public static final /* synthetic */ boolean $anonfun$isIdempotent$2(TableWriter $this, ColumnRef x0$1) {
        boolean bl;
        ColumnRef columnRef = x0$1;
        if (columnRef instanceof CollectionColumnName) {
            CollectionColumnName collectionColumnName = (CollectionColumnName)columnRef;
            String name = collectionColumnName.columnName();
            CollectionBehavior behavior = collectionColumnName.collectionBehavior();
            boolean isNotList = !(((ColumnDef)$this.tableDef.columnByName().apply((Object)name)).columnType() instanceof ListType);
            CollectionBehavior collectionBehavior = behavior;
            boolean bl2 = CollectionPrepend$.MODULE$.equals(collectionBehavior) ? isNotList : (CollectionAppend$.MODULE$.equals(collectionBehavior) ? isNotList : true);
            bl = bl2;
        } else if (columnRef != null) {
            bl = true;
        } else {
            throw new MatchError((Object)columnRef);
        }
        return bl;
    }

    private static final Supplier missingMetadataException$1() {
        return new Supplier<IllegalArgumentException>(null){

            public IllegalArgumentException get() {
                return new IllegalArgumentException("TokenMap Metadata Missing");
            }
        };
    }

    public static final /* synthetic */ void $anonfun$getAsyncWriterInternal$4(RichStatement stmt) {
    }

    public TableWriter(CassandraConnector connector, TableDef tableDef, IndexedSeq<ColumnRef> columnSelector, RowWriter<T> rowWriter, WriteConf writeConf) {
        this.connector = connector;
        this.tableDef = tableDef;
        this.columnSelector = columnSelector;
        this.rowWriter = rowWriter;
        this.writeConf = writeConf;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(!tableDef.isView(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append($this.tableDef.name()).append(" is a Materialized View and Views are not writable").toString());
        this.keyspaceName = tableDef.keyspaceName();
        this.tableName = tableDef.tableName();
        this.columnNames = (Seq)rowWriter.columnNames().diff(writeConf.optionPlaceholders());
        this.columns = (Seq)this.columnNames().map((Function1)tableDef.columnByName(), Seq$.MODULE$.canBuildFrom());
        this.isCounterUpdate = tableDef.columns().exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.isCounterColumn()));
        this.containsCollectionBehaviors = columnSelector.exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TableWriter.$anonfun$containsCollectionBehaviors$1(x$13)));
        this.isIdempotent = this.columns().exists((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.isCounterColumn())) ? false : columnSelector.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TableWriter.$anonfun$isIdempotent$2(this, x0$1)));
    }
}

