/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.datasource.CassandraScan;
import com.datastax.spark.connector.datasource.CassandraTable;
import com.datastax.spark.connector.datasource.ScanHelper;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.util.ConfigParameter$;
import com.datastax.spark.connector.util.DeprecatedConfigParameter;
import com.datastax.spark.connector.util.DeprecatedConfigParameter$;
import com.datastax.spark.connector.util.Logging;
import java.io.Serializable;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.cassandra.AlwaysOff$;
import org.apache.spark.sql.cassandra.AlwaysOn$;
import org.apache.spark.sql.cassandra.Automatic$;
import org.apache.spark.sql.cassandra.CassandraPredicateRules;
import org.apache.spark.sql.cassandra.DirectJoinSetting;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanRelation;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.sys.package$;

public final class CassandraSourceRelation$
implements Logging {
    public static CassandraSourceRelation$ MODULE$;
    private HiveConf hiveConf;
    private final String ReferenceSection;
    private final String TableOptions;
    private final ConfigParameter<Option<Object>> TableSizeInBytesParam;
    private final ConfigParameter<Option<String>> WriteTimeParam;
    private final ConfigParameter<Option<String>> TTLParam;
    private final ConfigParameter<List<CassandraPredicateRules>> AdditionalCassandraPushDownRulesParam;
    private final ConfigParameter<Object> SearchPredicateOptimizationRatioParam;
    private final ConfigParameter<String> SearchPredicateOptimizationParam;
    private final DeprecatedConfigParameter<String> SolrPredciateOptimizationParam;
    private final ConfigParameter<Object> DirectJoinSizeRatioParam;
    private final ConfigParameter<String> DirectJoinSettingParam;
    private final ConfigParameter<Object> InClauseToJoinWithTableConversionThreshold;
    private final DeprecatedConfigParameter<Object> DseInClauseToJoinWithTableConversionThreshold;
    private final ConfigParameter<Object> InClauseToFullTableScanConversionThreshold;
    private final DeprecatedConfigParameter<Object> DseInClauseToFullTableScanConversionThreshold;
    private final ConfigParameter<Object> IgnoreMissingMetaColumns;
    private final boolean proxyPerSourceRelationEnabled;
    private final String defaultClusterName;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;
    private volatile boolean bitmap$0;

    static {
        new CassandraSourceRelation$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    private HiveConf hiveConf$lzycompute() {
        CassandraSourceRelation$ cassandraSourceRelation$ = this;
        synchronized (cassandraSourceRelation$) {
            if (!this.bitmap$0) {
                this.hiveConf = new HiveConf();
                this.bitmap$0 = true;
            }
        }
        return this.hiveConf;
    }

    private HiveConf hiveConf() {
        return !this.bitmap$0 ? this.hiveConf$lzycompute() : this.hiveConf;
    }

    public String ReferenceSection() {
        return this.ReferenceSection;
    }

    public String TableOptions() {
        return this.TableOptions;
    }

    public ConfigParameter<Option<Object>> TableSizeInBytesParam() {
        return this.TableSizeInBytesParam;
    }

    public ConfigParameter<Option<String>> WriteTimeParam() {
        return this.WriteTimeParam;
    }

    public ConfigParameter<Option<String>> TTLParam() {
        return this.TTLParam;
    }

    public ConfigParameter<List<CassandraPredicateRules>> AdditionalCassandraPushDownRulesParam() {
        return this.AdditionalCassandraPushDownRulesParam;
    }

    public ConfigParameter<Object> SearchPredicateOptimizationRatioParam() {
        return this.SearchPredicateOptimizationRatioParam;
    }

    public ConfigParameter<String> SearchPredicateOptimizationParam() {
        return this.SearchPredicateOptimizationParam;
    }

    public DeprecatedConfigParameter<String> SolrPredciateOptimizationParam() {
        return this.SolrPredciateOptimizationParam;
    }

    public ConfigParameter<Object> DirectJoinSizeRatioParam() {
        return this.DirectJoinSizeRatioParam;
    }

    public ConfigParameter<String> DirectJoinSettingParam() {
        return this.DirectJoinSettingParam;
    }

    public ConfigParameter<Object> InClauseToJoinWithTableConversionThreshold() {
        return this.InClauseToJoinWithTableConversionThreshold;
    }

    public DeprecatedConfigParameter<Object> DseInClauseToJoinWithTableConversionThreshold() {
        return this.DseInClauseToJoinWithTableConversionThreshold;
    }

    public ConfigParameter<Object> InClauseToFullTableScanConversionThreshold() {
        return this.InClauseToFullTableScanConversionThreshold;
    }

    public DeprecatedConfigParameter<Object> DseInClauseToFullTableScanConversionThreshold() {
        return this.DseInClauseToFullTableScanConversionThreshold;
    }

    public ConfigParameter<Object> IgnoreMissingMetaColumns() {
        return this.IgnoreMissingMetaColumns;
    }

    private boolean proxyPerSourceRelationEnabled() {
        return this.proxyPerSourceRelationEnabled;
    }

    private Option<String> getProxyUser(SQLContext sqlContext) {
        LazyRef user$lzy = new LazyRef();
        boolean doAsEnabled = this.hiveConf().getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
        String string = this.hiveConf().getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION).toUpperCase();
        boolean bl = !"NONE".equals(string);
        boolean authenticationEnabled = bl;
        return doAsEnabled && authenticationEnabled ? new Some((Object)CassandraSourceRelation$.user$1(user$lzy).getUserName()) : None$.MODULE$;
    }

    public <K> Dataset<K> setDirectJoin(Dataset<K> ds, DirectJoinSetting directJoinSetting, Encoder<K> evidence$1) {
        LogicalPlan oldPlan = ds.queryExecution().logical();
        return Dataset$.MODULE$.apply(ds.sparkSession(), (LogicalPlan)oldPlan.transform((PartialFunction)new scala.Serializable(directJoinSetting){
            public static final long serialVersionUID = 0L;
            private final DirectJoinSetting directJoinSetting$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof DataSourceV2Relation) {
                    DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)A1;
                    CaseInsensitiveStringMap options = dataSourceV2Relation.options();
                    if (dataSourceV2Relation.table() instanceof CassandraTable) {
                        CaseInsensitiveStringMap x$1 = CassandraSourceRelation$.MODULE$.applyDirectJoinSetting(options, this.directJoinSetting$1);
                        Table x$2 = dataSourceV2Relation.copy$default$1();
                        Seq x$3 = dataSourceV2Relation.copy$default$2();
                        Option x$4 = dataSourceV2Relation.copy$default$3();
                        Option x$5 = dataSourceV2Relation.copy$default$4();
                        object = dataSourceV2Relation.copy(x$2, x$3, x$4, x$5, x$1);
                        return (B1)object;
                    }
                }
                if (A1 instanceof DataSourceV2ScanRelation) {
                    DataSourceV2ScanRelation dataSourceV2ScanRelation = (DataSourceV2ScanRelation)A1;
                    Scan scan = dataSourceV2ScanRelation.scan();
                    if (dataSourceV2ScanRelation.relation() instanceof CassandraTable && scan instanceof CassandraScan) {
                        CassandraScan cassandraScan = (CassandraScan)scan;
                        SparkConf x$6 = CassandraSourceRelation$.MODULE$.applyDirectJoinSetting(cassandraScan.consolidatedConf(), this.directJoinSetting$1);
                        SparkSession x$7 = cassandraScan.copy$default$1();
                        CassandraConnector x$8 = cassandraScan.copy$default$2();
                        TableDef x$9 = cassandraScan.copy$default$3();
                        ScanHelper.CqlQueryParts x$10 = cassandraScan.copy$default$4();
                        StructType x$11 = cassandraScan.copy$default$5();
                        ReadConf x$12 = cassandraScan.copy$default$6();
                        CassandraScan x$13 = cassandraScan.copy(x$7, x$8, x$9, x$10, x$11, x$12, x$6);
                        DataSourceV2Relation x$14 = dataSourceV2ScanRelation.copy$default$1();
                        Seq x$15 = dataSourceV2ScanRelation.copy$default$3();
                        Option x$16 = dataSourceV2ScanRelation.copy$default$4();
                        object = dataSourceV2ScanRelation.copy(x$14, (Scan)x$13, x$15, x$16);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x1) {
                DataSourceV2Relation dataSourceV2Relation;
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof DataSourceV2Relation && (dataSourceV2Relation = (DataSourceV2Relation)logicalPlan).table() instanceof CassandraTable) {
                    return true;
                }
                if (!(logicalPlan instanceof DataSourceV2ScanRelation)) return false;
                DataSourceV2ScanRelation dataSourceV2ScanRelation = (DataSourceV2ScanRelation)logicalPlan;
                Scan scan = dataSourceV2ScanRelation.scan();
                if (!(dataSourceV2ScanRelation.relation() instanceof CassandraTable)) return false;
                if (!(scan instanceof CassandraScan)) return false;
                return true;
            }
            {
                this.directJoinSetting$1 = directJoinSetting$1;
            }
        }), evidence$1);
    }

    public <K> DirectJoinSetting setDirectJoin$default$2() {
        return AlwaysOn$.MODULE$;
    }

    public String defaultClusterName() {
        return this.defaultClusterName;
    }

    public String directJoinSettingToString(DirectJoinSetting directJoinSetting) {
        String string;
        DirectJoinSetting directJoinSetting2 = directJoinSetting;
        if (AlwaysOn$.MODULE$.equals(directJoinSetting2)) {
            string = "on";
        } else if (AlwaysOff$.MODULE$.equals(directJoinSetting2)) {
            string = "off";
        } else if (Automatic$.MODULE$.equals(directJoinSetting2)) {
            string = "auto";
        } else {
            throw new MatchError((Object)directJoinSetting2);
        }
        return string;
    }

    public CaseInsensitiveStringMap applyDirectJoinSetting(CaseInsensitiveStringMap options, DirectJoinSetting directJoinSetting) {
        String value = this.directJoinSettingToString(directJoinSetting);
        return new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.DirectJoinSettingParam().name()), (Object)value)}))).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)options).asScala())).asJava());
    }

    public SparkConf applyDirectJoinSetting(SparkConf sparkConf, DirectJoinSetting directJoinSetting) {
        String value = this.directJoinSettingToString(directJoinSetting);
        return sparkConf.set(this.DirectJoinSettingParam().name(), value);
    }

    public Product getDirectJoinSetting(SparkConf conf) {
        Product product;
        String string = conf.get(this.DirectJoinSettingParam().name(), this.DirectJoinSettingParam().default()).toLowerCase();
        if ("auto".equals(string)) {
            product = Automatic$.MODULE$;
        } else if ("on".equals(string)) {
            product = AlwaysOn$.MODULE$;
        } else if ("off".equals(string)) {
            product = AlwaysOff$.MODULE$;
        } else {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(49).append("\n           |").append(string).append(" is not a valid ").append(this.DirectJoinSettingParam().name()).append(" value.\n           |").append(this.DirectJoinSettingParam().description()).toString())).stripMargin());
        }
        return product;
    }

    private static final /* synthetic */ UserGroupInformation user$lzycompute$1(LazyRef user$lzy$1) {
        UserGroupInformation userGroupInformation;
        LazyRef lazyRef = user$lzy$1;
        synchronized (lazyRef) {
            userGroupInformation = user$lzy$1.initialized() ? (UserGroupInformation)user$lzy$1.value() : (UserGroupInformation)user$lzy$1.initialize((Object)UserGroupInformation.getCurrentUser());
        }
        return userGroupInformation;
    }

    private static final UserGroupInformation user$1(LazyRef user$lzy$1) {
        return user$lzy$1.initialized() ? (UserGroupInformation)user$lzy$1.value() : CassandraSourceRelation$.user$lzycompute$1(user$lzy$1);
    }

    private CassandraSourceRelation$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.ReferenceSection = "Cassandra Datasource Parameters";
        this.TableOptions = "Cassandra Datasource Table Options";
        this.TableSizeInBytesParam = ConfigParameter$.MODULE$.apply("spark.cassandra.table.size.in.bytes", this.ReferenceSection(), None$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("Used by DataFrames Internally, will be updated in a future release to\n        |retrieve size from Cassandra. Can be set manually now")).stripMargin());
        this.WriteTimeParam = ConfigParameter$.MODULE$.apply("writetime", this.TableOptions(), None$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("Surfaces the Cassandra Row Writetime as a Column\n        |with the named specified. When reading use writetime.columnName=aliasForWritetime. This\n        |can be done for every column with a writetime. When Writing use writetime=columnName and the\n        |columname will be used to set the writetime for that row.")).stripMargin());
        this.TTLParam = ConfigParameter$.MODULE$.apply("ttl", this.TableOptions(), None$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("Surfaces the Cassandra Row TTL as a Column\n        |with the named specified. When reading use ttl.columnName=aliasForTTL. This\n        |can be done for every column with a TTL. When writing use writetime=columnName and the\n        |columname will be used to set the TTL for that row.")).stripMargin());
        this.AdditionalCassandraPushDownRulesParam = ConfigParameter$.MODULE$.apply("spark.cassandra.sql.pushdown.additionalClasses", this.ReferenceSection(), List$.MODULE$.empty(), new StringOps(Predef$.MODULE$.augmentString("A comma separated list of classes to be used (in order) to apply additional\n        | pushdown rules for Cassandra Dataframes. Classes must implement CassandraPredicateRules\n      ")).stripMargin());
        this.SearchPredicateOptimizationRatioParam = ConfigParameter$.MODULE$.apply("spark.sql.dse.search.autoRatio", this.ReferenceSection(), BoxesRunTime.boxToDouble((double)0.03), "When Search Predicate Optimization is set to auto, Search optimizations will be preformed if this parameter * the total number of rows is greater than the number of rows to be returned by the solr query");
        this.SearchPredicateOptimizationParam = ConfigParameter$.MODULE$.apply("spark.sql.dse.search.enableOptimization", this.ReferenceSection(), "auto", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(279).append("Enables SparkSQL to automatically replace Cassandra Pushdowns with DSE Search\n         |Pushdowns utilizing lucene indexes. Valid options are On, Off, and Auto. Auto enables\n         |optimizations when the solr query will pull less than ").append(this.SearchPredicateOptimizationRatioParam().name()).append(" * the\n         |total table record count").toString())).stripMargin());
        String x$1 = "spark.sql.dse.solr.enable_optimization";
        Some x$2 = new Some(this.SearchPredicateOptimizationParam());
        String x$3 = "DSE 6.0.0";
        Function1<String, String> x$4 = DeprecatedConfigParameter$.MODULE$.apply$default$3();
        String x$5 = DeprecatedConfigParameter$.MODULE$.apply$default$5();
        this.SolrPredciateOptimizationParam = DeprecatedConfigParameter$.MODULE$.apply(x$1, x$2, x$4, x$3, x$5);
        this.DirectJoinSizeRatioParam = ConfigParameter$.MODULE$.apply("directJoinSizeRatio", this.TableOptions(), BoxesRunTime.boxToDouble((double)0.9), new StringOps(Predef$.MODULE$.augmentString("\n         | Sets the threshold on when to perform a DirectJoin in place of a full table scan. When\n         | the size of the (CassandraSource * thisParameter) > The other side of the join, A direct\n         | join will be performed if possible.\n      ")).stripMargin());
        this.DirectJoinSettingParam = ConfigParameter$.MODULE$.apply("directJoinSetting", this.TableOptions(), "auto", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(264).append("Acceptable values, \"on\", \"off\", \"auto\"\n         |\"on\" causes a direct join to happen if possible regardless of size ratio.\n         |\"off\" disables direct join even when possible\n         |\"auto\" only does a direct join when the size ratio is satisfied see ").append(this.DirectJoinSizeRatioParam().name()).append("\n      ").toString())).stripMargin());
        this.InClauseToJoinWithTableConversionThreshold = ConfigParameter$.MODULE$.apply("spark.cassandra.sql.inClauseToJoinConversionThreshold", this.ReferenceSection(), BoxesRunTime.boxToLong((long)2500L), new StringOps(Predef$.MODULE$.augmentString("Queries with `IN` clause(s) are converted to JoinWithCassandraTable operation if the size of cross\n         |product of all `IN` value sets exceeds this value. To disable `IN` clause conversion, set this setting to 0.\n         |Query `select * from t where k1 in (1,2,3) and k2 in (1,2) and k3 in (1,2,3,4)` has 3 sets of `IN` values.\n         |Cross product of these values has size of 24.\n         ")).stripMargin());
        String x$6 = "spark.sql.dse.inClauseToJoinConversionThreshold";
        Some x$7 = new Some(this.InClauseToJoinWithTableConversionThreshold());
        String x$8 = "3.0.0";
        String x$9 = "Renamed since this is no longer DSE Specific";
        Function1<String, String> x$10 = DeprecatedConfigParameter$.MODULE$.apply$default$3();
        this.DseInClauseToJoinWithTableConversionThreshold = DeprecatedConfigParameter$.MODULE$.apply(x$6, x$7, x$10, x$8, x$9);
        this.InClauseToFullTableScanConversionThreshold = ConfigParameter$.MODULE$.apply("spark.cassandra.sql.inClauseToFullScanConversionThreshold", this.ReferenceSection(), BoxesRunTime.boxToLong((long)20000000L), new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(548).append("Queries with `IN` clause(s) are not converted to JoinWithCassandraTable operation if the size of cross\n         |product of all `IN` value sets exceeds this value. It is meant to stop conversion for huge `IN` values sets\n         |that may cause memory problems. If this limit is exceeded full table scan is performed.\n         |This setting takes precedence over ").append(this.InClauseToJoinWithTableConversionThreshold().name()).append(".\n         |Query `select * from t where k1 in (1,2,3) and k2 in (1,2) and k3 in (1,2,3,4)` has 3 sets of `IN` values.\n         |Cross product of these values has size of 24.\n         ").toString())).stripMargin());
        String x$11 = "spark.sql.dse.inClauseToFullScanConversionThreshold";
        Some x$12 = new Some(this.InClauseToFullTableScanConversionThreshold());
        String x$13 = "3.0.0";
        String x$14 = "Renamed because this is no longer DSE Specific";
        Function1<String, String> x$15 = DeprecatedConfigParameter$.MODULE$.apply$default$3();
        this.DseInClauseToFullTableScanConversionThreshold = DeprecatedConfigParameter$.MODULE$.apply(x$11, x$12, x$15, x$13, x$14);
        this.IgnoreMissingMetaColumns = ConfigParameter$.MODULE$.apply("ignoreMissingMetaColumns", this.TableOptions(), BoxesRunTime.boxToBoolean((boolean)false), new StringOps(Predef$.MODULE$.augmentString("Acceptable values, \"true\", \"false\"\n         |\"true\" ignore missing meta properties\n         |\"false\" throw error if missing property is requested\n      ")).stripMargin());
        this.proxyPerSourceRelationEnabled = new StringOps(Predef$.MODULE$.augmentString((String)package$.MODULE$.env().getOrElse((Object)"DSE_ENABLE_PROXY_PER_SRC_RELATION", (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
        this.defaultClusterName = "default";
    }
}

