/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.base.osgi;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

class BundleSet {
    private final Map<String, Bundle> symbolicName2bundle = new ConcurrentHashMap<String, Bundle>();
    private final Map<Long, Bundle> id2bundle = new ConcurrentHashMap<Long, Bundle>();

    BundleSet() {
    }

    Collection<Bundle> getAll() {
        return this.symbolicName2bundle.values();
    }

    Bundle get(String symbolicName) {
        return this.symbolicName2bundle.get(symbolicName);
    }

    Bundle get(long id) {
        return this.id2bundle.get(id);
    }

    void add(Bundle bundle) throws BundleException {
        Bundle existingBundle = this.symbolicName2bundle.put(bundle.getSymbolicName(), bundle);
        if (null != existingBundle) {
            throw new BundleException(String.format("Bundle '%s' (ID: %d) is already part of collection with ID %d.", bundle.getSymbolicName(), bundle.getBundleId(), existingBundle.getBundleId()), 9);
        }
        Bundle bundleWithSameID = this.id2bundle.put(bundle.getBundleId(), bundle);
        if (null != bundleWithSameID) {
            throw new BundleException(String.format("Bundle ID '%d' for '%s' is already used by '%s'.", bundle.getBundleId(), bundle.getSymbolicName(), bundleWithSameID.getSymbolicName()), 9);
        }
    }
}

